/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.validator;

import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.ametys.cms.contenttype.validation.AbstractContentValidator;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.data.holder.values.SynchronizableValue;
import org.ametys.plugins.repository.data.holder.values.UntouchedValue;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.View;
import org.ametys.runtime.parameter.ValidationResult;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ContainerMccRegimeValidator
extends AbstractContentValidator
implements Serviceable {
    protected PilotageHelper _pilotageHelper;
    private boolean _isForceMode;

    public void service(ServiceManager manager) throws ServiceException {
        this._pilotageHelper = (PilotageHelper)((Object)manager.lookup(PilotageHelper.ROLE));
    }

    public void initialize() throws ConfigurationException {
        super.initialize();
        this._isForceMode = this._pilotageHelper.getMCCRegimePolicy().equals("FORCE");
    }

    public ValidationResult validate(Content content) {
        ValidationResult result = new ValidationResult();
        if (this._isForceMode && this._pilotageHelper.isContainerOfTypeYear(content)) {
            if (Optional.of("mccRegime").filter(arg_0 -> ((Content)content).hasValue(arg_0)).map(arg_0 -> ((Content)content).getValue(arg_0)).flatMap(ContentValue::getContentIfExists).isEmpty()) {
                result.addError(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CONTAINER_MCCREGIME_VALIDATOR_ERROR", Map.of("fieldRegime", content.getDefinition("mccRegime").getLabel(), "forceValue", new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CONFIG_MCC_RESTRICTIONS_POLICY_FORCE"))));
            }
        }
        return result;
    }

    public ValidationResult validate(Content content, Map<String, Object> values, View view) {
        ValidationResult result = new ValidationResult();
        if (this._isForceMode && content instanceof Container) {
            Container container = (Container)content;
            if (view.hasModelViewItem("mccRegime") && !(values.get("mccRegime") instanceof UntouchedValue)) {
                if (Optional.of("mccRegime").map(values::get).map(SynchronizableValue.class::cast).map(sv -> sv.getValue(Optional.ofNullable(sv.getExternalizableStatus()))).map(ContentValue.class::cast).flatMap(ContentValue::getContentIfExists).map(AmetysObject::getId).isEmpty()) {
                    String nature = Optional.of("nature").map(values::get).filter(Predicate.not(UntouchedValue.class::isInstance)).map(SynchronizableValue.class::cast).map(sv -> sv.getValue(Optional.ofNullable(sv.getExternalizableStatus()))).map(ContentValue.class::cast).map(ContentValue::getContentId).orElseGet(() -> container.getNature());
                    if (nature != null) {
                        if (this._pilotageHelper.getYearId().map(nature::equals).orElse(false).booleanValue()) {
                            result.addError(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CONTAINER_MCCREGIME_VALIDATOR_ERROR", Map.of("fieldRegime", content.getDefinition("mccRegime").getLabel(), "forceValue", new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CONFIG_MCC_RESTRICTIONS_POLICY_FORCE"))));
                        }
                    }
                }
            }
        }
        return result;
    }
}

