<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:su="org.ametys.core.util.StringUtils"
                xmlns:exsl="http://exslt.org/common"
                exclude-result-prefixes="i18n exsl su">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/params/maquette.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/utils.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/xls.xsl"/>
    
    <xsl:variable name="naturesEnseignementByCategory">
        <xsl:for-each select="/report/items[@id = 'odf-enumeration.EnseignementNature']/category">
            <xsl:sort select="@order" data-type="number"/>
            <xsl:sort select="@code" data-type="text"/>
            
            <xsl:variable name="items">
                <xsl:for-each select="item">
                    <xsl:sort select="@order" data-type="number"/>
                    <xsl:sort select="@code" data-type="text"/>
                    
                    <xsl:if test="@archived = 'false' or //volumeHoraire[@nature = current()/@id]">
                        <item id="{@id}" code="{@code}"><xsl:value-of select="."/></item>
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            
            <xsl:if test="count(exsl:node-set($items)/item) > 0">
                <category code="{@code}">
                    <xsl:copy-of select="$items"/>
                </category>
            </xsl:if>
        </xsl:for-each>
    </xsl:variable>
    
    <xsl:variable name="nbNatureEnseignement" select="count(exsl:node-set($naturesEnseignementByCategory)/*)"/>
        
    <xsl:variable name="nbColumns" select="5 + $nbNatureEnseignement + $showCodeApogee + (2 * $showShared)"/>
    
    <xsl:template name="css-styles">
        .h1, .h2, .h3
        {
            text-align: center;
            font-weight: bold;
        }
        
        .h1, .h2
        {
            font-size: 15pt;
        }
        
        .h3
        {
            font-size: 13.5pt;
        }
        
        .h4
        {
            font-size: 12pt;
            font-weight: bold;
            color: darkblue;
        }
        
        table
        {
            font-size: 7.5pt;
            width: 100%;
            padding: 0px;
            margin: 0px;
        }
        
        thead tr td
        {
            font-weight: bold;
            text-align: center;
            background-color: darkblue;
            color: white;
            vertical-align: middle;
        }
        
        td 
        { 
            padding: 0px;
            margin: 0px;
            border-bottom:0.5pt solid  #333333;
        }
        
        .border
        { 
            border-left:0.5pt solid  #333333;
            text-align:center;
        }
        
        .codeEtapePorteuse
        { 
            border-left:0.5pt solid  #333333;
            text-align:left;
        }
        
        .codeAmetys
        {
            color: #777777;
        }
        
        .choisirElement
        {
            color: red;
        }
        
        .etapePorteuse
        {
            background-color: #DDDDDD;
        }
        .legend td
        {
            border:0;
        }
    </xsl:template>
    
    <xsl:template name="table-head">
        <tr>
            <td style="width: 2cm;">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_CODE_AMETYS"/>
            </td>
            <xsl:if test="$showCodeApogee">
                <td style="width: 2cm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_CODE_APOGEE"/></td>
            </xsl:if>
            <td style="width: 12cm;"/>
            <td style="width: 2cm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_NATURE"/></td>
            <td style="width: 1cm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_ECTS"/></td>
            <xsl:if test="$showShared">
                <td style="width: 1cm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_PARTAGE_ABREV"/></td>
                <td style="width: 1cm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_OCCURRENCE_ABREV"/></td>
            </xsl:if>
            <xsl:for-each select="exsl:node-set($naturesEnseignementByCategory)/category">
                <td><xsl:value-of select="su:sanitizeXlsHtml(@code)"/></td>
            </xsl:for-each>
            <td style="width: 4cm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_ETAPE_PORTEUSE"/></td>
        </tr>
    </xsl:template>
    
    <xsl:template name="table-body">
        <xsl:apply-templates select="program" />
        <xsl:call-template name="legend"/>
    </xsl:template>
    
    <xsl:template match="program">
        <tr>
            <td colspan="{$nbColumns}" class="h1">
                <xsl:value-of select="su:sanitizeXlsHtml(@formation)" />
                <xsl:if test="@COD_DIP != ''">
                 - <xsl:value-of select="@COD_DIP" />
                </xsl:if>
                <xsl:if test="@COD_VDI != ''">
                 - <xsl:value-of select="@COD_VDI" />
                </xsl:if>
            </td>
        </tr>
        
        <xsl:apply-templates />
    </xsl:template>
    
    <xsl:template match="subprogram">
        <tr>
            <td colspan="{$nbColumns}" class="h2">
                <xsl:value-of select="su:sanitizeXlsHtml(@parcours)" />
            </td>
        </tr>
        
        <xsl:apply-templates />
    </xsl:template>
    
    <xsl:template match="container[@type='annee']">
        <tr>
            <td colspan="{$nbColumns}" class="h3">
                <xsl:value-of select="su:sanitizeXlsHtml(@libelle)" /><xsl:if test="@COD_ETP != ''"><xsl:text> </xsl:text>(<xsl:value-of select="@COD_ETP" /><xsl:if test="@COD_VRS_ETP != ''">-<xsl:value-of select="@COD_VRS_ETP" /></xsl:if>)</xsl:if>
            </td>
        </tr>
        
        <xsl:apply-templates>
            <xsl:with-param name="COD_ETP_YEAR">
                <xsl:value-of select="@id"/>
            </xsl:with-param>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="container[not(@type='annee')]">
        <xsl:param name="COD_ETP_YEAR" />
        
        <tr>
            <td colspan="{$nbColumns}" class="h4">
                <xsl:value-of select="su:sanitizeXlsHtml(@libelle)" />
            </td>
        </tr>
        
        <xsl:apply-templates>
            <xsl:with-param name="COD_ETP_YEAR">
                <xsl:value-of select="$COD_ETP_YEAR"/>
            </xsl:with-param>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="courselist">
        <xsl:param name="COD_ETP_YEAR" />
    
        <xsl:apply-templates select="." mode="child">
            <xsl:with-param name="indent">0</xsl:with-param>
            <xsl:with-param name="COD_ETP_YEAR">
                <xsl:value-of select="$COD_ETP_YEAR"/>
            </xsl:with-param>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="courselist" mode="child">
        <xsl:param name="indent" />
        <xsl:param name="COD_ETP_YEAR" />
        
        <xsl:if test="@choice">
            <tr>
                <td></td>
                <td colspan="{$nbColumns - 1}" class="choisirElement">
                    <xsl:call-template name="recursive-print">
                        <xsl:with-param name="times" select="$indent - 1" />
                    </xsl:call-template>
                    
                    <xsl:variable name="isPlural"><xsl:if test="@choice > 1"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_CHOICE_ELEMENTS"/>S</xsl:if></xsl:variable>
                    <i18n:translate>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_CHOICE_ELEMENT{$isPlural}"/>
                        <i18n:param><xsl:value-of select="@choice" /></i18n:param>
                    </i18n:translate>
                </td>
            </tr>
        </xsl:if>
        <xsl:if test="@optional">
            <tr>
                <td></td>
                <td colspan="{$nbColumns - 1}" class="choisirElement">
                    <xsl:call-template name="recursive-print">
                        <xsl:with-param name="times" select="$indent - 1" />
                    </xsl:call-template>
                    <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_ENSEIGNEMENTS_FACULTATIFS"/>
                </td>
            </tr>
        </xsl:if>
        <xsl:apply-templates select="course">
            <xsl:with-param name="indent">
                <xsl:value-of select="$indent"/>
            </xsl:with-param>
            <xsl:with-param name="COD_ETP_YEAR">
                <xsl:value-of select="$COD_ETP_YEAR"/>
            </xsl:with-param>
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="course">
        <xsl:param name="indent" />
        <xsl:param name="COD_ETP_YEAR" />
        
        <tr>
            <xsl:if test="@etapePorteuse and not($COD_ETP_YEAR = @idEtapePorteuse)">
                <xsl:attribute name="class">etapePorteuse</xsl:attribute>
            </xsl:if>
            <td class="codeAmetys">
                <xsl:value-of select="su:sanitizeXlsHtml(@CodeAmetysELP)" />
            </td>
            <xsl:if test="$showCodeApogee">
                <td>
                    <xsl:value-of select="su:sanitizeXlsHtml(@CodeApogee)" />
                </td>
            </xsl:if>
            <td>
                <xsl:if test="$indent = 0"><xsl:attribute name="style">font-size:9pt;</xsl:attribute></xsl:if>
                <xsl:call-template name="recursive-print">
                    <xsl:with-param name="times" select="$indent" />
                </xsl:call-template>
                <xsl:call-template name="courseLabel"/>
            </td>
            <td class="border">
                <xsl:value-of select="su:sanitizeXlsHtml(@natureElement)" />
            </td>
            <td class="border">
                <xsl:call-template name="display-double">
                    <xsl:with-param name="value" select="@ects" />
                </xsl:call-template>
            </td>
            <xsl:if test="$showShared">
                <td class="border">
                    <xsl:value-of select="partage"/>
                </td>
                <td class="border">
                    <xsl:value-of select="occurrences"/>
                </td>
            </xsl:if>
            <xsl:variable name="currentCourse" select="."/> 
            <xsl:for-each select="exsl:node-set($naturesEnseignementByCategory)/category">
                <td class="border">
                    <xsl:for-each select="item">
                        <xsl:if test="count($currentCourse/volumeHoraire[@nature = current()/@id]) > 0">
                            <xsl:call-template name="display-double">
                                <xsl:with-param name="value"><xsl:value-of select="sum($currentCourse/volumeHoraire[@nature = current()/@id])"/></xsl:with-param>
                            </xsl:call-template>
                            <xsl:if test="@code != ../@code">
                                <xsl:text> </xsl:text>(<xsl:value-of select="@code"/>)
                            </xsl:if>
                            <br/>
                        </xsl:if>
                    </xsl:for-each>
                </td>
            </xsl:for-each>
            <td class="codeEtapePorteuse">
                <xsl:if test="@etapePorteuse">
                    <xsl:value-of select="su:sanitizeXlsHtml(@etapePorteuse)" /><xsl:if test="@codeEtapePorteuse != ''"><xsl:text> </xsl:text>(<xsl:value-of select="@codeEtapePorteuse" />)</xsl:if> 
                </xsl:if>
            </td>
        </tr>

        <xsl:apply-templates select="courselist" mode="child">
            <xsl:with-param name="indent">
                <xsl:value-of select="$indent + 1"/>
            </xsl:with-param>
            <xsl:with-param name="COD_ETP_YEAR">
                <xsl:value-of select="$COD_ETP_YEAR"/>
            </xsl:with-param>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template name="legend">
        <tr class="legend"/>
        <tr class="legend"><td><strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_LEGEND_TITLE"/></strong></td></tr>
        <tr class="legend">
            <td class="etapePorteuse"/>
            <td colspan="{$nbColumns - 1}">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_LEGEND_COURSE_DIFFERENT_STEP_HOLDER"/>
            </td>
        </tr>
        <xsl:if test="$showShared">
            <tr class="legend">
                <td><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_PARTAGE_ABREV"/></td>
                <td colspan="{$nbColumns - 1}">
                    <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_PARTAGE"/>
                </td>
            </tr>
            <tr class="legend">
                <td><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_OCCURRENCE_ABREV"/></td>
                <td colspan="{$nbColumns - 1}">
                    <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_OCCURRENCE"/>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>

    <xsl:template name="courseLabel">
        <xsl:if test="$showShortLabel and shortLabel != ''">
            <xsl:value-of select="su:sanitizeXlsHtml(shortLabel)"/><xsl:text> </xsl:text>
        </xsl:if>
        <xsl:value-of select="su:sanitizeXlsHtml(libelle)" />
    </xsl:template>
</xsl:stylesheet>
