<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:cms="http://ametys.org/cms/3.0" 
                              xmlns:exsl="http://exslt.org/common"
                              exclude-result-prefixes="i18n docbook exsl"
                              extension-element-prefixes="cms">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/thematics/export/container/common/common.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/thematics/export/common2doc.xsl" />
    
    <xsl:variable name="thematicsRoot" select="/root/thematics"/>
    
    <xsl:template match="/">
        <xsl:apply-templates select="/root/thematics"/>
    </xsl:template>
    
    <xsl:template match="/root/thematics">
        <xsl:call-template name="root"/>
    </xsl:template>
    
    <xsl:template name="common-styles"/>
    
    <xsl:template name="additional-css-styles">
        <xsl:copy-of select="//style/node()" />
        
        #<xsl:value-of select="$uniqueSectionId"/> .export-content p
        {
            margin-top: 4pt;
            text-align: justify;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> .rules
        {
            margin-left: 1cm;
            margin-top: 0;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> .derogated
        {
            color: <xsl:value-of select="$color-derogated" />;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> .new
        {
            color: <xsl:value-of select="$color-new" />;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> .motivation
        {
            color: <xsl:value-of select="$color-motivation" />;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> .motivation-title
        {
            text-decoration: underline;
            margin-bottom: 0;
            text-align: left;
        }
    </xsl:template>
    
    <xsl:template name="doc-title">
        <xsl:call-template name="title-label"/> - <xsl:value-of select="$thematicsRoot/container/title"/> - <xsl:value-of select="$thematicsRoot/container/catalog"/>
    </xsl:template>

    <xsl:template name="doc-body">
        <div class="{$orientation}" id="{$uniqueSectionId}">
            <xsl:call-template name="common-structure" />
            <xsl:call-template name="body"/>
        </div>
        <xsl:if test="//br[@class='new-page']">
            <xsl:call-template name="new-section" />
            <xsl:apply-templates select="//body/*" mode="html"/>
        </xsl:if>
    </xsl:template>
     
    <xsl:template match="*" mode="html">
        <xsl:copy>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates select="node()" mode="html"/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="comment()|text()" mode="html">
        <xsl:copy-of select="."/>
    </xsl:template>
    
    <xsl:template match="p[@id='first-page']" mode="html"/>
    
    <xsl:template match="br[@class='new-page'][not(preceding::br[@class='new-page'])]" mode="html"/>
    
    <xsl:template match="table[@class='headerFooterDefinition']" mode="html">
        <xsl:call-template name="common-structure"/>
    </xsl:template>
    
    <xsl:template name="body">
        <xsl:call-template name="title"/>
        
        <xsl:variable name="non-empty-thematics">
            <xsl:call-template name="get-non-empty-thematics"/>
        </xsl:variable>
        
        <xsl:call-template name="contents">
            <xsl:with-param name="contents" select="exsl:node-set($non-empty-thematics)/*"/>
        </xsl:call-template>
        
        <xsl:apply-templates select="container-rules/thematics/entry[rules/entry]">
            <xsl:sort select="@name" data-type="number"/>
        </xsl:apply-templates>
        
        <xsl:call-template name="specific-data"/>
    </xsl:template>
    
    <xsl:template name="title">
        <h1><xsl:call-template name="title-label"/></h1>
        <h2><xsl:value-of select="container/catalog"/></h2>
        <h2><xsl:value-of select="container/title"/></h2>
    </xsl:template>
    
    <xsl:template name="contents">
        <xsl:param name="contents"/>
        
        <xsl:apply-templates select="$contents">
            <xsl:sort select="cms:getOrder(order)" data-type="number"/>
            <xsl:sort select="title" order="ascending"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="content">
        <h3 style="page-break-after:avoid;"><xsl:call-template name="thematic-title"/></h3>
        <div class="rules">
            <xsl:call-template name="rules"/>
        </div>
    </xsl:template>
    
    <xsl:template name="thematic-title">
        <xsl:value-of select="title"/>
    </xsl:template>
    
    <xsl:template name="rules">
        <xsl:for-each select="rules/entry[status/@value != 'SUSPENDED']">
            <xsl:variable name="derogatedRule" select="$containerRules[code = current()/code]"/>
            <xsl:choose>
                <xsl:when test="$derogatedRule">
                    <xsl:apply-templates select="$derogatedRule" mode="derogated-rule"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="." mode="general-rule"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
        <xsl:variable name="thematicCode" select="current()/code"/>
        <xsl:apply-templates select="$containerRules[thematicCode = $thematicCode]" mode="new-rule"/>
    </xsl:template>
    
    <xsl:template match="entry">
        <h3 class="new" style="page-break-after: avoid;"><xsl:value-of select="title"/></h3>
        <div class="rules">
            <xsl:apply-templates select="rules/entry" mode="new-rule"/>
        </div>
    </xsl:template>
    
    <xsl:template match="entry" mode="new-rule">
        <div class="export-content">
            <div class="new">
                <xsl:apply-templates select="text/docbook:article"/>
            </div>
        
            <xsl:if test="$displayMotivation and cms:isNotRichTextEmpty(motivation)">
                <div class="motivation">
                    <p class="motivation-title" style="page-break-after:avoid;"><i18n:text key="PLUGINS_ODF_PILOTAGE_EXPORT_MOTIVATION_ADDITIONAL" catalogue="plugin.odf-pilotage"/></p>
                    <xsl:apply-templates select="motivation/docbook:article"/>
                </div>
            </xsl:if>
        </div>
    </xsl:template>
    
    <xsl:template match="entry" mode="derogated-rule">
        <div class="export-content">
            <div class="derogated">
                <xsl:apply-templates select="text/docbook:article"/>
            </div>
        
            <xsl:if test="$displayMotivation and cms:isNotRichTextEmpty(motivation)">
                <div class="motivation">
                    <p class="motivation-title" style="page-break-after:avoid;"><i18n:text key="PLUGINS_ODF_PILOTAGE_EXPORT_MOTIVATION_DEROGATION" catalogue="plugin.odf-pilotage"/></p>
                    <xsl:apply-templates select="motivation/docbook:article"/>
                </div>
            </xsl:if>
        </div>
    </xsl:template>
    
    <xsl:template match="entry" mode="general-rule">
        <div class="export-content">
            <xsl:apply-templates select="text/docbook:article"/>
        </div>
    </xsl:template>
    
    <xsl:template name="specific-data"/>
</xsl:stylesheet>
