/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.cost.eqtd;

import org.ametys.plugins.odfpilotage.cost.entity.ProgramItemData;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * Interface of a cost computation mode.
 */
public interface EqTDComputationMode
{
    /**
     * Retrieves the id of the computation mode.
     * @return the id.
     */
    public String getId();
    
    /**
     * Retrieves the label of the computation mode.
     * @return the label.
     */
    public I18nizableText getLabel();

    /**
     * Retrieves the description of the computation mode.
     * @return the description.
     */
    public I18nizableText getDescription();

    /**
     * Compute the TD equivalent for the given course part data.
     * @param programItemData The course part data
     * @param eqTDCoef The TD equivalent coefficient
     * @return The computed eqTD from the course part data
     */
    public Double computeEqTD(ProgramItemData programItemData, Double eqTDCoef);
}
