/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.enumerators;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.plugins.odfpilotage.cost.eqtd.EqTDComputationMode;
import org.ametys.plugins.odfpilotage.cost.eqtd.EqTDComputationModeExtensionPoint;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;

/**
 * {@link Enumerator} for the TD equivalent computation mode
 */
public class EqTDComputationModeEnumerator implements Enumerator<String>, Serviceable, org.ametys.runtime.parameter.Enumerator
{
    /** The TD equivalent computation mode extension point */
    protected EqTDComputationModeExtensionPoint _eqTDComputationModeEP;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        _eqTDComputationModeEP = (EqTDComputationModeExtensionPoint) smanager.lookup(EqTDComputationModeExtensionPoint.ROLE);
    }

    @Override
    public I18nizableText getEntry(String value) throws Exception
    {
        EqTDComputationMode analysis = _eqTDComputationModeEP.getExtension(value);
        return analysis.getLabel();
    }

    @Override
    public Map<String, I18nizableText> getTypedEntries() throws Exception
    {
        Map<String, I18nizableText> entries = _eqTDComputationModeEP.getExtensionsIds()
            .stream()
            .map(_eqTDComputationModeEP::getExtension)
            .collect(Collectors.toMap(EqTDComputationMode::getId, EqTDComputationMode::getLabel));
        
        return entries;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Map<Object, I18nizableText> getEntries() throws Exception
    {
        return (Map<Object, I18nizableText>) (Object) getTypedEntries();
    }

    @Override
    // TODO NEWATTRIBUTEAPI: remove this method when org.ametys.runtime.parameter.Enumerator will be removed
    public Map<String, Object> getConfiguration()
    {
        return Collections.EMPTY_MAP;
    }
}
