/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.actions;

import java.util.ArrayList;
import java.util.List;
import org.ametys.cms.repository.Content;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfpilotage.actions.AbstractProgramItemHistoryAction;
import org.ametys.plugins.odfpilotage.helper.AbstractWorkflowHelper;
import org.ametys.plugins.odfpilotage.helper.PilotageStatusHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ODFPilotageContentHistoryAction
extends AbstractProgramItemHistoryAction {
    protected PilotageStatusHelper _pilotageStatusHelper;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._pilotageStatusHelper = (PilotageStatusHelper)((Object)serviceManager.lookup(PilotageStatusHelper.ROLE));
    }

    protected Program getParentProgramItemForHistory(ProgramItem programItem) {
        return this._pilotageStatusHelper.getParentProgramWithHigherPilotageStatus(programItem);
    }

    @Override
    protected List<AbstractWorkflowHelper.ODFWorkflowStep> getWorkflowSteps(ProgramItem programItem) {
        ArrayList<AbstractWorkflowHelper.ODFWorkflowStep> workflowSteps = new ArrayList<AbstractWorkflowHelper.ODFWorkflowStep>();
        if (programItem instanceof Program) {
            Program program = (Program)programItem;
            PilotageStatusHelper.PilotageStatus pilotageStatus = this._pilotageStatusHelper.getPilotageStatus((Content)program);
            switch (pilotageStatus) {
                case MENTION_VALIDATED: {
                    workflowSteps.add(this._pilotageStatusHelper.getMentionValidationStep((Content)program));
                    break;
                }
                case ORGUNIT_VALIDATED: {
                    workflowSteps.add(this._pilotageStatusHelper.getOrgUnitValidationStep((Content)program));
                    workflowSteps.add(this._pilotageStatusHelper.getMentionValidationStep((Content)program));
                    break;
                }
                case CFVU_VALIDATED: {
                    workflowSteps.add(this._pilotageStatusHelper.getCFVUValidationStep((Content)program));
                    workflowSteps.add(this._pilotageStatusHelper.getOrgUnitValidationStep((Content)program));
                    workflowSteps.add(this._pilotageStatusHelper.getMentionValidationStep((Content)program));
                    break;
                }
            }
        }
        return workflowSteps;
    }
}

