/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.dashboard;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.search.SearchResults;
import org.ametys.cms.search.content.ContentSearcherFactory;
import org.ametys.cms.search.query.AndQuery;
import org.ametys.cms.search.query.ContentQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.cms.search.query.StringQuery;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.plugins.odfpilotage.helper.MCCWorkflowHelper;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.plugins.odfpilotage.helper.PilotageStatusHelper;
import org.ametys.plugins.odfpilotage.rule.RulesManager;
import org.ametys.plugins.odfpilotage.rule.ThematicsHelper;
import org.ametys.plugins.odfpilotage.rule.enumerators.NbSessionsEnumerator;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class PilotageDashboardHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    private static final DecimalFormat _DECIMAL_FORMAT = new DecimalFormat("#.#");
    private static final String _PILOTAGE_DASHBOARD_RIGHT = "ODF_Rights_Pilotage_Dashboard";
    protected ODFHelper _odfHelper;
    protected ContentSearcherFactory _contentSearcherFactory;
    protected AmetysObjectResolver _resolver;
    protected ContentHelper _contentHelper;
    protected ThematicsHelper _thematicsHelper;
    protected RightManager _rightManager;
    protected PilotageHelper _pilotageHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        this._odfHelper = (ODFHelper)smanager.lookup(ODFHelper.ROLE);
        this._contentSearcherFactory = (ContentSearcherFactory)smanager.lookup(ContentSearcherFactory.ROLE);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._contentHelper = (ContentHelper)smanager.lookup(ContentHelper.ROLE);
        this._thematicsHelper = (ThematicsHelper)smanager.lookup(ThematicsHelper.ROLE);
        this._rightManager = (RightManager)smanager.lookup(RightManager.ROLE);
        this._pilotageHelper = (PilotageHelper)((Object)smanager.lookup(PilotageHelper.ROLE));
    }

    private boolean _checkRightOnOrgunit(OrgUnit orgUnit) {
        if (this._rightManager.currentUserHasRight(_PILOTAGE_DASHBOARD_RIGHT, (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW) {
            return true;
        }
        return orgUnit != null ? this._rightManager.currentUserHasRight(_PILOTAGE_DASHBOARD_RIGHT, (Object)orgUnit) == RightManager.RightResult.RIGHT_ALLOW : false;
    }

    @Callable(rights={""})
    public boolean isRulesEnabled() {
        return RulesManager.isRulesEnabled();
    }

    @Callable(rights={""})
    public Map<String, Object> getOrgUnits(Map<String, Object> params) {
        ArrayList<Map<String, Object>> orgUnitsAsMap = new ArrayList<Map<String, Object>>();
        if (this._rightManager.currentUserHasRight(_PILOTAGE_DASHBOARD_RIGHT, (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW) {
            orgUnitsAsMap.add(Map.of("id", " ", "label", new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_DASHBOARD_ORGUNITS_ALL")));
        }
        ContentTypeExpression expr = new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.odf.Content.orgunit"});
        String xPathQuery = QueryHelper.getXPathQuery(null, (String)"ametys:orgunitContent", (Expression)expr);
        List<OrgUnit> orgUnits = this._resolver.query(xPathQuery).stream().filter(OrgUnit.class::isInstance).map(OrgUnit.class::cast).filter(this::_checkRightOnOrgunit).toList();
        for (OrgUnit orgUnit : orgUnits) {
            orgUnitsAsMap.add(Map.of("id", orgUnit.getId(), "label", orgUnit.getTitle()));
        }
        return Map.of("orgUnits", orgUnitsAsMap);
    }

    @Callable(rights={""})
    public List<Map<String, Object>> getRulesStats(String catalog, String orgUnitId) throws IllegalAccessException {
        OrgUnit orgUnit;
        OrgUnit orgUnit2 = orgUnit = StringUtils.isNotBlank((CharSequence)orgUnitId) ? (OrgUnit)this._resolver.resolveById(orgUnitId) : null;
        if (!this._checkRightOnOrgunit(orgUnit)) {
            throw new IllegalAccessException("Unable to get stats on orgUnit with id '" + orgUnitId + "' because user has no sufficient right");
        }
        ArrayList<Map<String, Object>> stats = new ArrayList<Map<String, Object>>();
        if (this._pilotageHelper.getYearId().isEmpty()) {
            return stats;
        }
        try {
            SearchResults search = this._contentSearcherFactory.create(new String[]{"org.ametys.plugins.odf.Content.container"}).withLimits(0, Integer.MAX_VALUE).withFacets(List.of("overridenThematics")).setCheckRights(false).searchWithFacets(this._getFilterQuery("org.ametys.plugins.odf.Content.container", catalog, orgUnitId));
            long total = search.getTotalCount();
            Map facetResults = search.getFacetResults();
            Map overridenThematics = (Map)facetResults.get("overridenThematics");
            List sortedThematics = overridenThematics.entrySet().stream().sorted((e1, e2) -> Integer.compare((Integer)e2.getValue(), (Integer)e1.getValue())).toList();
            boolean hasRight = this._thematicsHelper.hasHandleThematicRight();
            NbSessionsEnumerator nbSessionsEnumerator = new NbSessionsEnumerator();
            for (Map.Entry entry : sortedThematics) {
                Content thematic = (Content)this._resolver.resolveById((String)entry.getKey());
                stats.add(this._thematic2JSON(thematic, (Integer)entry.getValue(), total, nbSessionsEnumerator, hasRight));
            }
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred requesting solr", (Throwable)e);
        }
        return stats;
    }

    private Map<String, Object> _thematic2JSON(Content thematic, Integer number, Long total, NbSessionsEnumerator nbSessionsEnumerator, boolean hasRight) throws Exception {
        String regimesAsString = Stream.of((ContentValue[])thematic.getValue("regime", false, (Object)new ContentValue[0])).map(c -> this._getRegimeLabel((ContentValue)c)).collect(Collectors.joining(", "));
        String nbSessionsValue = (String)thematic.getValue("nbSessions");
        I18nizableText nbSessions = StringUtils.isNotBlank((CharSequence)nbSessionsValue) ? nbSessionsEnumerator.getEntry(nbSessionsValue) : null;
        HashMap<String, Object> thematicAsJson = new HashMap<String, Object>();
        thematicAsJson.put("thematic", thematic.getId());
        thematicAsJson.put("thematicTitle", thematic.getTitle());
        thematicAsJson.put("number", number);
        thematicAsJson.put("pourcent", total != 0L ? _DECIMAL_FORMAT.format(number.floatValue() * 100.0f / (float)total.longValue()) : Double.valueOf(0.0));
        thematicAsJson.put("regime", regimesAsString);
        thematicAsJson.put("nbSessions", nbSessions);
        thematicAsJson.put("total", total);
        thematicAsJson.put("hasRight", hasRight);
        return thematicAsJson;
    }

    private String _getRegimeLabel(ContentValue contentValue) {
        if (contentValue.hasValue("shortLabel")) {
            return (String)contentValue.getValue("shortLabel");
        }
        return contentValue.getContent().getTitle();
    }

    @Callable(rights={""})
    public List<Map<String, Object>> getPilotageWorkflowStats(String catalog, String orgUnitId) throws IllegalAccessException {
        OrgUnit orgUnit;
        OrgUnit orgUnit2 = orgUnit = StringUtils.isNotBlank((CharSequence)orgUnitId) ? (OrgUnit)this._resolver.resolveById(orgUnitId) : null;
        if (!this._checkRightOnOrgunit(orgUnit)) {
            throw new IllegalAccessException("Unable to get stats on orgUnit with id '" + orgUnitId + "' because user has no sufficient right");
        }
        ArrayList<Map<String, Object>> stats = new ArrayList<Map<String, Object>>();
        SearchResult programSearchResult = this._searchWithFacets("org.ametys.plugins.odf.Content.program", catalog, orgUnitId, "pilotage/pilotage_status");
        stats.add(this._status2JSON("pilotage", "program", programSearchResult, PilotageStatusHelper.PilotageStatus.MENTION_VALIDATED.name(), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MENTION_VALIDATED_LABEL")));
        stats.add(this._status2JSON("pilotage", "program", programSearchResult, PilotageStatusHelper.PilotageStatus.ORGUNIT_VALIDATED.name(), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_ORGUNIT_VALIDATED_LABEL")));
        stats.add(this._status2JSON("pilotage", "program", programSearchResult, PilotageStatusHelper.PilotageStatus.CFVU_VALIDATED.name(), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CFVU_VALIDATED_LABEL")));
        return stats;
    }

    @Callable(rights={""})
    public List<Map<String, Object>> getPilotageMCCWorkflowStats(String catalog, String orgUnitId) throws IllegalAccessException {
        OrgUnit orgUnit;
        OrgUnit orgUnit2 = orgUnit = StringUtils.isNotBlank((CharSequence)orgUnitId) ? (OrgUnit)this._resolver.resolveById(orgUnitId) : null;
        if (!this._checkRightOnOrgunit(orgUnit)) {
            throw new IllegalAccessException("Unable to get stats on orgUnit with id '" + orgUnitId + "' because user has no sufficient right");
        }
        ArrayList<Map<String, Object>> stats = new ArrayList<Map<String, Object>>();
        if (this._pilotageHelper.getYearId().isEmpty()) {
            return stats;
        }
        SearchResult containerSearchResult = this._searchWithFacets("org.ametys.plugins.odf.Content.container", catalog, orgUnitId, "mccWorkflowStatus");
        stats.add(this._status2JSON("mcc", "container", containerSearchResult, MCCWorkflowHelper.MCCWorkflowStep.RULES_VALIDATED.name(), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_RULES_VALIDATED_LABEL")));
        stats.add(this._status2JSON("mcc", "container", containerSearchResult, MCCWorkflowHelper.MCCWorkflowStep.MCC_VALIDATED.name(), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_MCC_VALIDATED_LABEL")));
        stats.add(this._status2JSON("mcc", "container", containerSearchResult, MCCWorkflowHelper.MCCWorkflowStep.MCC_ORGUNIT_VALIDATED.name(), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_MCC_ORGUNIT_VALIDATED_LABEL")));
        stats.add(this._status2JSON("mcc", "container", containerSearchResult, MCCWorkflowHelper.MCCWorkflowStep.CFVU_MCC_VALIDATED.name(), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_CFVU_VALIDATED_LABEL")));
        return stats;
    }

    private SearchResult _searchWithFacets(String contentType, String catalog, String orgUnitId, String facetName) {
        try {
            SearchResults search = this._contentSearcherFactory.create(new String[]{contentType}).withLimits(0, Integer.MAX_VALUE).withFacets(new String[]{facetName}).setCheckRights(false).searchWithFacets(this._getFilterQuery(contentType, catalog, orgUnitId));
            long total = search.getTotalCount();
            Map facetResults = search.getFacetResults();
            Map mccWorkflowStatus = (Map)facetResults.get(facetName);
            return new SearchResult(mccWorkflowStatus, total);
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred requesting solr", (Throwable)e);
            return null;
        }
    }

    private Map<String, Object> _status2JSON(String workflowType, String type, SearchResult searchResult, String status, I18nizableText label) {
        Long total = searchResult.totalCount();
        Map<String, Integer> facetResults = searchResult.facetResults();
        Integer number = facetResults.getOrDefault(status, 0);
        return Map.of("label", label, "number", number, "pourcent", total != 0L ? _DECIMAL_FORMAT.format(number.floatValue() * 100.0f / (float)total.longValue()) : Double.valueOf(0.0), "status", status, "total", total, "type", type, "workflowType", workflowType);
    }

    private Query _getFilterQuery(String contentType, String catalog, String orgUnitId) {
        ArrayList<Object> queries = new ArrayList<Object>();
        queries.add(new StringQuery("catalog", catalog));
        if (StringUtils.isNotBlank((CharSequence)orgUnitId)) {
            queries.add(new ContentQuery("orgUnit", Query.Operator.EQ, (Object)orgUnitId, this._resolver, this._contentHelper));
        }
        if ("org.ametys.plugins.odf.Content.container".equals(contentType)) {
            queries.add(new StringQuery("nature", this._pilotageHelper.getYearId().get()));
        }
        return new AndQuery(queries);
    }

    private record SearchResult(Map<String, Integer> facetResults, Long totalCount) {
    }
}

