/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.enumerators;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.Enumerator;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.commons.lang3.StringUtils;

public class StepHolderEnumerator
implements org.ametys.runtime.model.Enumerator<ContentValue>,
Serviceable,
Contextualizable,
Configurable,
Enumerator {
    private Context _context;
    private AmetysObjectResolver _resolver;
    private PilotageHelper _pilotageHelper;
    private boolean _usedForSearch;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration customConf = configuration.getChild("enumeration").getChild("custom-enumerator");
        this._usedForSearch = customConf.getChild("used-for-search").getValueAsBoolean(false);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._pilotageHelper = (PilotageHelper)((Object)manager.lookup(PilotageHelper.ROLE));
    }

    public I18nizableText getEntry(ContentValue value) throws Exception {
        try {
            return this._getDisplayName((Container)value.getContent());
        }
        catch (UnknownAmetysObjectException unknownAmetysObjectException) {
            return null;
        }
    }

    public I18nizableText getEntry(String value) throws Exception {
        try {
            return this._getDisplayName((Container)this._resolver.resolveById(value));
        }
        catch (UnknownAmetysObjectException unknownAmetysObjectException) {
            return null;
        }
    }

    public Map<ContentValue, I18nizableText> getTypedEntries() throws Exception {
        Optional<Course> course = Optional.of(this._context).map(ContextHelper::getRequest).map(r -> r.getAttribute(Content.class.getName())).filter(Course.class::isInstance).map(Course.class::cast);
        Stream<Object> containers = course.isPresent() ? this._pilotageHelper.getSteps((ProgramItem)course.get()).stream() : (this._usedForSearch ? this._getAllSteps() : Stream.empty());
        return containers.collect(Collectors.toMap(ContentValue::new, this::_getDisplayName));
    }

    public Map<Object, I18nizableText> getEntries() throws Exception {
        return this.getTypedEntries();
    }

    private Stream<Container> _getAllSteps() {
        return this._pilotageHelper.getYearId().map(anneeId -> new StringExpression("nature", Expression.Operator.EQ, anneeId)).map(anneeExpression -> new AndExpression(new Expression[]{new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.odf.Content.container"}), anneeExpression})).map(expression -> QueryHelper.getXPathQuery(null, (String)"ametys:container", (Expression)expression)).map(arg_0 -> ((AmetysObjectResolver)this._resolver).query(arg_0)).map(AmetysObjectIterable::stream).orElseGet(() -> Stream.of(new Container[0]));
    }

    private I18nizableText _getDisplayName(Container container) {
        StringBuilder displayName = new StringBuilder();
        displayName.append("[");
        displayName.append(container.getCode());
        displayName.append("] ");
        String etpCode = (String)container.getValue("etpCode");
        if (StringUtils.isNotBlank((CharSequence)etpCode)) {
            displayName.append("[");
            displayName.append(etpCode);
            displayName.append("] ");
        }
        displayName.append(container.getTitle());
        return new I18nizableText(displayName.toString());
    }

    public Map<String, Object> getConfiguration() {
        return Collections.EMPTY_MAP;
    }
}

