/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.helper;

import java.io.File;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.data.ContentDataHelper;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableDefaultContent;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.orgunit.RootOrgUnitProvider;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ReportHelper
implements Component,
Serviceable,
Initializable {
    public static final String ROLE = ReportHelper.class.getName();
    public static final NumberFormat FORMAT_2_DIGITS = NumberFormat.getInstance(Locale.FRANCE);
    public static final Comparator<Content> CONTENT_TITLE_COMPARATOR;
    private static final String __READABLE_DF = "dd/MM/yyyy";
    protected AmetysObjectResolver _resolver;
    protected RootOrgUnitProvider _rootOrgUnitProvider;
    protected ODFHelper _odfHelper;
    protected OdfReferenceTableHelper _refTableHelper;
    private File _pilotageFolder;

    public void initialize() throws Exception {
        this._pilotageFolder = new File(AmetysHomeHelper.getAmetysHomeData(), "odf/gestion");
        FileUtils.forceMkdir((File)this._pilotageFolder);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._rootOrgUnitProvider = (RootOrgUnitProvider)manager.lookup(RootOrgUnitProvider.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._odfHelper = (ODFHelper)manager.lookup(ODFHelper.ROLE);
        this._refTableHelper = (OdfReferenceTableHelper)manager.lookup(OdfReferenceTableHelper.ROLE);
    }

    public String getReadableCurrentDate() {
        return LocalDate.now().format(DateTimeFormatter.ofPattern(__READABLE_DF));
    }

    public List<OrgUnit> getOrgUnits(String orgUnitId) {
        return Optional.ofNullable(orgUnitId).filter(StringUtils::isNotEmpty).map(arg_0 -> ((AmetysObjectResolver)this._resolver).resolveById(arg_0)).map(List::of).orElseGet(this::_getRootOrgUnits);
    }

    private List<OrgUnit> _getRootOrgUnits() {
        return Stream.of((ContentValue[])this._rootOrgUnitProvider.getRoot().getValue("childOrgUnits")).map(ContentValue::getContentIfExists).flatMap(Optional::stream).map(OrgUnit.class::cast).toList();
    }

    public String getAcronymOrUaiCode(OrgUnit orgUnit) {
        return Optional.of(orgUnit).map(OrgUnit::getAcronym).filter(StringUtils::isNotBlank).orElseGet(() -> ((OrgUnit)orgUnit).getUAICode());
    }

    public String formatNumberToSax(Long number) {
        return number > 0L ? String.valueOf(number) : "";
    }

    public Map<ProgramItem, Object> getCoursesFromContent(ProgramItem programItem) {
        LinkedHashMap<ProgramItem, Object> contentTree = new LinkedHashMap<ProgramItem, Object>();
        for (ProgramItem childProgramItem : this._odfHelper.getChildProgramItems(programItem)) {
            if (childProgramItem instanceof Course) {
                contentTree.put(childProgramItem, this.getCoursesFromContent(childProgramItem));
                continue;
            }
            Map<ProgramItem, Object> childTree = this.getCoursesFromContent(childProgramItem);
            if (!MapUtils.isNotEmpty(childTree)) continue;
            contentTree.put(childProgramItem, childTree);
        }
        return contentTree;
    }

    public void saxContentAttribute(ContentHandler handler, ModifiableDefaultContent content, String attributeName, String tagName) throws SAXException {
        Locale lang = new Locale(content.getLanguage());
        if (!"content".equals(content.getType(attributeName).getId())) {
            throw new IllegalArgumentException("The attribute '" + attributeName + "' should be of type 'content'.");
        }
        Object value = content.getValue(attributeName);
        if (value != null) {
            Stream<ContentValue> values = content.isMultiple(attributeName) ? Stream.of((ContentValue[])value) : Stream.of((ContentValue)value);
            String tagValue = values.map(ContentValue::getContentIfExists).flatMap(Optional::stream).map(c -> c.getTitle(lang)).filter(StringUtils::isNotBlank).collect(Collectors.joining(", "));
            XMLUtils.createElement((ContentHandler)handler, (String)tagName, (String)tagValue);
        }
    }

    public void saxNaturesEnseignement(ContentHandler handler, Logger logger) throws SAXException {
        String lang = (String)Config.getInstance().getValue("odf.programs.lang");
        Map<String, List<OdfReferenceTableEntry>> itemsByCategory = this._refTableHelper.getItems("odf-enumeration.EnseignementNature").stream().collect(Collectors.groupingBy(item -> ContentDataHelper.getContentIdFromContentData((ModelAwareDataHolder)item.getContent(), (String)"category")));
        AttributesImpl rootAttrs = new AttributesImpl();
        rootAttrs.addCDATAAttribute("id", "odf-enumeration.EnseignementNature");
        XMLUtils.startElement((ContentHandler)handler, (String)"items", (Attributes)rootAttrs);
        for (String categoryId : itemsByCategory.keySet()) {
            Content category;
            block4: {
                category = null;
                try {
                    category = Optional.ofNullable(categoryId).filter(StringUtils::isNotBlank).map(arg_0 -> ((AmetysObjectResolver)this._resolver).resolveById(arg_0)).orElse(null);
                }
                catch (UnknownAmetysObjectException e) {
                    if (!StringUtils.isNotEmpty((CharSequence)categoryId)) break block4;
                    logger.warn("There is no content matching with the ID {}.", (Object)categoryId);
                }
            }
            AttributesImpl attr = new AttributesImpl();
            attr.addCDATAAttribute("code", Optional.ofNullable(category).map(c -> (String)c.getValue("code")).orElse(""));
            attr.addCDATAAttribute("order", String.valueOf(Optional.ofNullable(category).map(c -> c.getValue("order")).orElse(Long.MAX_VALUE)));
            XMLUtils.startElement((ContentHandler)handler, (String)"category", (Attributes)attr);
            for (OdfReferenceTableEntry item2 : itemsByCategory.get(categoryId)) {
                attr = new AttributesImpl();
                attr.addCDATAAttribute("id", item2.getId());
                attr.addCDATAAttribute("code", item2.getCode());
                attr.addCDATAAttribute("order", item2.getOrder().toString());
                attr.addCDATAAttribute("archived", item2.isArchived().toString());
                attr.addCDATAAttribute("shortLabel", (String)item2.getContent().getValue("shortLabel", false, (Object)""));
                XMLUtils.createElement((ContentHandler)handler, (String)"item", (Attributes)attr, (String)item2.getLabel(lang));
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"category");
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"items");
    }

    public File getPilotageFolder() {
        return this._pilotageFolder;
    }

    static {
        FORMAT_2_DIGITS.setRoundingMode(RoundingMode.HALF_UP);
        FORMAT_2_DIGITS.setMaximumFractionDigits(2);
        FORMAT_2_DIGITS.setGroupingUsed(false);
        CONTENT_TITLE_COMPARATOR = Comparator.comparing(Content::getTitle).thenComparing(Object::hashCode);
    }
}

