/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report;

import java.text.Normalizer;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.StringUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.plugins.odfpilotage.helper.ReportHelper;
import org.ametys.plugins.odfpilotage.report.PilotageReport;
import org.ametys.plugins.odfpilotage.schedulable.AbstractReportSchedulable;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.tuple.Pair;
import org.xml.sax.ContentHandler;

public abstract class AbstractPilotageReport
extends AbstractLogEnabled
implements PilotageReport,
Serviceable,
PluginAware,
Configurable {
    public static final String MANIFEST_FILENAME = "manifest.json";
    private static final int __REPORT_FILENAME_MAX_LENGTH = 120;
    protected PilotageHelper _pilotageHelper;
    protected AmetysObjectResolver _resolver;
    protected ReportHelper _reportHelper;
    protected OdfReferenceTableHelper _refTableHelper;
    protected ODFHelper _odfHelper;
    private String _id;
    private I18nizableText _label;
    private String _pluginName;

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
        this._id = id;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._label = I18nizableText.parseI18nizableText((Configuration)configuration.getChild("label"), (String)("plugin." + this._pluginName));
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._pilotageHelper = (PilotageHelper)((Object)manager.lookup(PilotageHelper.ROLE));
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._reportHelper = (ReportHelper)manager.lookup(ReportHelper.ROLE);
        this._refTableHelper = (OdfReferenceTableHelper)manager.lookup(OdfReferenceTableHelper.ROLE);
        this._odfHelper = (ODFHelper)manager.lookup(ODFHelper.ROLE);
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public boolean supports(AbstractReportSchedulable schedulable) {
        if (schedulable.forGenericReports() == this.isGeneric() && this.isSupportedTarget(schedulable.getTarget())) {
            return this.isCompatibleSchedulable(schedulable);
        }
        return false;
    }

    protected boolean isGeneric() {
        return true;
    }

    protected abstract boolean isSupportedTarget(PilotageReport.PilotageReportTarget var1);

    protected boolean isCompatibleSchedulable(AbstractReportSchedulable schedulable) {
        return true;
    }

    protected abstract PilotageReport.PilotageReportContent getReportContentForOrgUnit(String var1, Map<String, String> var2);

    protected abstract PilotageReport.PilotageReportContent getReportContentForProgram(String var1, Map<String, String> var2);

    @Override
    public String getType() {
        return this.getType(null);
    }

    protected abstract String getType(Map<String, String> var1);

    @Override
    public String getPluginName() {
        return this._pluginName;
    }

    @Override
    public String getDefaultOutputFormat() {
        return "doc";
    }

    @Override
    public Set<String> getSupportedOutputFormats() {
        return Set.of("doc", "xls");
    }

    @Override
    public boolean isSupportedFormat(String outputFormat) {
        return this.getSupportedOutputFormats().contains(outputFormat);
    }

    @Override
    public PilotageReport.PilotageReportContent getReportContent(PilotageReport.PilotageReportTarget target, Map<String, String> reportParameters) {
        this.getLogger().info("D\u00e9but du rapport de pilotage");
        long begin = System.currentTimeMillis();
        try {
            String outputFormat = reportParameters.get("outputFormat");
            if (!this.isSupportedFormat(outputFormat)) {
                throw new UnsupportedOperationException("Impossible to launch the report '" + this.getType() + "' with the output format '" + outputFormat + "'.");
            }
            if (!this.isSupportedTarget(target)) {
                throw new UnsupportedOperationException("Impossible to launche the report '" + this.getType() + "' on the target '" + target.name() + "'");
            }
            switch (target) {
                case PROGRAM: {
                    PilotageReport.PilotageReportContent pilotageReportContent = this.getReportContentForProgram(outputFormat, reportParameters);
                    return pilotageReportContent;
                }
                case ORGUNIT: {
                    PilotageReport.PilotageReportContent pilotageReportContent = this.getReportContentForOrgUnit(outputFormat, reportParameters);
                    return pilotageReportContent;
                }
            }
            throw new UnsupportedOperationException("Not supported target '" + target + "'.");
        }
        finally {
            long end = System.currentTimeMillis();
            this.getLogger().info("Calcul et \u00e9criture du rapport de pilotage effectu\u00e9 en {} ms.", (Object)(end - begin));
        }
    }

    @Override
    public String getReportFileName(String catalog, String lang, OrgUnit orgUnit, Map<String, String> reportParameters, String outputFormat) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getType(reportParameters));
        sb.append("-");
        sb.append(catalog);
        sb.append("-");
        sb.append(lang);
        sb.append("-");
        sb.append(this._reportHelper.getAcronymOrUaiCode(orgUnit));
        sb.append("-");
        sb.append(this._getCurrentDate());
        sb.append(".");
        sb.append(outputFormat);
        return sb.toString();
    }

    @Override
    public String getReportFileName(ProgramItem programItem, Map<String, String> reportParameters, String outputFormat) {
        StringBuilder filenamePrefix = new StringBuilder();
        filenamePrefix.append(this.getType(reportParameters));
        filenamePrefix.append("-");
        filenamePrefix.append(programItem.getCatalog());
        filenamePrefix.append("-");
        filenamePrefix.append(programItem.getLanguage());
        filenamePrefix.append("-");
        StringBuilder filenameSuffix = new StringBuilder();
        filenameSuffix.append("-");
        filenameSuffix.append(programItem.getCode());
        filenameSuffix.append("-");
        filenameSuffix.append(this._getCurrentDate());
        int titleMaxLength = 120 - (filenamePrefix.length() + filenameSuffix.length());
        String title = org.apache.commons.lang3.StringUtils.substring((String)((Content)programItem).getTitle(), (int)0, (int)titleMaxLength);
        StringBuilder filename = filenamePrefix.append(title).append((CharSequence)filenameSuffix);
        return this._normalizeFileName(filename.toString()) + "." + outputFormat;
    }

    private String _getCurrentDate() {
        return DateUtils.localDateToString((LocalDate)LocalDate.now());
    }

    protected PilotageReport.PilotageReportContent _getReportContentForProgram(String outputFormat, Map<String, String> reportParameters) {
        String programId = reportParameters.get("program");
        ProgramItem programItem = (ProgramItem)this._resolver.resolveById(programId);
        if (!(programItem instanceof Program)) {
            throw new UnsupportedOperationException("The report '" + this.getType() + "' can be launch only on programs through this method.");
        }
        Program program = (Program)programItem;
        return new PilotageReport.PilotageReportContent(this._buildZipName(reportParameters), this._getFilesList(this._getProgramItemsFromProgram(program, reportParameters), this._getProgramItemTransform(outputFormat, reportParameters)));
    }

    protected PilotageReport.PilotageReportContent _getReportContentForProgramItemsInOrgUnit(String outputFormat, Map<String, String> reportParameters) {
        String orgunitId = reportParameters.get("orgunit");
        String catalog = reportParameters.get("catalog");
        String lang = reportParameters.get("lang");
        OrgUnit orgUnit = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)orgunitId)) {
            orgUnit = (OrgUnit)this._resolver.resolveById(orgunitId);
        }
        return new PilotageReport.PilotageReportContent(this._buildZipName(reportParameters), this._getFilesList(this._getProgramItemsFromOrgUnit(orgUnit, catalog, lang, reportParameters), this._getProgramItemTransform(outputFormat, reportParameters)));
    }

    protected Function<ProgramItem, Pair<String, String>> _getProgramItemTransform(String outputFormat, Map<String, String> reportParameters) {
        return programItem -> Pair.of((Object)this.getReportFileName((ProgramItem)programItem, reportParameters, outputFormat), (Object)this._buildPipeline(outputFormat, reportParameters, "programItem", (AmetysObject)programItem));
    }

    private Stream<? extends ProgramItem> _getProgramItemsFromOrgUnit(OrgUnit orgUnit, String catalog, String lang, Map<String, String> reportParameters) {
        return this._odfHelper.getProgramsFromOrgUnit(orgUnit, catalog, lang).stream().flatMap(p -> this._getProgramItemsFromProgram((Program)p, reportParameters)).distinct();
    }

    protected Stream<? extends ProgramItem> _getProgramItemsFromProgram(Program program, Map<String, String> reportParameters) {
        return Stream.of(program);
    }

    protected PilotageReport.PilotageReportContent _getReportContentForOrgUnit(String outputFormat, Map<String, String> reportParameters) {
        String orgunitId = reportParameters.get("orgunit");
        String catalog = reportParameters.get("catalog");
        String lang = reportParameters.get("lang");
        List<OrgUnit> orgUnits = this._reportHelper.getOrgUnits(orgunitId);
        Function<OrgUnit, Pair> transform = orgUnit -> Pair.of((Object)this.getReportFileName(catalog, lang, (OrgUnit)orgUnit, reportParameters, outputFormat), (Object)this._buildPipeline(outputFormat, reportParameters, "orgUnit", (AmetysObject)orgUnit));
        return new PilotageReport.PilotageReportContent(this._buildZipName(reportParameters), this._getFilesList(orgUnits.stream(), transform));
    }

    private <T> Map<String, String> _getFilesList(Stream<? extends T> elements, Function<T, Pair<String, String>> transform) {
        return elements.distinct().map(transform::apply).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    protected String _buildPipeline(String outputFormat, Map<String, String> reportParameters, String contentParameterName, AmetysObject content) {
        StringBuilder sb = new StringBuilder();
        sb.append("cocoon://_plugins/odf-pilotage/report/");
        sb.append(this.getType());
        sb.append(".");
        sb.append(outputFormat);
        sb.append("?");
        sb.append(contentParameterName);
        sb.append("=");
        sb.append(URIUtils.encodeParameter((String)content.getId()));
        return sb.toString();
    }

    private String _buildZipName(Map<String, String> reportParameters) {
        return this.getType(reportParameters) + "-" + StringUtils.generateKey() + ".zip";
    }

    @Override
    public void saxOrgUnit(ContentHandler handler, String orgUnitId, Map<String, String> reportParameters) {
        this._saxOrgUnit(handler, reportParameters.get("catalog"), reportParameters.get("lang"), orgUnitId, reportParameters);
    }

    protected abstract void _saxOrgUnit(ContentHandler var1, String var2, String var3, String var4, Map<String, String> var5);

    private String _normalizeFileName(String originalName) {
        String filteredName = Normalizer.normalize(originalName.toLowerCase(), Normalizer.Form.NFD).replaceAll("[\\p{InCombiningDiacriticalMarks}]", "").trim();
        filteredName = filteredName.replaceAll("\u0153", "oe").replaceAll("\u00e6", "ae").replaceAll(" +", "-").replaceAll("[^\\w-]", "-").replaceAll("-+", "-");
        return org.apache.commons.lang3.StringUtils.strip((String)filteredName, (String)"-_");
    }
}

