/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.consistency.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.report.consistency.AbstractConsistencyAnalysis;
import org.ametys.plugins.odfpilotage.report.consistency.ConsistencyAnalysisResult;
import org.ametys.plugins.odfpilotage.report.consistency.ConsistencyAnalysisStatus;
import org.ametys.runtime.i18n.I18nizableText;

public class ECTSSumAnalysis
extends AbstractConsistencyAnalysis {
    private static final Pattern __ECTS_PATTERN = Pattern.compile("^.*?([0-9]+(?:[\\.,][0-9]+)?).*$");

    @Override
    public ConsistencyAnalysisResult analyze(ProgramItem programItem) {
        ConsistencyAnalysisResult result = new ConsistencyAnalysisResult();
        result.setIntroText(new I18nizableText("plugin." + this._pluginName, "PLUGINS_ODF_PILOTAGE_CONSISTENCY_ANALYSIS_ECTSSUM_INTRO"));
        result.addColumn("parentName", new I18nizableText("plugin." + this._pluginName, "PLUGINS_ODF_PILOTAGE_CONSISTENCY_ANALYSIS_ECTSSUM_COLUMN_PARENT_NAME"), true);
        result.addColumn("parentCode", new I18nizableText("plugin." + this._pluginName, "PLUGINS_ODF_PILOTAGE_CONSISTENCY_ANALYSIS_ECTSSUM_COLUMN_PARENT_CODE"));
        result.addColumn("parentECTS", new I18nizableText("plugin." + this._pluginName, "PLUGINS_ODF_PILOTAGE_CONSISTENCY_ANALYSIS_ECTSSUM_COLUMN_PARENT_ECTS"));
        result.addColumn("childrenECTS", new I18nizableText("plugin." + this._pluginName, "PLUGINS_ODF_PILOTAGE_CONSISTENCY_ANALYSIS_ECTSSUM_COLUMN_CHILDREN_ECTS"));
        List<Map<String, Object>> errors = this._controlECTS(programItem, 0);
        result.addLines(errors);
        result.setStatus(errors.isEmpty() ? ConsistencyAnalysisStatus.OK : ConsistencyAnalysisStatus.KO);
        return result;
    }

    protected Map<String, Object> _getErrorMessage(ProgramItem programItem, Double parentECTS, Double childrenECTS, int level) {
        HashMap<String, Object> error = new HashMap<String, Object>();
        error.put("parentName", ((Content)programItem).getTitle());
        error.put("parentCode", programItem.getCode());
        error.put("parentECTS", parentECTS);
        error.put("childrenECTS", childrenECTS);
        error.put("indentationLevel", level);
        return error;
    }

    protected List<Map<String, Object>> _controlECTS(ProgramItem programItem, int level) {
        ArrayList<Map<String, Object>> errors = new ArrayList<Map<String, Object>>();
        List children = this._odfHelper.getChildProgramItems(programItem);
        if (!children.isEmpty()) {
            Double childrenECTS;
            Double parentECTS = this._getECTS((Content)programItem);
            if (parentECTS != null && !parentECTS.equals(childrenECTS = this._getChildrenECTSSum(programItem))) {
                errors.add(this._getErrorMessage(programItem, parentECTS, childrenECTS, level));
            }
            for (ProgramItem child : children) {
                errors.addAll(this._controlECTS(child, level + 1));
            }
        }
        return errors;
    }

    protected Double _getChildrenECTSSum(ProgramItem programItem) {
        CourseList courseList;
        if (programItem instanceof CourseList && CourseList.ChoiceType.OPTIONAL.equals((Object)(courseList = (CourseList)programItem).getType())) {
            return 0.0;
        }
        List children = this._odfHelper.getChildProgramItems(programItem);
        Double coef = 1.0;
        Double childrenECTS = 0.0;
        if (!children.isEmpty()) {
            if (programItem instanceof CourseList) {
                CourseList courseList2 = (CourseList)programItem;
                switch (courseList2.getType()) {
                    case CHOICE: {
                        coef = (double)courseList2.getMinNumberOfCourses() / (double)children.size();
                        break;
                    }
                }
            }
            for (ProgramItem child : children) {
                Double childECTS = this._getECTS((Content)child);
                if (childECTS == null) {
                    childECTS = this._getChildrenECTSSum(child);
                }
                childrenECTS = childrenECTS + childECTS;
            }
        }
        return coef * childrenECTS;
    }

    protected Double _getECTS(Content content) {
        if (!content.hasValue("ects")) {
            return null;
        }
        Object ects = content.getValue("ects");
        if (content instanceof Course || content instanceof Container) {
            return (Double)ects;
        }
        if (content instanceof AbstractProgram) {
            String code = new OdfReferenceTableEntry((Content)((ContentValue)ects).getContent()).getCode();
            Matcher matcher = __ECTS_PATTERN.matcher(code);
            if (matcher.matches()) {
                return Double.parseDouble(matcher.group(1).replace(",", "."));
            }
            return null;
        }
        return null;
    }
}

