/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.consistency.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.plugins.odfpilotage.report.consistency.AbstractConsistencyAnalysis;
import org.ametys.plugins.odfpilotage.report.consistency.ConsistencyAnalysisResult;
import org.ametys.plugins.odfpilotage.report.consistency.ConsistencyAnalysisStatus;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class StepHolderAnalysis
extends AbstractConsistencyAnalysis {
    protected PilotageHelper _pilotageHelper;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._pilotageHelper = (PilotageHelper)((Object)manager.lookup(PilotageHelper.ROLE));
    }

    @Override
    public ConsistencyAnalysisResult analyze(ProgramItem programItem) {
        ConsistencyAnalysisResult result = new ConsistencyAnalysisResult();
        result.setIntroText(new I18nizableText("plugin." + this._pluginName, "PLUGINS_ODF_PILOTAGE_CONSISTENCY_ANALYSIS_STEPHOLDER_INTRO"));
        result.addColumn("courseCode", new I18nizableText("plugin." + this._pluginName, "PLUGINS_ODF_PILOTAGE_CONSISTENCY_ANALYSIS_STEPHOLDER_COLUMN_COURSE_CODE"));
        result.addColumn("courseTitle", new I18nizableText("plugin." + this._pluginName, "PLUGINS_ODF_PILOTAGE_CONSISTENCY_ANALYSIS_STEPHOLDER_COLUMN_COURSE_TITLE"));
        result.addColumn("stepHolderStatus", new I18nizableText("plugin." + this._pluginName, "PLUGINS_ODF_PILOTAGE_CONSISTENCY_ANALYSIS_STEPHOLDER_COLUMN_STEP_HOLDER_STATUS"));
        List<Map<String, Object>> errors = this._controlStepHolderOnCourses(programItem);
        result.addLines(errors);
        result.setStatus(errors.isEmpty() ? ConsistencyAnalysisStatus.OK : ConsistencyAnalysisStatus.KO);
        return result;
    }

    protected List<Map<String, Object>> _controlStepHolderOnCourses(ProgramItem programItem) {
        ArrayList<Map<String, Object>> errors = new ArrayList<Map<String, Object>>();
        for (Course course : this.getAllCourses(programItem)) {
            PilotageHelper.StepHolderStatus stepHolderStatus = (PilotageHelper.StepHolderStatus)((Object)this._pilotageHelper.getStepHolder((ProgramItem)course).getLeft());
            if (stepHolderStatus == PilotageHelper.StepHolderStatus.SINGLE) continue;
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("courseCode", course.getCode());
            error.put("courseTitle", course.getTitle());
            error.put("stepHolderStatus", (String)new I18nizableText("plugin." + this._pluginName, "PLUGINS_ODF_PILOTAGE_CONSISTENCY_ANALYSIS_STEPHOLDER_STATUS_" + stepHolderStatus.toString()));
            errors.add(error);
        }
        return errors;
    }

    private Set<Course> getAllCourses(ProgramItem programItem) {
        HashSet<Course> courses = new HashSet<Course>();
        boolean alreadyAdded = false;
        if (programItem instanceof Course) {
            Course course = (Course)programItem;
            boolean bl = alreadyAdded = !courses.add(course);
        }
        if (!alreadyAdded) {
            this._odfHelper.getChildProgramItems(programItem).forEach(child -> courses.addAll(this.getAllCourses((ProgramItem)child)));
        }
        return courses;
    }
}

