/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.impl;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.data.holder.DataHolderDisableConditionsEvaluator;
import org.ametys.cms.repository.Content;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.catalog.CatalogsManager;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.data.EducationalPath;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.odf.program.TraversableProgramPart;
import org.ametys.plugins.odfpilotage.report.PilotageReport;
import org.ametys.plugins.odfpilotage.report.impl.AbstractReport;
import org.ametys.plugins.odfpilotage.report.impl.mcc.MCCProgramItemTree;
import org.ametys.plugins.repository.data.ametysobject.DataAwareAmetysObject;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.plugins.repository.model.RepositoryDataContext;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.disableconditions.DisableConditionsEvaluator;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractMCCReport
extends AbstractReport
implements Initializable {
    public static final String PARAMETER_ONE_FILE_BY_PROGRAM = "oneFileByProgram";
    private static final String __SESSION_NAME_PREFIX = "mccSession";
    protected static final String FIRST_SESSION_NAME = "mccSession1";
    protected static final String SECOND_SESSION_NAME = "mccSession2";
    protected CatalogsManager _catalogsManager;
    protected DisableConditionsEvaluator<ModelAwareDataHolder> _disableConditionsEvaluator;
    protected ContentTypeExtensionPoint _contentTypeEP;
    protected View _sessionsView;
    private View _programView;
    private View _subProgramView;
    private View _containerView;
    private View _courseListView;
    private View _courseView;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._contentTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._catalogsManager = (CatalogsManager)manager.lookup(CatalogsManager.ROLE);
        this._disableConditionsEvaluator = (DisableConditionsEvaluator)manager.lookup(DataHolderDisableConditionsEvaluator.ROLE);
    }

    public void initialize() throws Exception {
        this._programView = this._getView("org.ametys.plugins.odf.Content.program", "report-mcc");
        this._subProgramView = this._getView("org.ametys.plugins.odf.Content.subProgram", "report-mcc");
        this._containerView = this._getView("org.ametys.plugins.odf.Content.container", "report-mcc");
        this._courseListView = this._getView("org.ametys.plugins.odf.Content.courseList", "report-mcc");
        this._courseView = this._getView("org.ametys.plugins.odf.Content.course", "report-mcc");
        this._sessionsView = this._getView("org.ametys.plugins.odf.Content.course", "report-mcc-sessions");
    }

    @Override
    protected boolean isGeneric() {
        return false;
    }

    @Override
    public String getDefaultOutputFormat() {
        return "pdf";
    }

    @Override
    public Set<String> getSupportedOutputFormats() {
        return Set.of("doc", "xls", "pdf");
    }

    private View _getView(String contentTypeId, String viewName) {
        ContentType contentType = (ContentType)this._contentTypeEP.getExtension(contentTypeId);
        return contentType.getView(viewName);
    }

    @Override
    protected PilotageReport.PilotageReportContent getReportContentForOrgUnit(String outputFormat, Map<String, String> reportParameters) {
        return this._getReportContentForProgramItemsInOrgUnit(outputFormat, reportParameters);
    }

    @Override
    protected Stream<? extends ProgramItem> _getProgramItemsFromProgram(Program program, Map<String, String> reportParameters) {
        if (!Boolean.parseBoolean(reportParameters.get(PARAMETER_ONE_FILE_BY_PROGRAM))) {
            return this._pilotageHelper.getYears((TraversableProgramPart)program).stream();
        }
        return super._getProgramItemsFromProgram(program, reportParameters);
    }

    @Override
    public void saxProgramItem(ContentHandler handler, String programItemId, Map<String, String> reportParameters) {
        ProgramItem programItem = (ProgramItem)this._resolver.resolveById(programItemId);
        MCCProgramItemTree programTree = this._createMCCTreeFromProgramItem(programItem, reportParameters);
        try {
            handler.startDocument();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("type", this.getType());
            XMLUtils.startElement((ContentHandler)handler, (String)"report", (Attributes)attrs);
            this.saxGlobalInformations(handler, programItem, reportParameters);
            this._reportHelper.saxNaturesEnseignement(handler, this.getLogger());
            this.saxTree(handler, programTree);
            XMLUtils.endElement((ContentHandler)handler, (String)"report");
            handler.endDocument();
        }
        catch (Exception e) {
            this.getLogger().error("An error occured while generating 'MCC' report for program item '{}' ({})", new Object[]{((Content)programItem).getTitle(), programItem.getCode(), e});
        }
    }

    @Override
    public void _saxOrgUnit(ContentHandler handler, String catalog, String lang, String orgUnitId, Map<String, String> reportParameters) {
        throw new UnsupportedOperationException("Impossible to launch the report '" + this.getType() + "' on a orgunit.");
    }

    protected void saxTree(ContentHandler handler, MCCProgramItemTree tree) throws SAXException {
        ProgramItem programItem = tree.getCurrent();
        if (programItem instanceof Program) {
            Program program = (Program)programItem;
            this._saxContent(handler, "program", (Content)program, this._programView, tree);
        } else if (programItem instanceof SubProgram) {
            SubProgram subProgram = (SubProgram)programItem;
            this._saxContent(handler, "subProgram", (Content)subProgram, this._subProgramView, tree);
        } else if (programItem instanceof Container) {
            Container container = (Container)programItem;
            this._saxContent(handler, "container", (Content)container, this._containerView, tree);
        } else if (programItem instanceof CourseList) {
            CourseList courseList = (CourseList)programItem;
            this._saxContent(handler, "courseList", (Content)courseList, this._courseListView, tree);
        } else if (programItem instanceof Course) {
            Course course = (Course)programItem;
            this._saxContent(handler, "course", (Content)course, this._courseView, tree);
        }
    }

    protected void _saxContent(ContentHandler handler, String tagName, Content content, View view, MCCProgramItemTree tree) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", content.getId());
        attrs.addCDATAAttribute("name", content.getName());
        attrs.addCDATAAttribute("path", tree.getPath().toString());
        if (this._pilotageHelper.canWriteMccRestrictions(content, SECOND_SESSION_NAME)) {
            attrs.addCDATAAttribute("session2", "available");
        }
        XMLUtils.startElement((ContentHandler)handler, (String)tagName, (Attributes)attrs);
        content.dataToSAX(handler, (ViewItemAccessor)view);
        if (content instanceof Course) {
            Course course = (Course)content;
            this._saxMCCs(handler, course, tree);
        }
        for (MCCProgramItemTree child : tree.getChildren()) {
            this.saxTree(handler, child);
        }
        XMLUtils.endElement((ContentHandler)handler, (String)tagName);
    }

    protected abstract void _saxMCCs(ContentHandler var1, Course var2, MCCProgramItemTree var3) throws SAXException;

    protected void _saxSessionEntryDetails(ContentHandler handler, ModelAwareRepeaterEntry sessionEntry, Content rootContent) throws SAXException {
        String repeaterName = sessionEntry.getHoldingRepeater().getModel().getName();
        sessionEntry.dataToSAX(handler, (ViewItemAccessor)this._sessionsView.getModelViewItem(repeaterName), RepositoryDataContext.newInstance().withObject((DataAwareAmetysObject)rootContent).withDataPath(repeaterName + "[" + sessionEntry.getPosition() + "]"));
    }

    protected MCCProgramItemTree _createMCCTreeFromProgramItem(ProgramItem programItem, Map<String, String> reportParameters) {
        MCCProgramItemTree programItemTree = new MCCProgramItemTree(programItem);
        this.populateMCCTree(programItemTree);
        return programItemTree;
    }

    protected abstract void populateMCCTree(MCCProgramItemTree var1);

    protected void saxGlobalInformations(ContentHandler handler, ProgramItem programItem, Map<String, String> reportParameters) throws SAXException {
        String catalog = programItem.getCatalog();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", catalog);
        XMLUtils.createElement((ContentHandler)handler, (String)"catalog", (Attributes)attrs, (String)this._catalogsManager.getCatalog(catalog).getTitle());
        XMLUtils.createElement((ContentHandler)handler, (String)"title", (String)((Content)programItem).getTitle());
        XMLUtils.createElement((ContentHandler)handler, (String)"lang", (String)programItem.getLanguage());
        for (EducationalPath path : this._odfHelper.getEducationalPaths(programItem, false, true)) {
            String readablePath = path.resolveProgramItems(this._resolver).map(Content.class::cast).map(Content::getTitle).collect(Collectors.joining(" > "));
            XMLUtils.createElement((ContentHandler)handler, (String)"path", (String)readablePath);
        }
    }
}

