<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:exsl="http://exslt.org/common"
                              exclude-result-prefixes="exsl">
    
    <xsl:template name="legende">
        <xsl:call-template name="new-page" />
        <p class="legend-title"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGENDE"/></p>
        <table class="legend">
            <colgroup>
                <col width="5%"/>
                <col width="25%"/>
                <col width="70%"/>
            </colgroup>
            <xsl:call-template name="legende-titles"/>
            <xsl:call-template name="legende-enseignement-nature"/>
            <xsl:apply-templates select="exsl:node-set($referenceTables)/items" mode="legende"/>
        </table>
    </xsl:template>
    
    <xsl:template name="legende-titles">
        <tr>
            <td colspan="3"><strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_COLUMN_TITLES"/></strong></td>
        </tr>
        <tr>
            <td>&#160;</td>
            <td><strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_EVALUATED"/></strong></td>
            <td><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_EVALUATED"/></td>
        </tr>
        <tr>
            <td>&#160;</td>
            <td><strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_NATURE"/></strong></td>
            <td><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_NATURE"/></td>
        </tr>
        <tr>
            <td>&#160;</td>
            <td><strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_SHARED"/></strong></td>
            <td><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_SHARED"/></td>
        </tr>
        <tr>
            <td>&#160;</td>
            <td><strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_COEF"/></strong></td>
            <td><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_COEF"/></td>
        </tr>
        <tr>
            <td>&#160;</td>
            <td><strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_NOTE_ELIM"/></strong></td>
            <td><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_NOTE_ELIM"/></td>
        </tr>
        <tr>
            <td>&#160;</td>
            <td><strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_REPORT_SESSION_2"/></strong></td>
            <td><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_REPORT_SESSION_2"/></td>
        </tr>
    </xsl:template>
    
    <xsl:template name="legende-enseignement-nature">
        <!-- Display the legend items which are referenced in the report (already filtered) -->
        <xsl:if test="count(exsl:node-set($naturesEnseignement)/*) > 0">
            <tr>
                <td colspan="3"><strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_TITLE_ENSEIGNEMENT_NATURE"/></strong></td>
            </tr>
            <xsl:for-each select="exsl:node-set($naturesEnseignement)/*">
                <tr>
                    <td>&#160;</td>
                    <td>
                        <strong>
                            <xsl:call-template name="displayCodeOrShortLabel">
                                <xsl:with-param name="contentId" select="@id"/>
                            </xsl:call-template>
                        </strong>
                    </td>
                    <td><xsl:value-of select="."/></td>
                </tr>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="items" mode="legende">
        <!-- Display the legend items which are referenced in the report -->
        <xsl:variable name="items">
            <xsl:for-each select="item">
                <xsl:variable name="currentId" select="@id"/>
                <xsl:if test="$root//*[@id = $currentId and local-name() != 'item']">
                    <xsl:copy-of select="."/>
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>
        
        <!-- Display the legend only if at least one item has to be displayed -->
        <xsl:if test="count(exsl:node-set($items)/item) > 0">
            <tr>
                <td colspan="3"><strong><xsl:apply-templates select="." mode="legende-title"/></strong></td>
            </tr>
            <xsl:for-each select="exsl:node-set($items)/item">
                <xsl:sort select="@order" data-type="number"/>
                <xsl:sort select="@code"/>
                <tr>
                    <td>&#160;</td>
                    <td>
                        <strong>
                            <xsl:call-template name="displayCodeOrShortLabel">
                                <xsl:with-param name="contentId" select="@id"/>
                            </xsl:call-template>
                        </strong>
                    </td>
                    <td><xsl:value-of select="@title"/></td>
                </tr>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="items[@id = 'odf-enumeration.CourseNature']" mode="legende-title">
        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_TITLE_COURSE_NATURE"/>
    </xsl:template>
    
    <xsl:template match="items[@id = 'odf-enumeration.MccRegime']" mode="legende-title">
        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_TITLE_REGIME"/>
    </xsl:template>
    
    <xsl:template match="items[@id = 'odf-enumeration.MccModaliteSession1']" mode="legende-title">
        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_TITLE_SESSION_MODALITE_1"/>
    </xsl:template>
    
    <xsl:template match="items[@id = 'odf-enumeration.MccModaliteSession2']" mode="legende-title">
        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_TITLE_SESSION_MODALITE_2"/>
    </xsl:template>
    
    <xsl:template match="items[@id = 'odf-enumeration.MccSessionNature']" mode="legende-title">
        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_TITLE_SESSION_NATURE"/>
    </xsl:template>
</xsl:stylesheet>
