<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:math="java.lang.Math"
                              exclude-result-prefixes="math">
    
    <xsl:import href="view://stylesheets/io/docbook2html.xsl"/>
    <xsl:import href="plugin:core://stylesheets/helper/text.xsl"/>
    
    <xsl:param name="orientation" select="'portrait'"/>
    <xsl:variable name="uniqueSectionId" select="concat('section-', substring-after(math:random(), '.'))"/>
    
    <xsl:template name="new-page">
        <span><br clear="all" class="new-page"/></span>
    </xsl:template>
    
    <xsl:template name="new-section">
        <span><br clear="all" class="new-section"/></span>
    </xsl:template>
    
    <xsl:template match="/*">
        <xsl:call-template name="root"/>
    </xsl:template>
    
    <xsl:template name="root">
        <html xmlns:w="urn:schemas-microsoft-com:office:word">
            <head>
                <title><xsl:call-template name="doc-title"/></title>
                <xsl:text disable-output-escaping="yes">&lt;!--[if gte mso 9]&gt;</xsl:text>
                <xml>
                    <w:WordDocument>
                        <w:View>Print</w:View>
                        <w:Zoom>100</w:Zoom>
                    </w:WordDocument>
                </xml>
                <xsl:text disable-output-escaping="yes">&lt;![endif]--&gt;</xsl:text>
                
                <style>
                    <xsl:call-template name="common-styles"/>
                    <xsl:call-template name="common-styles-forced"/>
                    <xsl:call-template name="css-styles"/>
                </style>
            </head>
            <body>
                <xsl:call-template name="doc-body" />
            </body>
        </html>
    </xsl:template>
    
    <xsl:template name="css-styles"/>
    
    <xsl:template name="header"/>
    
    <xsl:template name="footer"/>
    
    <xsl:template name="body"/>
    
    <xsl:template name="doc-title"/>
    
    <xsl:template name="doc-body">
        <div class="{$orientation}" id="{$uniqueSectionId}">
            <xsl:call-template name="common-structure" />
            <xsl:call-template name="body"/>
        </div>
    </xsl:template>
    
    <xsl:template name="common-styles">
        body
        {
            font-family: Arial;
        }
        
        .new-page
        {
            mso-special-character: line-break;
            page-break-before: always;
        }
        
        .new-section
        {
            mso-break-type: section-break;
            page-break-before: always;
        }
        
        @page Portrait
        {
            size: 210mm 297mm;
            mso-page-orientation: portrait; 
            mso-header: doc-header;
            mso-footer: doc-footer;
            margin:1cm;
            mso-header-margin:0; 
            mso-footer-margin:1cm; 
            mso-paper-source:0;
        }
        
        div.portrait
        {
            page: Portrait;
        }
        
        @page Landscape
        {
            size: 297mm 210mm;
            mso-page-orientation: landscape; 
            mso-header: doc-header;
            mso-footer: doc-footer;
            margin:1cm;
            mso-header-margin:0; 
            mso-footer-margin:1cm; 
            mso-paper-source:0;
        }
        
        div.landscape
        {
            page: Landscape;
        }
        
        .headerFooterDefinition
        {
            margin-left: 40cm;
            overflow: hidden;
            width: 100%;
        }
    </xsl:template>
    
    <xsl:template name="common-styles-forced">
        #<xsl:value-of select="$uniqueSectionId"/> .MsoHeader div,
        #<xsl:value-of select="$uniqueSectionId"/> .MsoHeader span,
        #<xsl:value-of select="$uniqueSectionId"/> .MsoHeader table,
        #<xsl:value-of select="$uniqueSectionId"/> .MsoHeader p,
        #<xsl:value-of select="$uniqueSectionId"/> .MsoFooter div,
        #<xsl:value-of select="$uniqueSectionId"/> .MsoFooter span,
        #<xsl:value-of select="$uniqueSectionId"/> .MsoFooter table,
        #<xsl:value-of select="$uniqueSectionId"/> .MsoFooter p
        {
            font-size: 7.5pt;
        }
    </xsl:template>
    
    <xsl:template name="common-structure">
        <!-- Code spécifique Microsoft Word pour la gestion des headers/footers -->
        <table class="headerFooterDefinition">
            <tr>
                <td>
                    <div style="mso-element:header" id="doc-header" class="MsoHeader">
                        <xsl:call-template name="header"/>
                    </div>
                    <div style="mso-element:footer" id="doc-footer" class="MsoFooter">
                        <table border="0" cellspacing="0" cellpadding="0" width="100%">
                            <tr>
                                <td width="25%" style="text-align: left;">
                                    <i18n:translate>
                                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_DATE"/>
                                        <i18n:param><i18n:date-time pattern="dd/MM/yyyy HH:mm" /></i18n:param>
                                    </i18n:translate>
                                </td>
                                <td style="text-align: center;">
                                    <xsl:call-template name="footer"/>
                                </td>
                                <td width="25%" style="text-align: right;">
                                    <span style="mso-field-code: PAGE;"><span style="mso-no-proof:yes">1</span></span>/<span style="mso-field-code: NUMPAGES;"><span style="mso-no-proof:yes">1</span></span>
                                </td>
                            </tr>
                        </table>
                    </div>
                </td>
            </tr>
        </table>
         <!-- / Code spécifique Microsoft Word pour la gestion des headers/footers -->
    </xsl:template>
</xsl:stylesheet>
