/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.clientsideelement;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.data.ContentValue;
import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.odf.tree.ODFTreeToolClientSideElement;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.i18n.I18nUtils;

public class CostModelingClientSideElement
extends ODFTreeToolClientSideElement
implements Contextualizable {
    public static final String ROLE = CostModelingClientSideElement.class.getName();
    protected OdfReferenceTableHelper _refTableHelper;
    protected Context _context;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._refTableHelper = (OdfReferenceTableHelper)smanager.lookup(OdfReferenceTableHelper.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    protected void _lazyConfigure() {
        super._lazyConfigure();
        this._script.getParameters().put("enseignement-natures", this.getEnseignementNatures());
    }

    public Map<String, Map<String, Object>> getEnseignementNatures() {
        Map objectModel = ContextHelper.getObjectModel((Context)this._context);
        Locale locale = I18nUtils.findLocale((Map)objectModel, (String)"locale", null, (Locale)Locale.getDefault(), (boolean)true);
        String lang = locale.getLanguage();
        return ((Stream)this._refTableHelper.getItems("odf-enumeration.EnseignementNature").stream().sequential()).sorted(Comparator.comparingLong(this::_orderFromCategory).thenComparingLong(OdfReferenceTableEntry::getOrder).thenComparing(OdfReferenceTableEntry::getCode)).collect(Collectors.toMap(OdfReferenceTableEntry::getCode, entry -> Map.of("id", entry.getId(), "label", entry.getLabel(lang), "archived", entry.isArchived()), (a, b) -> a, LinkedHashMap::new));
    }

    private Long _orderFromCategory(OdfReferenceTableEntry referenceTableEntry) {
        return Optional.of(referenceTableEntry).map(OdfReferenceTableEntry::getContent).map(c -> (ContentValue)c.getValue("category")).flatMap(ContentValue::getContentIfExists).map(c -> (Long)c.getValue("order", false, (Object)Long.MAX_VALUE)).orElse(Long.MAX_VALUE);
    }
}

