/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.content.compare.ContentComparator;
import org.ametys.cms.content.compare.ContentComparatorChange;
import org.ametys.cms.content.compare.ContentComparatorResult;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.plugins.odfpilotage.report.impl.AbstractMCCReport;
import org.ametys.plugins.odfpilotage.report.impl.mcc.MCCProgramItemTree;
import org.ametys.plugins.odfpilotage.schedulable.AbstractReportSchedulable;
import org.ametys.plugins.odfpilotage.schedulable.OrgUnitMCCDiffReportSchedulable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.plugins.repository.data.holder.group.RepeaterEntry;
import org.ametys.runtime.model.ModelItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MCCDiffReport
extends AbstractMCCReport {
    public static final String PARAMETER_CATALOG_OLD = "catalogOld";
    private ContentComparator _contentComparator;

    @Override
    protected String getType(Map<String, String> reportParameters) {
        return "mccdiff";
    }

    @Override
    protected boolean isCompatibleSchedulable(AbstractReportSchedulable schedulable) {
        return schedulable instanceof OrgUnitMCCDiffReportSchedulable;
    }

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._contentComparator = (ContentComparator)manager.lookup(ContentComparator.ROLE);
    }

    @Override
    protected MCCProgramItemTree _createMCCTreeFromProgramItem(ProgramItem programItem, Map<String, String> reportParameters) {
        ProgramItem oldProgramItem = this._findOldProgramItem(programItem, reportParameters.get(PARAMETER_CATALOG_OLD));
        ContentComparatorResult changes = this._getObjectChanges(oldProgramItem, programItem);
        MCCProgramItemTree programItemTree = new MCCProgramItemTree(programItem, changes);
        this.populateMCCTree(programItemTree);
        return programItemTree;
    }

    @Override
    protected void populateMCCTree(MCCProgramItemTree tree) {
        ProgramItem oldProgramItem = (ProgramItem)tree.getChange().getContent1();
        ProgramItem newProgramItem = (ProgramItem)tree.getChange().getContent2();
        if (oldProgramItem == null) {
            List children = this._odfHelper.getChildProgramItems(newProgramItem);
            for (ProgramItem child : children) {
                ContentComparatorResult changes = this._getObjectChanges(null, child);
                MCCProgramItemTree childTree = tree.addChild(child, changes);
                this.populateMCCTree(childTree);
            }
        } else if (newProgramItem == null) {
            List children = this._odfHelper.getChildProgramItems(oldProgramItem);
            for (ProgramItem child : children) {
                ContentComparatorResult changes = this._getObjectChanges(child, null);
                MCCProgramItemTree childTree = tree.addChild(child, changes);
                this.populateMCCTree(childTree);
            }
        } else {
            List oldChildren = this._odfHelper.getChildProgramItems(oldProgramItem);
            List newChildren = this._odfHelper.getChildProgramItems(newProgramItem);
            for (ProgramItem newChild : newChildren) {
                ProgramItem currentOldChild = null;
                Class<?> newChildClass = newChild.getClass();
                String newChildCode = newChild.getCode();
                for (ProgramItem oldChild : oldChildren) {
                    if (!oldChild.getCode().equals(newChildCode) || !oldChild.getClass().equals(newChildClass)) continue;
                    currentOldChild = oldChild;
                    oldChildren.remove(oldChild);
                    break;
                }
                ContentComparatorResult changes = this._getObjectChanges(currentOldChild, newChild);
                MCCProgramItemTree childTree = tree.addChild(newChild, changes);
                this.populateMCCTree(childTree);
            }
            for (ProgramItem oldChild : oldChildren) {
                ContentComparatorResult changes = this._getObjectChanges(oldChild, null);
                MCCProgramItemTree childTree = tree.addChild(oldChild, changes);
                this.populateMCCTree(childTree);
            }
        }
    }

    private ContentComparatorResult _getObjectChanges(ProgramItem oldProgramItem, ProgramItem newProgramItem) {
        return oldProgramItem instanceof Course || newProgramItem instanceof Course ? this._getCourseChanges((Course)oldProgramItem, (Course)newProgramItem) : new ContentComparatorResult((Content)oldProgramItem, (Content)newProgramItem);
    }

    private ContentComparatorResult _getCourseChanges(Course oldCourse, Course newCourse) {
        if (oldCourse == null || newCourse == null) {
            return new ContentComparatorResult((Content)oldCourse, (Content)newCourse);
        }
        ContentComparatorResult changes = null;
        try {
            changes = this._contentComparator.compare((Content)oldCourse, (Content)newCourse, "mcc");
            if (this.getLogger().isDebugEnabled() && !changes.areEquals()) {
                this.getLogger().debug("Diff\u00e9rence trouv\u00e9e pour l'ELP {} - {}", (Object)oldCourse.getCode(), (Object)oldCourse.getTitle());
            }
        }
        catch (IOException | AmetysRepositoryException e) {
            this.getLogger().error("Une erreur est survenue pour l'ELP {} - {}", new Object[]{oldCourse.getCode(), oldCourse.getTitle(), e});
        }
        return changes;
    }

    private <T extends ProgramItem> T _findOldProgramItem(T content, String oldCatalog) {
        return (T)this._odfHelper.getProgramItem(content, oldCatalog, content.getLanguage());
    }

    private Optional<ModelAwareRepeater> _getRepeater(Content content, String sessionName) {
        return Optional.ofNullable(content).map(c -> c.getRepeater(sessionName));
    }

    private Set<Integer> _getEntryPositions(Optional<ModelAwareRepeater> repeater) {
        return repeater.map(ModelAwareRepeater::getEntries).map(Collection::stream).orElseGet(() -> Stream.of(new ModelAwareRepeaterEntry[0])).map(RepeaterEntry::getPosition).collect(Collectors.toSet());
    }

    private ModelAwareRepeaterEntry _getEntry(Optional<ModelAwareRepeater> repeater, Integer position) {
        return repeater.map(s -> s.getEntry(position.intValue())).orElse(null);
    }

    @Override
    protected void _saxMCCs(ContentHandler handler, Course course, MCCProgramItemTree tree) throws SAXException {
        XMLUtils.startElement((ContentHandler)handler, (String)"mcc");
        this._saxSession(handler, tree, "mccSession1");
        this._saxSession(handler, tree, "mccSession2");
        XMLUtils.endElement((ContentHandler)handler, (String)"mcc");
    }

    private void _saxSession(ContentHandler handler, MCCProgramItemTree tree, String sessionName) throws SAXException {
        boolean newContentSessionEnabled;
        ContentComparatorResult changes = tree.getChange();
        Content oldContent = changes.getContent1();
        Content newContent = changes.getContent2();
        ModelItem sessionDefinition = this._sessionsView.getModelViewItem(sessionName).getDefinition();
        boolean oldContentSessionEnabled = oldContent != null && !this._disableConditionsEvaluator.evaluateDisableConditions(sessionDefinition, sessionName, (Object)oldContent);
        boolean bl = newContentSessionEnabled = newContent != null && !this._disableConditionsEvaluator.evaluateDisableConditions(sessionDefinition, sessionName, (Object)newContent);
        if (oldContentSessionEnabled || newContentSessionEnabled) {
            XMLUtils.startElement((ContentHandler)handler, (String)sessionName);
            Optional<ModelAwareRepeater> oldSession = oldContentSessionEnabled ? this._getRepeater(oldContent, sessionName) : Optional.empty();
            Optional<ModelAwareRepeater> newSession = newContentSessionEnabled ? this._getRepeater(newContent, sessionName) : Optional.empty();
            TreeSet<Integer> allEntryPositions = new TreeSet<Integer>();
            allEntryPositions.addAll(this._getEntryPositions(oldSession));
            allEntryPositions.addAll(this._getEntryPositions(newSession));
            if (!allEntryPositions.isEmpty()) {
                for (Integer entryPosition : allEntryPositions) {
                    ModelAwareRepeaterEntry oldEntry = this._getEntry(oldSession, entryPosition);
                    ModelAwareRepeaterEntry newEntry = this._getEntry(newSession, entryPosition);
                    if (oldEntry == null) {
                        this._saxSessionEntry(handler, newEntry, newContent, ChangeType.ADDED);
                        continue;
                    }
                    if (newEntry == null) {
                        this._saxSessionEntry(handler, oldEntry, oldContent, ChangeType.REMOVED);
                        continue;
                    }
                    if (changes.areEquals() || !this._hasChanges(changes, sessionName, entryPosition)) {
                        this._saxSessionEntry(handler, newEntry, newContent, null);
                        continue;
                    }
                    if (this._hasSameNature(oldEntry, newEntry)) {
                        this._saxSessionEntry(handler, oldEntry, oldContent, ChangeType.MODIFIED_OLD);
                        this._saxSessionEntry(handler, newEntry, newContent, ChangeType.MODIFIED_NEW);
                        continue;
                    }
                    this._saxSessionEntry(handler, oldEntry, oldContent, ChangeType.REMOVED);
                    this._saxSessionEntry(handler, newEntry, newContent, ChangeType.ADDED);
                }
            }
            XMLUtils.endElement((ContentHandler)handler, (String)sessionName);
        }
    }

    private void _saxSessionEntry(ContentHandler handler, ModelAwareRepeaterEntry sessionEntry, Content rootContent, ChangeType changeType) throws SAXException {
        AttributesImpl entryAttrs = new AttributesImpl();
        entryAttrs.addCDATAAttribute("name", String.valueOf(sessionEntry.getPosition()));
        if (changeType != null) {
            entryAttrs.addCDATAAttribute("changeType", changeType.name().toLowerCase());
        }
        XMLUtils.startElement((ContentHandler)handler, (String)"entry", (Attributes)entryAttrs);
        this._saxSessionEntryDetails(handler, sessionEntry, rootContent);
        XMLUtils.endElement((ContentHandler)handler, (String)"entry");
    }

    private boolean _hasSameNature(ModelAwareRepeaterEntry oldEntry, ModelAwareRepeaterEntry newEntry) {
        ContentValue nature1 = (ContentValue)oldEntry.getValue("natureEnseignement");
        ContentValue nature2 = (ContentValue)newEntry.getValue("natureEnseignement");
        return Objects.equals(nature1, nature2);
    }

    private boolean _hasChanges(ContentComparatorResult result, String sessionName, Integer entryPosition) {
        String beginMetadataPath = sessionName + "[" + entryPosition + "]/";
        for (ContentComparatorChange change : result.getChanges()) {
            if (!change.getPath().startsWith(beginMetadataPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void saxGlobalInformations(ContentHandler handler, ProgramItem programItem, Map<String, String> reportParameters) throws SAXException {
        super.saxGlobalInformations(handler, programItem, reportParameters);
        String oldCatalog = reportParameters.get(PARAMETER_CATALOG_OLD);
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", oldCatalog);
        XMLUtils.createElement((ContentHandler)handler, (String)PARAMETER_CATALOG_OLD, (Attributes)attrs, (String)this._catalogsManager.getCatalog(oldCatalog).getTitle());
    }

    protected static enum ChangeType {
        ADDED,
        REMOVED,
        MODIFIED_OLD,
        MODIFIED_NEW;

    }
}

