/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.impl;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.cms.repository.ModifiableDefaultContent;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfpilotage.report.impl.AbstractExtract;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MaquetteExtract
extends AbstractExtract {
    @Override
    protected String getType(Map<String, String> reportParameters) {
        return "maquette";
    }

    @Override
    public Set<String> getSupportedOutputFormats() {
        return Set.of("doc", "xls");
    }

    @Override
    public void saxProgramItem(ContentHandler handler, String programItemId, Map<String, String> reportParameters) {
        ProgramItem programItem = (ProgramItem)this._resolver.resolveById(programItemId);
        if (!(programItem instanceof Program)) {
            throw new UnsupportedOperationException("The report '" + this.getType() + "' can be launch only on programs.");
        }
        Program program = (Program)programItem;
        try {
            handler.startDocument();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("type", this.getType());
            XMLUtils.startElement((ContentHandler)handler, (String)"report", (Attributes)attrs);
            this._reportHelper.saxNaturesEnseignement(handler, this.getLogger());
            AttributesImpl attr = new AttributesImpl();
            attr.addCDATAAttribute("formation", program.getTitle());
            attr.addCDATAAttribute("COD_DIP", this._getCodeDIP((ModifiableDefaultContent)program));
            attr.addCDATAAttribute("COD_VDI", this._getCodeVRSVDI((ModifiableDefaultContent)program));
            XMLUtils.startElement((ContentHandler)handler, (String)"program", (Attributes)attr);
            this._saxProgramTree(handler, this._reportHelper.getCoursesFromContent((ProgramItem)program));
            XMLUtils.endElement((ContentHandler)handler, (String)"program");
            XMLUtils.endElement((ContentHandler)handler, (String)"report");
            handler.endDocument();
        }
        catch (Exception e) {
            this.getLogger().error("An error occured while generating 'Maquette' extract for program '{}' ({})", new Object[]{program.getTitle(), program.getCode(), e});
        }
    }

    private void _saxProgramTree(ContentHandler handler, Map<ProgramItem, Object> programTree) throws SAXException {
        LinkedHashMap sortedProgramTree = new LinkedHashMap();
        programTree.entrySet().stream().sorted(Map.Entry.comparingByKey(new ProgramItemComparator())).forEach(e -> sortedProgramTree.put((ProgramItem)e.getKey(), e.getValue()));
        for (Map.Entry node : sortedProgramTree.entrySet()) {
            ProgramItem programItem = (ProgramItem)node.getKey();
            Map subTree = (Map)node.getValue();
            if (programItem instanceof SubProgram) {
                SubProgram subProgram = (SubProgram)programItem;
                this._saxSubProgram(handler, subProgram, subTree);
                continue;
            }
            if (programItem instanceof Container) {
                Container container = (Container)programItem;
                this._saxContainer(handler, container, subTree);
                continue;
            }
            if (programItem instanceof Course) {
                Course course = (Course)programItem;
                this._saxCourse(handler, course, subTree);
                continue;
            }
            if (!(programItem instanceof CourseList)) continue;
            CourseList courseList = (CourseList)programItem;
            this._saxCourseList(handler, courseList, subTree);
        }
    }

    private void _saxSubProgram(ContentHandler handler, SubProgram subprogram, Map<ProgramItem, Object> programTree) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addCDATAAttribute("parcours", subprogram.getTitle());
        XMLUtils.startElement((ContentHandler)handler, (String)"subprogram", (Attributes)attr);
        this._saxProgramTree(handler, programTree);
        XMLUtils.endElement((ContentHandler)handler, (String)"subprogram");
    }

    private void _saxContainer(ContentHandler handler, Container container, Map<ProgramItem, Object> programTree) throws SAXException {
        long codeAnu;
        AttributesImpl attr = new AttributesImpl();
        attr.addCDATAAttribute("id", container.getId());
        attr.addCDATAAttribute("libelle", container.getTitle());
        String containerNature = this._refTableHelper.getItemCode(container.getNature());
        attr.addCDATAAttribute("type", containerNature);
        if ("annee".equals(containerNature)) {
            attr.addCDATAAttribute("COD_ETP", (String)container.getValue("etpCode", false, (Object)""));
            attr.addCDATAAttribute("COD_VRS_ETP", (String)container.getValue("vrsEtpCode", false, (Object)""));
        }
        if ((codeAnu = ((Long)container.getValue("CodeAnu", false, (Object)0L)).longValue()) > 0L) {
            attr.addCDATAAttribute("HeaderCodeAnu", "Maquette " + String.valueOf(codeAnu) + "-" + String.valueOf(codeAnu + 1L));
        }
        XMLUtils.startElement((ContentHandler)handler, (String)"container", (Attributes)attr);
        this._saxProgramTree(handler, programTree);
        XMLUtils.endElement((ContentHandler)handler, (String)"container");
    }

    private void _saxCourse(ContentHandler handler, Course course, Map<ProgramItem, Object> programTree) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addCDATAAttribute("CodeAmetysELP", course.getCode());
        attr.addCDATAAttribute("CodeApogee", (String)course.getValue("elpCode", false, (Object)""));
        attr.addCDATAAttribute("natureElement", this._refTableHelper.getItemCode(course.getCourseType()));
        attr.addCDATAAttribute("ects", String.valueOf(course.getEcts()));
        Container containerEtape = Optional.ofNullable((ContentValue)course.getValue("etapePorteuse")).flatMap(contentValue -> this._getEtapePorteuseIfExists((ContentValue)contentValue, course)).map(Container.class::cast).orElse(null);
        if (containerEtape != null) {
            attr.addCDATAAttribute("etapePorteuse", containerEtape.getTitle());
            attr.addCDATAAttribute("idEtapePorteuse", containerEtape.getId());
            if (containerEtape.hasValue("etpCode")) {
                attr.addCDATAAttribute("codeEtapePorteuse", containerEtape.getValue("etpCode") + (String)(containerEtape.hasValue("vrsEtpCode") ? "-" + containerEtape.getValue("vrsEtpCode") : ""));
            }
        }
        if (course.hasValue("CodeAnu")) {
            long codeAnu = (Long)course.getValue("CodeAnu");
            attr.addCDATAAttribute("HeaderCodeAnu", "Maquette " + String.valueOf(codeAnu) + "-" + String.valueOf(codeAnu + 1L));
        }
        XMLUtils.startElement((ContentHandler)handler, (String)"course", (Attributes)attr);
        String shortLabel = (String)course.getValue("shortLabel");
        if (StringUtils.isNotBlank((CharSequence)shortLabel)) {
            XMLUtils.createElement((ContentHandler)handler, (String)"shortLabel", (String)shortLabel);
        }
        XMLUtils.createElement((ContentHandler)handler, (String)"libelle", (String)course.getTitle());
        long courseListsSize = course.getParentCourseLists().size();
        XMLUtils.createElement((ContentHandler)handler, (String)"partage", (String)(courseListsSize > 1L ? "X" : ""));
        XMLUtils.createElement((ContentHandler)handler, (String)"occurrences", (String)this._reportHelper.formatNumberToSax(courseListsSize));
        for (CoursePart coursePart : course.getCourseParts()) {
            attr = new AttributesImpl();
            attr.addCDATAAttribute("nature", coursePart.getNature());
            XMLUtils.createElement((ContentHandler)handler, (String)"volumeHoraire", (Attributes)attr, (String)String.valueOf(coursePart.getNumberOfHours()));
        }
        this._saxProgramTree(handler, programTree);
        XMLUtils.endElement((ContentHandler)handler, (String)"course");
    }

    private Optional<ModifiableContent> _getEtapePorteuseIfExists(ContentValue etapePorteuse, Course course) {
        try {
            return Optional.ofNullable(etapePorteuse.getContent());
        }
        catch (UnknownAmetysObjectException e) {
            this.getLogger().error("Course {} {}", new Object[]{course.getId(), e.getMessage(), e});
            return Optional.empty();
        }
    }

    private void _saxCourseList(ContentHandler handler, CourseList courseList, Map<ProgramItem, Object> programTree) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        CourseList.ChoiceType typeList = courseList.getType();
        if (typeList.name().equals(CourseList.ChoiceType.CHOICE.toString()) && courseList.getMinNumberOfCourses() > 0L) {
            attr.addCDATAAttribute("choice", String.valueOf(courseList.getMinNumberOfCourses()));
        } else if (typeList.name().equals(CourseList.ChoiceType.OPTIONAL.toString())) {
            attr.addCDATAAttribute("optional", "true");
        }
        XMLUtils.startElement((ContentHandler)handler, (String)"courselist", (Attributes)attr);
        this._saxProgramTree(handler, programTree);
        XMLUtils.endElement((ContentHandler)handler, (String)"courselist");
    }

    private String _getCodeVRSVDI(ModifiableDefaultContent content) {
        String defaultCode = StringUtils.substringAfter((String)((ProgramItem)content).getCode(), (String)"-");
        return (String)content.getValue("codeVRSVDI", false, (Object)defaultCode);
    }

    private String _getCodeDIP(ModifiableDefaultContent content) {
        String defaultCode = StringUtils.substringBefore((String)((ProgramItem)content).getCode(), (String)"-");
        return (String)content.getValue("codeDIP", false, (Object)defaultCode);
    }

    private static final class ProgramItemComparator
    implements Comparator<ProgramItem> {
        private ProgramItemComparator() {
        }

        @Override
        public int compare(ProgramItem p1, ProgramItem p2) {
            if (p1 instanceof CourseList && !(p2 instanceof CourseList)) {
                return 1;
            }
            if (!(p1 instanceof CourseList) && p2 instanceof CourseList) {
                return -1;
            }
            if (p1 instanceof CourseList) {
                CourseList cl1 = (CourseList)p1;
                if (p2 instanceof CourseList) {
                    CourseList.ChoiceType t2;
                    CourseList cl2 = (CourseList)p2;
                    CourseList.ChoiceType t1 = cl1.getType();
                    if (t1.equals((Object)(t2 = cl2.getType()))) {
                        return 0;
                    }
                    if (t1.equals((Object)CourseList.ChoiceType.MANDATORY) || !t2.equals((Object)CourseList.ChoiceType.MANDATORY) && t1.equals((Object)CourseList.ChoiceType.CHOICE)) {
                        return -1;
                    }
                    return 1;
                }
            }
            return 0;
        }
    }
}

