/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.impl;

import java.time.LocalDate;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.DateUtils;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.ProgramPart;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfpilotage.helper.PilotageStatusHelper;
import org.ametys.plugins.odfpilotage.report.impl.AbstractExtract;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ReglementEtudesExtract
extends AbstractExtract {
    protected PilotageStatusHelper _pilotageStatusHelper;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._pilotageStatusHelper = (PilotageStatusHelper)((Object)manager.lookup(PilotageStatusHelper.ROLE));
    }

    @Override
    protected String getType(Map<String, String> reportParameters) {
        return "reglementetudes";
    }

    @Override
    public void saxProgramItem(ContentHandler handler, String programItemId, Map<String, String> reportParameters) {
        ProgramItem programItem = (ProgramItem)this._resolver.resolveById(programItemId);
        if (!(programItem instanceof Program)) {
            throw new UnsupportedOperationException("The report '" + this.getType() + "' can be launch only on programs.");
        }
        Program program = (Program)programItem;
        try {
            handler.startDocument();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("type", this.getType());
            XMLUtils.startElement((ContentHandler)handler, (String)"report", (Attributes)attrs);
            this._saxReport(handler, program, this._odfHelper.getChildSubPrograms((ProgramPart)program));
            XMLUtils.endElement((ContentHandler)handler, (String)"report");
            handler.endDocument();
        }
        catch (Exception e) {
            this.getLogger().error("An error occured while generating 'R\u00e8glements des \u00e9tudes' extract for program '{}' ({})", new Object[]{program.getTitle(), program.getCode(), e});
        }
    }

    private void _saxReport(ContentHandler handler, Program program, Set<SubProgram> subPrograms) throws SAXException {
        this._saxProgram(handler, program);
        for (SubProgram subProgram : subPrograms) {
            this._saxSubProgram(handler, subProgram);
        }
    }

    private void _saxProgram(ContentHandler handler, Program program) throws SAXException {
        String[] domains;
        String mentionId;
        AttributesImpl attr = new AttributesImpl();
        attr.addCDATAAttribute("title", program.getTitle());
        LocalDate date = this._pilotageStatusHelper.getCFVUValidationDate((Content)program);
        if (date != null) {
            attr.addCDATAAttribute("CFVUDate", DateUtils.localDateToString((LocalDate)date));
        }
        XMLUtils.startElement((ContentHandler)handler, (String)"program", (Attributes)attr);
        XMLUtils.createElement((ContentHandler)handler, (String)"catalog", (String)program.getCatalog());
        String degreeId = program.getDegree();
        if (StringUtils.isNotEmpty((CharSequence)degreeId)) {
            XMLUtils.createElement((ContentHandler)handler, (String)"degree", (String)this._refTableHelper.getItemLabel(degreeId, program.getLanguage()));
        }
        if (StringUtils.isNotEmpty((CharSequence)(mentionId = program.getMention()))) {
            XMLUtils.createElement((ContentHandler)handler, (String)"mention", (String)this._refTableHelper.getItemLabel(mentionId, program.getLanguage()));
        }
        for (String domain : domains = program.getDomain()) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("code", this._refTableHelper.getItemCode(domain));
            XMLUtils.createElement((ContentHandler)handler, (String)"domain", (Attributes)attrs, (String)this._refTableHelper.getItemLabel(domain, program.getLanguage()));
        }
        program.dataToSAX(handler, "reglementEtudes");
        XMLUtils.endElement((ContentHandler)handler, (String)"program");
    }

    private void _saxSubProgram(ContentHandler handler, SubProgram subprogram) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addCDATAAttribute("title", subprogram.getTitle());
        XMLUtils.startElement((ContentHandler)handler, (String)"subprogram", (Attributes)attr);
        subprogram.dataToSAX(handler, "reglementEtudes");
        XMLUtils.endElement((ContentHandler)handler, (String)"subprogram");
    }
}

