/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.rule.catalog;

import com.opensymphony.workflow.InvalidActionException;
import com.opensymphony.workflow.WorkflowException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.ametys.cms.data.holder.group.IndexableRepeaterEntry;
import org.ametys.cms.data.holder.group.ModifiableIndexableRepeater;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.repository.DefaultContent;
import org.ametys.cms.repository.LanguageExpression;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.odf.catalog.CopyCatalogUpdater;
import org.ametys.odf.program.Container;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableAmetysObject;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.RemovableAmetysObject;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.plugins.repository.data.holder.values.SynchronizableRepeater;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.plugins.repository.lock.LockableAmetysObject;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.plugins.workflow.component.CheckRightsCondition;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ThematicsUpdater
extends AbstractLogEnabled
implements CopyCatalogUpdater,
Serviceable {
    private AmetysObjectResolver _resolver;
    private ContentWorkflowHelper _contentWorkflowHelper;
    private ObservationManager _observationManager;
    private CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._contentWorkflowHelper = (ContentWorkflowHelper)manager.lookup(ContentWorkflowHelper.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
    }

    public void updateContents(String initialCatalogName, String newCatalogName, Map<Content, Content> copiedContents, Content targetParentContent) {
        for (Content initialContent : copiedContents.keySet()) {
            String code;
            if (!(initialContent instanceof Container)) continue;
            Content copiedContent = copiedContents.get(initialContent);
            this._copyInternalValue(initialContent, copiedContent, "TA");
            for (ModelAwareRepeaterEntry modelAwareRepeaterEntry : this._getRepeaterEntries(copiedContent, "thematics")) {
                code = (String)modelAwareRepeaterEntry.getValue("code");
                this._copyInternalValue(initialContent, copiedContent, code + "-ruleNumber");
            }
            for (ModelAwareRepeaterEntry modelAwareRepeaterEntry : this._getRepeaterEntries(copiedContent, "rules")) {
                if (!modelAwareRepeaterEntry.hasValue("thematicCode")) continue;
                code = (String)modelAwareRepeaterEntry.getValue("thematicCode");
                this._copyInternalValue(initialContent, copiedContent, code + "-ruleNumber");
            }
            ((ModifiableContent)copiedContent).saveChanges();
        }
    }

    private List<? extends ModelAwareRepeaterEntry> _getRepeaterEntries(Content content, String repeaterName) {
        return Optional.ofNullable(content.getRepeater(repeaterName)).map(r -> r.getEntries()).orElseGet(List::of);
    }

    private void _copyInternalValue(Content sourceContent, Content targetContent, String metadataName) {
        targetContent.getInternalDataHolder().setValue(metadataName, sourceContent.getInternalDataHolder().getValue(metadataName, (Object)0L));
    }

    public List<Content> getAdditionalContents(String catalogName) {
        return this._getContents(catalogName);
    }

    public void copyAdditionalContents(String initialCatalogName, String newCatalogName) {
        List contentsToCopy = this._getContents(initialCatalogName);
        for (DefaultContent thematic : contentsToCopy) {
            if (this._thematicExists((Content)thematic, newCatalogName)) {
                this.getLogger().info("A thematic already exists with the same code, catalog and language [{}, {}, {}]", new Object[]{thematic.getValue("code"), newCatalogName, thematic.getLanguage()});
                continue;
            }
            ModifiableContent newThematic = thematic.copyTo((ModifiableTraversableAmetysObject)thematic.getParent(), NameHelper.filterName((String)thematic.getTitle()));
            try {
                this._copyInternalValue((Content)thematic, (Content)newThematic, thematic.getValue("code") + "-ruleNumber");
                newThematic.saveChanges();
                HashMap<String, Object> values = new HashMap<String, Object>();
                values.put("catalog", newCatalogName);
                ArrayList<Integer> positions = new ArrayList<Integer>();
                ArrayList<Map<String, String>> repeaterValues = new ArrayList<Map<String, String>>();
                ModifiableIndexableRepeater repeater = newThematic.getRepeater("rules");
                if (repeater != null) {
                    for (IndexableRepeaterEntry entry : repeater.getEntries()) {
                        String status = (String)entry.getValue("status");
                        if ("NON_MODIFIED".equals(status) || "SUSPENDED".equals(status)) continue;
                        positions.add(entry.getPosition());
                        repeaterValues.add(Map.of("status", "NON_MODIFIED"));
                    }
                }
                if (!repeaterValues.isEmpty()) {
                    values.put("rules", SynchronizableRepeater.replace(repeaterValues, positions));
                }
                this._editContent((Content)newThematic, values);
            }
            catch (InvalidActionException | WorkflowException e) {
                this.getLogger().error("Impossible to update thematic '{}' ({}) while creating the catalog {}", new Object[]{newThematic.getTitle(), newThematic.getId(), newCatalogName});
                this._deleteContent((Content)newThematic);
            }
        }
    }

    private boolean _thematicExists(Content thematic, String newCatalogName) {
        return this._getContents(newCatalogName, thematic).findAny().isPresent();
    }

    private <T extends Content> List<T> _getContents(String catalogName) {
        return this._getContents(catalogName, null).toList();
    }

    private <T extends Content> Stream<T> _getContents(String catalogName, Content thematic) {
        ArrayList<Object> exprs = new ArrayList<Object>();
        exprs.add(new ContentTypeExpression(Expression.Operator.EQ, new String[]{"odf-enumeration.Thematic"}));
        exprs.add(new StringExpression("catalog", Expression.Operator.EQ, catalogName));
        if (thematic != null) {
            exprs.add(new LanguageExpression(Expression.Operator.EQ, thematic.getLanguage()));
            exprs.add(new StringExpression("code", Expression.Operator.EQ, (String)thematic.getValue("code")));
        }
        AndExpression expression = new AndExpression((Expression[])exprs.toArray(Expression[]::new));
        String query = ContentQueryHelper.getContentXPathQuery((Expression)expression);
        return this._resolver.query(query).stream();
    }

    private void _deleteContent(Content content) {
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("content", content);
        eventParams.put("content.name", content.getName());
        eventParams.put("content.id", content.getId());
        ModifiableAmetysObject parent = (ModifiableAmetysObject)content.getParent();
        this._observationManager.notify(new Event("content.deleting", this._currentUserProvider.getUser(), eventParams));
        LockableAmetysObject lockedContent = (LockableAmetysObject)content;
        if (lockedContent.isLocked()) {
            lockedContent.unlock();
        }
        ((RemovableAmetysObject)content).remove();
        parent.saveChanges();
        this._observationManager.notify(new Event("content.deleted", this._currentUserProvider.getUser(), eventParams));
    }

    private void _editContent(Content content, Map<String, Object> values) throws AmetysRepositoryException, WorkflowException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("typedValues", values);
        parameters.put("quit", true);
        HashMap<String, Serializable> inputs = new HashMap<String, Serializable>();
        inputs.put(AbstractWorkflowComponent.CONTEXT_PARAMETERS_KEY, parameters);
        inputs.put(CheckRightsCondition.FORCE, Boolean.valueOf(true));
        this._contentWorkflowHelper.doAction((WorkflowAwareContent)content, 222, inputs);
    }
}

