/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

 /**
  * MCC course tree grid panel
  * @private
  */
Ext.define('Ametys.plugins.odf.pilotage.tool.MCCCourseTreeGridPanel', {
    extend: 'Ametys.plugins.odf.pilotage.tool.ContentViewTreeGridPanel',
    
    constructor: function(config)
    {
        config.cls = Ext.Array.from(config.cls);
        config.cls.push("mcccoursetreegrid");
        
        this.callParent(arguments);
    },
    
    _beforeEditContentCB2: function(response, args, record)
    {
        this.callParent(arguments);
        
        if (this.editingPlugin.editing 
            && this.editingPlugin.getActiveColumn().type == 'repeater'
            && (record.data['notEditableData'] === true
                || record.data['notEditableDataIndex'] && Ext.Array.contains(record.data['notEditableDataIndex'], this.forceReadonlyField)))
        {
            let dialog = Ext.getCmp(this.editingPlugin.getActiveEditor().field._dialogId);
            dialog.setReadOnly();
        }
    }
});