<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:exsl="http://exslt.org/common"
                              xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
                              exclude-result-prefixes="exsl odf">
    
    <xsl:param name="shortLabelToDisplay">
        <!-- Syntax to force some values to be displayed by short label instead of code
        <display typeId="odf-enumeration.EnseignementNature"/>
        <display typeId="odf-enumeration.MccSessionNature"/>
        <display typeId="odf-enumeration.MccModaliteSession1"/>
         -->
    </xsl:param>
    
    <xsl:param name="nbColumnsMaquette" select="11"/>
    <xsl:param name="nbColumnsElpEval" select="0"/>
    <xsl:param name="nbColumnsMccSession1" select="7"/>
    <xsl:param name="nbColumnsMccSession2" select="6"/>
    <xsl:param name="titleColumnPosition" select="4"/>
    <xsl:variable name="nbColumns" select="$nbColumnsMaquette + $nbColumnsElpEval + $nbColumnsMccSession1 + $nbColumnsMccSession2"/>
    
    <xsl:variable name="root" select="/"/>
    
    <xsl:variable name="naturesEnseignement">
        <xsl:for-each select="/report/items[@id = 'odf-enumeration.EnseignementNature']/category/item">
            <xsl:sort select="../@order" data-type="number"/>
            <xsl:sort select="../@code" data-type="text"/>
            <xsl:sort select="@order" data-type="number"/>
            <xsl:sort select="@code" data-type="text"/>
            
            <xsl:variable name="currentId" select="@id"/>
            <xsl:if test="$root//*[@id = $currentId and local-name() != 'item']">
                <item id="{@id}" code="{@code}"><xsl:value-of select="."/></item>
            </xsl:if>
        </xsl:for-each>
    </xsl:variable>
    
    <xsl:variable name="referenceTables">
        <xsl:copy-of select="odf:getTableRefItems('odf-enumeration.CourseNature', /report/lang, true())"/>
        <xsl:copy-of select="odf:getTableRefItems('odf-enumeration.MccRegime', /report/lang, true())"/>
        <xsl:copy-of select="odf:getTableRefItems('odf-enumeration.MccModaliteSession1', /report/lang, true())"/>
        <xsl:copy-of select="odf:getTableRefItems('odf-enumeration.MccModaliteSession2', /report/lang, true())"/>
        <xsl:copy-of select="odf:getTableRefItems('odf-enumeration.MccSessionNature', /report/lang, true())"/>
    </xsl:variable>
    
    <xsl:template match="program|subProgram|container|course" mode="code">
        <xsl:value-of select="code"/>
    </xsl:template>
    
    <xsl:template match="program|subProgram|container|course" mode="code-parenthesis">
        <xsl:variable name="code"><xsl:apply-templates select="." mode="code"/></xsl:variable>
        <xsl:if test="$code != ''">
            <xsl:text> (</xsl:text><xsl:value-of select="$code"/><xsl:text>)</xsl:text>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="displayCodeOrShortLabel">
        <xsl:param name="contentId"/>
        
        <xsl:variable name="currentEntry" select="$root/report/items//item[@id = $contentId]|exsl:node-set($referenceTables)/items//item[@id = $contentId]"/>
        <xsl:variable name="displayShortLabel" select="$currentEntry/@shortLabel != '' and count(exsl:node-set($shortLabelToDisplay)/display[@typeId = $currentEntry/ancestor::items/@id]) > 0" />
        <xsl:choose>
            <xsl:when test="$displayShortLabel">
                <xsl:value-of select="$currentEntry/@shortLabel"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$currentEntry/@code"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
