<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                              xmlns:fo="http://www.w3.org/1999/XSL/Format"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:cms="http://ametys.org/cms/3.0" 
                              xmlns:exsl="http://exslt.org/common"
                              exclude-result-prefixes="i18n docbook exsl"
                              extension-element-prefixes="cms">
    
    <xsl:import href="view://stylesheets/helper/common.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/thematics/export/container/common/common.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/thematics/export/common2pdf.xsl" />
    
    <xsl:variable name="thematicsRoot" select="/root/thematics"/>
    <xsl:variable name="mainContent" select="$thematicsRoot/container"/>
    
    <xsl:template match="/">
        <xsl:apply-templates select="/root/thematics"/>
    </xsl:template>
    
    <xsl:template match="/root/thematics">
        <xsl:call-template name="root"/>
    </xsl:template>
    
    <xsl:template name="menu-items">
        <xsl:variable name="non-empty-thematics">
            <xsl:call-template name="get-non-empty-thematics"/>
        </xsl:variable>
        
        <fo:bookmark-tree>
            <fo:bookmark internal-destination="rules">
                <fo:bookmark-title><i18n:text key="PLUGINS_ODF_PILOTAGE_EXPORT_BOOKMARK_RULES" catalogue="plugin.odf-pilotage"/></fo:bookmark-title>
                
                <xsl:call-template name="contents-menu-items">
                    <xsl:with-param name="contents" select="exsl:node-set($non-empty-thematics)/*"/>
                </xsl:call-template>
                <xsl:apply-templates select="container-rules/thematics/entry[rules/entry]" mode="menu-item">
                    <xsl:sort select="@name" data-type="number"/>
                </xsl:apply-templates>
                <xsl:call-template name="specific-menu-items"/>
            </fo:bookmark>
            
            <xsl:if test="//fo:bookmark-tree/*">
                <fo:bookmark internal-destination="last-sequence">
                    <fo:bookmark-title><i18n:text key="PLUGINS_ODF_PILOTAGE_EXPORT_BOOKMARK_EPREUVES" catalogue="plugin.odf-pilotage"/></fo:bookmark-title>
                    <xsl:copy-of select="//fo:bookmark-tree/*"/>
                </fo:bookmark>
            </xsl:if>
        </fo:bookmark-tree>
    </xsl:template>
    
    <xsl:template name="property-title">
        <xsl:call-template name="title-label"/> - <xsl:value-of select="$thematicsRoot/container/title"/> - <xsl:value-of select="$thematicsRoot/container/catalog"/>
    </xsl:template>
    
    <xsl:template name="sequence-id">
        <xsl:if test="not(//fo:page-sequence[@id = 'last-sequence'])">
            <xsl:attribute name="id">last-sequence</xsl:attribute>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="sequences">
        <xsl:call-template name="main-sequence"/>
        
        <xsl:for-each select="//fo:page-sequence[@id != 'first-page-sequence']">
            <xsl:copy>
                <xsl:copy-of select="@*"/>
                <xsl:call-template name="xsl-region-after"/>
                <xsl:copy-of select="*[@flow-name!='footer']"/>
            </xsl:copy>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="title">
        <fo:block text-align="center" font-size="140%" font-weight="bold" color="{$mainColor}"><xsl:call-template name="title-label"/></fo:block>
        <fo:block text-align="center" font-size="130%" font-weight="bold" color="{$mainColor}"><xsl:value-of select="container/catalog"/></fo:block>
        <fo:block text-align="center" font-size="130%" font-weight="bold" color="{$mainColor}"><xsl:value-of select="container/title"/></fo:block>
    </xsl:template>
    
    <xsl:template name="flow-content">
        <xsl:variable name="non-empty-thematics">
            <xsl:call-template name="get-non-empty-thematics"/>
        </xsl:variable>
        
        <fo:block-container id="rules">
            <fo:block/><!-- Avoid empty block container -->
            <xsl:call-template name="contents">
                <xsl:with-param name="contents" select="exsl:node-set($non-empty-thematics)/*"/>
            </xsl:call-template>
            <xsl:apply-templates select="container-rules/thematics/entry[rules/entry]">
                <xsl:sort select="@name" data-type="number"/>
            </xsl:apply-templates>
            <xsl:call-template name="specific-data"/>
        </fo:block-container>
    </xsl:template>
    
    <xsl:template match="content">
        <xsl:param name="prefix" select="''"/>
        
        <fo:block-container table-layout="fixed" id="{$prefix}rg-{code}" margin-top="5mm">
            <xsl:call-template name="thematic-title"/>
            <fo:block margin-left="1cm" text-align="justify">
                <xsl:call-template name="rules"/>
            </fo:block>
        </fo:block-container>
    </xsl:template>
    
    <xsl:template name="rules">
        <xsl:for-each select="rules/entry[status/@value != 'SUSPENDED']">
            <xsl:variable name="derogatedRule" select="$containerRules[code = current()/code]"/>
            <xsl:choose>
                <xsl:when test="$derogatedRule">
                    <xsl:apply-templates select="$derogatedRule" mode="derogated-rule"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="." mode="general-rule"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
        <xsl:variable name="thematicCode" select="current()/code"/>
        <xsl:apply-templates select="$containerRules[thematicCode = $thematicCode]" mode="new-rule"/>
    </xsl:template>
    
    <xsl:template match="entry">
        <xsl:param name="prefix" select="''"/>
        
        <fo:block-container table-layout="fixed" id="{$prefix}rg-{code}" margin-top="5mm">
            <fo:block font-weight="bold" color="{$color-new}" keep-with-next.within-page="1">
                <xsl:value-of select="title"/>
            </fo:block>
            <fo:block margin-left="1cm" text-align="justify">
                <xsl:apply-templates select="rules/entry" mode="new-rule"/>
            </fo:block>
        </fo:block-container>
    </xsl:template>
    
    <xsl:template name="thematic-title">
        <fo:block font-weight="bold" keep-with-next.within-page="1">
            <xsl:value-of select="title"/>
        </fo:block>
    </xsl:template>
    
    <xsl:template match="entry" mode="new-rule">
        <fo:block color="{$color-new}"><xsl:apply-templates select="text/docbook:article"/></fo:block>
        
        <xsl:if test="$displayMotivation and cms:isNotRichTextEmpty(motivation)">
            <fo:block color="{$color-motivation}">
                <fo:block text-decoration="underline" keep-with-next.within-page="1"><i18n:text key="PLUGINS_ODF_PILOTAGE_EXPORT_MOTIVATION_ADDITIONAL" catalogue="plugin.odf-pilotage"/></fo:block>
                <fo:block><xsl:apply-templates select="motivation/docbook:article"/></fo:block>
            </fo:block>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="entry" mode="derogated-rule">
        <fo:block color="{$color-derogated}"><xsl:apply-templates select="text/docbook:article"/></fo:block>
        
        <xsl:if test="$displayMotivation and cms:isNotRichTextEmpty(motivation)">
            <fo:block color="{$color-motivation}">
                <fo:block text-decoration="underline" keep-with-next.within-page="1"><i18n:text key="PLUGINS_ODF_PILOTAGE_EXPORT_MOTIVATION_DEROGATION" catalogue="plugin.odf-pilotage"/></fo:block>
                <fo:block><xsl:apply-templates select="motivation/docbook:article"/></fo:block>
            </fo:block>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="entry" mode="general-rule">
        <fo:block><xsl:apply-templates select="text/docbook:article"/></fo:block>
    </xsl:template>
    
    <xsl:template name="specific-menu-items"/>
    
    <xsl:template name="specific-data"/>
</xsl:stylesheet>