<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                exclude-result-prefixes="i18n">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/thematics/export/common2pdf.xsl" />
    
    <xsl:param name="showArchived" select="false()"/>
    
    <xsl:variable name="mainContent" select="/export"/>
    <xsl:variable name="degree" select="/export/filters/degree"/>
    <xsl:variable name="groups" select="/export/groups"/>
    
    <xsl:template name="menu-items">
        <xsl:variable name="contents" select="contents/content"/>
        
        <fo:bookmark-tree>
            <!-- RG without number of sessions restrictions -->
            <xsl:call-template name="session-menu-items">
                <xsl:with-param name="contents" select="$contents[not(nbSessions)]"/>
            </xsl:call-template>
            
            <!-- RG with number of sessions restrictions -->
            <xsl:for-each select="$groups/nbSessions/entry">
                <xsl:call-template name="session-menu-items">
                    <xsl:with-param name="nbSessions" select="current()"/>
                    <xsl:with-param name="contents" select="$contents[nbSessions/@value = current()/@key]"/>
                </xsl:call-template>
            </xsl:for-each>
        </fo:bookmark-tree>
    </xsl:template>
    
    <xsl:template name="session-menu-items">
        <xsl:param name="nbSessions" select="foo"/>
        <xsl:param name="contents" />
        
        <xsl:if test="$contents">
            <xsl:variable name="bookmarkPrefix">
                <xsl:choose>
                    <xsl:when test="$nbSessions"><xsl:value-of select="$nbSessions/@key"/></xsl:when>
                    <xsl:otherwise>all</xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            
            <fo:bookmark internal-destination="{$bookmarkPrefix}">
                <fo:bookmark-title>
                    <xsl:choose>
                        <xsl:when test="$nbSessions"><xsl:value-of select="$nbSessions"/></xsl:when>
                        <xsl:otherwise><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_NB_SESSIONS_ALL" i18n:catalogue="plugin.odf-pilotage"/></xsl:otherwise>
                    </xsl:choose>
                </fo:bookmark-title>
                
                <xsl:call-template name="regime-menu-items">
                    <xsl:with-param name="contents" select="$contents[not(regime)]"/>
                    <xsl:with-param name="prefix" select="concat($bookmarkPrefix, '-')"/>
                </xsl:call-template>
                
                <xsl:for-each select="$groups/items[@contentTypeId = 'odf-enumeration.MccRegime']/item">
                    <xsl:sort select="@order" data-type="number"/>
                    <xsl:sort select="@code"/>
                    
                    <xsl:call-template name="regime-menu-items">
                        <xsl:with-param name="regime" select="current()"/>
                        <xsl:with-param name="contents" select="$contents[regime/@id = current()/@id]"/>
                        <xsl:with-param name="prefix" select="concat($bookmarkPrefix, '-')"/>
                    </xsl:call-template>
                </xsl:for-each>
            </fo:bookmark>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="regime-menu-items">
        <xsl:param name="regime" select="foo"/>
        <xsl:param name="prefix" />
        <xsl:param name="contents" />
        
        <xsl:if test="$contents">
            <xsl:variable name="bookmarkPrefix">
                <xsl:value-of select="$prefix"/>
                <xsl:choose>
                    <xsl:when test="$regime"><xsl:value-of select="$regime/@code"/></xsl:when>
                    <xsl:otherwise>all</xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            
            <fo:bookmark internal-destination="{$bookmarkPrefix}">
                <fo:bookmark-title>
                    <xsl:choose>
                        <xsl:when test="$regime"><xsl:value-of select="$regime"/></xsl:when>
                        <xsl:otherwise><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_REGIME_ALL" i18n:catalogue="plugin.odf-pilotage"/></xsl:otherwise>
                    </xsl:choose>
                </fo:bookmark-title>
                
                <xsl:call-template name="contents-menu-items">
                    <xsl:with-param name="contents" select="$contents"/>
                    <xsl:with-param name="prefix" select="concat($bookmarkPrefix, '-')"/>
                </xsl:call-template>
            </fo:bookmark>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="flow-content">
        <!-- RG without number of sessions restrictions -->
        <xsl:variable name="contentsWithoutNbSessions" select="contents/content[not(nbSessions)]"/>
        <xsl:if test="$contentsWithoutNbSessions">
            <fo:block id="all"/>
            
            <!-- RG without regime restrictions -->
            <xsl:call-template name="thematics-with-scope">
                <xsl:with-param name="contents" select="$contentsWithoutNbSessions[not(regime)]"/>
                <xsl:with-param name="isFirst" select="true()"/>
            </xsl:call-template>
            
            <!-- RG with regime restrictions -->
            <xsl:for-each select="$groups/items[@contentTypeId = 'odf-enumeration.MccRegime']/item">
                <xsl:sort select="@order" data-type="number"/>
                <xsl:sort select="@code"/>
                
                <xsl:call-template name="thematics-with-scope">
                    <xsl:with-param name="regime" select="current()"/>
                    <xsl:with-param name="contents" select="$contentsWithoutNbSessions[regime/@id = current()/@id]"/>
                </xsl:call-template>
            </xsl:for-each>
        </xsl:if>
        
        <!-- RG with number of sessions restrictions -->
        <xsl:variable name="contentsWithNbSessions" select="contents/content[nbSessions]"/>
        <xsl:if test="$contentsWithNbSessions">
            <xsl:for-each select="$groups/nbSessions/entry">
                <xsl:variable name="nbSessions" select="current()"/>
                <xsl:variable name="filteredContentsWithNbSessions" select="$contentsWithNbSessions[nbSessions/@value = $nbSessions/@key]"/>
                
                <fo:block id="{$nbSessions/@key}"/>
                
                <!-- RG without regime restrictions -->
                <xsl:call-template name="thematics-with-scope">
                    <xsl:with-param name="nbSessions" select="$nbSessions"/>
                    <xsl:with-param name="contents" select="$filteredContentsWithNbSessions[not(regime)]"/>
                </xsl:call-template>
                
                <!-- RG with regime restrictions -->
                <xsl:for-each select="$groups/items[@contentTypeId = 'odf-enumeration.MccRegime']/item">
                    <xsl:sort select="@order" data-type="number"/>
                    <xsl:sort select="@code"/>
                    
                    <xsl:call-template name="thematics-with-scope">
                        <xsl:with-param name="nbSessions" select="$nbSessions"/>
                        <xsl:with-param name="regime" select="current()"/>
                        <xsl:with-param name="contents" select="$filteredContentsWithNbSessions[regime/@id = current()/@id]"/>
                    </xsl:call-template>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="thematics-with-scope">
        <xsl:param name="nbSessions" select="foo"/>
        <xsl:param name="regime" select="foo"/>
        <xsl:param name="isFirst" select="false()"/>
        <xsl:param name="contents"/>
        
        <xsl:if test="$contents">
            <xsl:variable name="bookmarkPrefix">
                <xsl:choose>
                    <xsl:when test="$nbSessions"><xsl:value-of select="$nbSessions/@key"/></xsl:when>
                    <xsl:otherwise>all</xsl:otherwise>
                </xsl:choose>
                <xsl:text>-</xsl:text>
                <xsl:choose>
                    <xsl:when test="$regime"><xsl:value-of select="$regime/@code"/></xsl:when>
                    <xsl:otherwise>all</xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            
            <fo:block-container id="{$bookmarkPrefix}">
                <xsl:if test="not($isFirst)">
                    <xsl:attribute name="page-break-before">always</xsl:attribute>
                </xsl:if>
                <xsl:call-template name="thematics-scope">
                    <xsl:with-param name="nbSessions" select="$nbSessions"/>
                    <xsl:with-param name="regime" select="$regime"/>
                </xsl:call-template>
                <xsl:call-template name="contents">
                    <xsl:with-param name="contents" select="$contents"/>
                    <xsl:with-param name="prefix" select="concat($bookmarkPrefix, '-')"/>
                </xsl:call-template>
            </fo:block-container>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="thematics-scope">
        <xsl:param name="nbSessions" select="foo"/>
        <xsl:param name="regime" select="foo"/>
        
        <fo:block font-size="90%" border-color="{$mainColor}" border-style="solid" border-width="medium" padding="1mm" margin-top="3mm" background-color="lightgrey">
            <i18n:translate>
                <i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_APPLICABLE_THEMATICS" i18n:catalogue="plugin.odf-pilotage"/>
                <i18n:param name="degree"><xsl:value-of select="$degree"/></i18n:param>
            </i18n:translate>
            <xsl:if test="$nbSessions">
                <i18n:translate>
                    <i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_APPLICABLE_THEMATICS_NB_SESSIONS" i18n:catalogue="plugin.odf-pilotage"/>
                    <i18n:param name="nbSessions"><xsl:value-of select="$nbSessions"/></i18n:param>
                </i18n:translate>
            </xsl:if>
            <xsl:if test="$regime">
                <i18n:translate>
                    <i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_APPLICABLE_THEMATICS_REGIME" i18n:catalogue="plugin.odf-pilotage"/>
                    <i18n:param name="regime"><xsl:value-of select="$regime"/></i18n:param>
                </i18n:translate>
            </xsl:if>
        </fo:block>
    </xsl:template>
    
    <xsl:template name="title">
        <fo:block text-align="center" font-size="140%" font-weight="bold" color="{$mainColor}"><i18n:text key="PLUGINS_ODF_PILOTAGE_EXPORT_TITLE" catalogue="plugin.odf-pilotage"/></fo:block>
        <fo:block text-align="center" font-size="130%" font-weight="bold" color="{$mainColor}"><i18n:text key="PLUGINS_ODF_PILOTAGE_EXPORT_SUBTITLE" catalogue="plugin.odf-pilotage"/> - <xsl:value-of select="$degree"/></fo:block>
        <fo:block text-align="center" font-size="130%" font-weight="bold" color="{$mainColor}"><xsl:value-of select="filters/catalog"/></fo:block>
    </xsl:template>
</xsl:stylesheet>
