<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:mcc="org.ametys.plugins.odfpilotage.xslt.MCCXSLTHelper"
                              exclude-result-prefixes="i18n mcc">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/pdf.xsl"/>
    
    <xsl:param name="isDefinitive" select="'false'"/>
    
    <xsl:template name="xsl-region-before">
        <xsl:if test="$isDefinitive != 'true'">
            <xsl:call-template name="watermark"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="date-footer">
        <xsl:choose>
            <xsl:when test="$isDefinitive != 'true'">
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_DATE"/>
                    <i18n:param><i18n:date-time pattern="dd/MM/yyyy HH:mm" /></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:otherwise>
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_VALIDATED_PDF_CONTAINER_CFVU_PDF_DATE_FOOTER"/>
                    <i18n:param><i18n:date pattern="dd/MM/yyyy" src-pattern="yyyy-MM-dd" ><xsl:value-of select="mcc:getMCCCFVUValidationDate($mainContent/@id)" /></i18n:date></i18n:param>
                </i18n:translate>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>