/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.helper;

import com.opensymphony.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.cms.model.restrictions.RestrictedModelItem;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableDefaultContent;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.odf.course.Course;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.tree.ODFContentsTreeHelper;
import org.ametys.odf.workflow.AbstractCreateODFContentFunction;
import org.ametys.odf.workflow.CreateCoursePartFunction;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.runtime.model.ModelItem;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class CoursePartsTreeHelper
extends ODFContentsTreeHelper
implements Contextualizable {
    public static final String COURSE_EDIT_RIGHT_ID = "ODF_Rights_Course_Edit";
    protected Context _context;
    protected RightManager _rightManager;
    protected ContentWorkflowHelper _contentWorkflowHelper;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._contentWorkflowHelper = (ContentWorkflowHelper)manager.lookup(ContentWorkflowHelper.ROLE);
    }

    protected Map<String, Object> content2Json(Content content) {
        Map infos = super.content2Json(content);
        infos.put("volumesOfHours", this._coursePartToJson(content, infos));
        return infos;
    }

    private Map<String, Object> _coursePartToJson(Content content, Map<String, Object> infos) {
        List notEditableDataIndex = (List)infos.computeIfAbsent("notEditableDataIndex", l -> new ArrayList());
        infos.put("contentId", content.getId());
        HashMap<String, Object> volumesOfHours = new HashMap<String, Object>();
        if (content instanceof Course) {
            RestrictedModelItem restrictedCoursePart;
            Course course = (Course)content;
            ModelItem coursePartModelItem = content.getDefinition("courseParts");
            if (!this._contentWorkflowHelper.isAvailableAction((WorkflowAwareContent)course, 2) || coursePartModelItem instanceof RestrictedModelItem && !(restrictedCoursePart = (RestrictedModelItem)coursePartModelItem).canWrite((Object)course)) {
                infos.put("notEditableData", true);
            }
            List courseParts = course.getCourseParts();
            for (CoursePart coursePart : courseParts) {
                String natureId = coursePart.getNature();
                if (StringUtils.isNotEmpty((CharSequence)natureId)) {
                    ModifiableDefaultContent nature = (ModifiableDefaultContent)this._ametysResolver.resolveById(natureId);
                    boolean alreadyExists = volumesOfHours.containsKey(natureId);
                    if (alreadyExists || !this._contentWorkflowHelper.isAvailableAction((WorkflowAwareContent)coursePart, 2)) {
                        notEditableDataIndex.add(natureId);
                    }
                    Map volumeForNature = (Map)volumesOfHours.computeIfAbsent(natureId, __ -> new HashMap());
                    if (!alreadyExists) {
                        volumeForNature.put("name", nature.getTitle());
                    }
                    List values = (List)volumeForNature.computeIfAbsent("values", __ -> new ArrayList());
                    values.add(coursePart.getNumberOfHours());
                    continue;
                }
                if (!this.getLogger().isWarnEnabled()) continue;
                this.getLogger().warn("The course part '{}' ({}) does not have a nature, it is mandatory.", (Object)coursePart.getTitle(), (Object)coursePart.getId());
            }
        } else {
            infos.put("notEditableData", true);
        }
        return volumesOfHours;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callable
    public Map<String, Object> saveEdition(String contentId, Map<String, Object> changes) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Map<String, String>> errors = new HashMap<String, Map<String, String>>();
        Course course = (Course)this._ametysResolver.resolveById(contentId);
        if (!this._rightManager.currentUserHasRight(COURSE_EDIT_RIGHT_ID, (Object)course).equals((Object)RightManager.RightResult.RIGHT_ALLOW)) {
            result.put("success", false);
            errors.put("course", Map.of("title", course.getTitle(), "errorMsg", "unauthorized"));
            result.put("errors", errors);
            return result;
        }
        for (String key : changes.keySet()) {
            CoursePart coursePart;
            ModifiableDefaultContent nature = (ModifiableDefaultContent)this._ametysResolver.resolveById(key);
            Optional<CoursePart> optionalCoursePart = course.getCourseParts().stream().filter(coursePartToFilter -> key.equals(coursePartToFilter.getNature())).findFirst();
            if (optionalCoursePart.isPresent() && changes.get(key) != null) {
                coursePart = optionalCoursePart.get();
                if (this._contentWorkflowHelper.isAvailableAction((WorkflowAwareContent)coursePart, 2)) {
                    try {
                        HashMap<String, Object> inputs = new HashMap<String, Object>();
                        inputs.put("nbHours", changes.get(key));
                        this._contentWorkflowHelper.editContent((WorkflowAwareContent)coursePart, inputs, 2);
                        continue;
                    }
                    catch (WorkflowException | AmetysRepositoryException e) {
                        errors.put(key, Map.of("title", (String)nature.getValue("shortLabel"), "errorMsg", e.getMessage()));
                        continue;
                    }
                    finally {
                        if (course.isLocked()) {
                            course.unlock();
                        }
                        continue;
                    }
                }
                errors.put(key, Map.of("title", (String)nature.getValue("shortLabel"), "errorMsg", "unauthorized"));
                continue;
            }
            if (this._contentWorkflowHelper.isAvailableAction((WorkflowAwareContent)course, 2)) {
                if (optionalCoursePart.isPresent() && changes.get(key) == null) {
                    coursePart = optionalCoursePart.get();
                    try {
                        List newCourseParts = course.getCourseParts();
                        newCourseParts.remove(coursePart);
                        HashMap<String, List> inputsForEditCourse = new HashMap<String, List>();
                        inputsForEditCourse.put("courseParts", newCourseParts);
                        this._contentWorkflowHelper.editContent((WorkflowAwareContent)course, inputsForEditCourse, 2);
                    }
                    catch (WorkflowException | AmetysRepositoryException e) {
                        errors.put(key, Map.of("title", (String)nature.getValue("shortLabel"), "errorMsg", e.getMessage()));
                    }
                    continue;
                }
                try {
                    HashMap<String, String> inputsForCreation = new HashMap<String, String>();
                    inputsForCreation.put(AbstractCreateODFContentFunction.CONTENT_CATALOG_KEY, course.getCatalog());
                    inputsForCreation.put(CreateCoursePartFunction.COURSE_HOLDER_KEY, course.getId());
                    Map resultForCreation = this._contentWorkflowHelper.createContent("course-part", 1, nature.getName(), nature.getTitle(), new String[]{"org.ametys.plugins.odf.Content.coursePart"}, new String[0], course.getLanguage(), inputsForCreation);
                    CoursePart coursePart2 = (CoursePart)resultForCreation.get("org.ametys.cms.repository.Content");
                    HashMap<String, Object> inputsForEditCoursePart = new HashMap<String, Object>();
                    inputsForEditCoursePart.put("nbHours", changes.get(key));
                    inputsForEditCoursePart.put("nature", nature.getId());
                    this._contentWorkflowHelper.editContent((WorkflowAwareContent)coursePart2, inputsForEditCoursePart, 2);
                    HashMap<String, List> inputsForEditCourse = new HashMap<String, List>();
                    List newCourseParts = course.getCourseParts();
                    newCourseParts.add(coursePart2);
                    inputsForEditCourse.put("courseParts", newCourseParts);
                    this._contentWorkflowHelper.editContent((WorkflowAwareContent)course, inputsForEditCourse, 2);
                }
                catch (WorkflowException | AmetysRepositoryException e) {
                    errors.put(key, Map.of("title", (String)nature.getValue("shortLabel"), "errorMsg", e.getMessage()));
                }
                continue;
            }
            errors.put(key, Map.of("title", (String)nature.getValue("shortLabel"), "errorMsg", "unauthorized"));
        }
        if (errors.isEmpty()) {
            result.put("success", true);
        } else {
            result.put("errors", errors);
            if (errors.size() != changes.size()) {
                result.put("success", true);
            }
        }
        return result;
    }
}

