/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.rule.container;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.repository.Content;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.rule.AbstractThematicsGenerator;
import org.ametys.plugins.odfpilotage.rule.RulesManager;
import org.ametys.plugins.repository.data.ametysobject.DataAwareAmetysObject;
import org.ametys.plugins.repository.model.RepositoryDataContext;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.type.DataContext;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ContainerRulesGenerator
extends AbstractThematicsGenerator {
    protected RulesManager _rulesManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._rulesManager = (RulesManager)((Object)smanager.lookup(RulesManager.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        String containerId;
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        this.contentHandler.startDocument();
        if (RulesManager.isRulesEnabled() && StringUtils.isNotBlank((CharSequence)(containerId = request.getParameter("programItem")))) {
            Container container = (Container)this._resolver.resolveById(containerId);
            if (this._rulesManager.hasHandleRulesRight(container)) {
                AttributesImpl attrs = new AttributesImpl();
                attrs.addCDATAAttribute("canEditRule", String.valueOf(this._rulesManager.isRulesModificationAvailable(container)));
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"thematics", (Attributes)attrs);
                this._saxContainer(request, container);
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"general");
                for (Content thematic : this._thematicsHelper.getCompatibleThematics(container)) {
                    this._saxContent(thematic);
                }
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"general");
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"container-rules");
                this._saxContainerRules(container);
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"container-rules");
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"specific");
                this._saxSpecificRules(container);
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"specific");
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"thematics");
        }
        this.contentHandler.endDocument();
    }

    protected void _saxContainer(Request request, Container container) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", container.getId());
        String thematicId = request.getParameter("thematicId");
        if (StringUtils.isNotBlank((CharSequence)thematicId)) {
            attrs.addCDATAAttribute("thematicId", thematicId);
            String ruleId = request.getParameter("ruleId");
            if (StringUtils.isNotBlank((CharSequence)ruleId)) {
                attrs.addCDATAAttribute("ruleId", ruleId);
            }
        }
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"container", (Attributes)attrs);
        View view = View.of((Collection)container.getModel(), (String[])new String[]{"title", "catalog", "mccNbSessions", "mccRegime"});
        RepositoryDataContext context = RepositoryDataContext.newInstance().withObject((DataAwareAmetysObject)container);
        container.dataToSAX(this.contentHandler, (ViewItemAccessor)view, (DataContext)context);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"container");
    }

    private void _saxContainerRules(Container content) throws SAXException {
        View resultItems = ((ContentType)this._contentTypeExtensionPoint.getExtension("org.ametys.plugins.odf.Content.container")).getView("thematics");
        RepositoryDataContext context = RepositoryDataContext.newInstance().withObject((DataAwareAmetysObject)content);
        content.dataToSAX(this.contentHandler, (ViewItemAccessor)resultItems, (DataContext)context);
    }

    private void _saxSpecificRules(Container content) throws SAXException {
        View resultItems = ((ContentType)this._contentTypeExtensionPoint.getExtension("org.ametys.plugins.odf.Content.container")).getView("specific-rules");
        if (resultItems != null) {
            RepositoryDataContext context = RepositoryDataContext.newInstance().withObject((DataAwareAmetysObject)content);
            content.dataToSAX(this.contentHandler, (ViewItemAccessor)resultItems, (DataContext)context);
        }
    }
}

