/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.schedulable;

import com.opensymphony.workflow.WorkflowException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.data.Binary;
import org.ametys.cms.data.holder.group.ModifiableIndexableRepeater;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.schedule.AbstractSendingMailSchedulable;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.util.JSONUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.helper.MCCWorkflowHelper;
import org.ametys.plugins.odfpilotage.rule.RulesManager;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelAwareRepeaterEntry;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.plugins.workflow.component.CheckRightsCondition;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.SchedulerException;

public class MCCValidatedPDFSchedulable
extends AbstractSendingMailSchedulable {
    public static final String ID = MCCValidatedPDFSchedulable.class.getName();
    private static String _CONTAINER_IDS_SUCCESS_KEY = "containerIdsInSuccess";
    private static String _CONTAINER_IDS_ERROR_KEY = "containerIdsInError";
    protected SourceResolver _sourceResolver;
    protected ContentWorkflowHelper _contentWorkflowHelper;
    protected AmetysObjectResolver _resolver;
    protected MCCWorkflowHelper _mccWorkflowHelper;
    protected ContentHelper _contentHelper;
    protected JSONUtils _jsonUtils;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._contentWorkflowHelper = (ContentWorkflowHelper)manager.lookup(ContentWorkflowHelper.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._mccWorkflowHelper = (MCCWorkflowHelper)((Object)manager.lookup(MCCWorkflowHelper.ROLE));
        this._contentHelper = (ContentHelper)manager.lookup(ContentHelper.ROLE);
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _doExecute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        List containerIds = (List)jobDataMap.get((Object)"parameterValues#containerIds");
        LocalDate date = (LocalDate)jobDataMap.get((Object)"parameterValues#date");
        ArrayList<String> containerIdsInSuccess = new ArrayList<String>();
        ArrayList<String> containerIdsInError = new ArrayList<String>();
        for (String containerId : containerIds) {
            Source pdfSource = null;
            try {
                Container container = (Container)this._resolver.resolveById(containerId);
                String encodeURI = this._getPDFURI(container, date);
                pdfSource = this._sourceResolver.resolveURI(encodeURI);
                Binary binary = this._getPDFAsBinary(pdfSource, container, date);
                this._registerPDF(container, binary, date);
                containerIdsInSuccess.add(containerId);
            }
            catch (Exception e) {
                try {
                    containerIdsInError.add(containerId);
                    this.getLogger().error("An error occurred generating the MCC validated PDF for container with id '{}'", (Object)containerId, (Object)e);
                }
                catch (Throwable throwable) {
                    this._sourceResolver.release(pdfSource);
                    throw throwable;
                }
                this._sourceResolver.release(pdfSource);
                continue;
            }
            this._sourceResolver.release(pdfSource);
        }
        context.put((Object)_CONTAINER_IDS_SUCCESS_KEY, containerIdsInSuccess);
        context.put((Object)_CONTAINER_IDS_ERROR_KEY, containerIdsInError);
        if (!containerIdsInError.isEmpty()) {
            List<Container> containersInError = containerIdsInError.stream().map(id -> this._resolver.resolveById(id)).filter(Container.class::isInstance).map(Container.class::cast).toList();
            for (Container container : containersInError) {
                this._mccWorkflowHelper.invalidateMCCForCVFU(container);
            }
            throw new SchedulerException("Some containers have not been MCC validated for CFVU because an error occurred during the PDF generation. For more information, see logs above.");
        }
    }

    protected String _getPDFURI(Container container, LocalDate date) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("programItem", container.getId());
        parameters.put("reportId", "org.ametys.plugins.odfpilotage.report.MCCReport");
        parameters.put("isDefinitive", "true");
        return RulesManager.isRulesEnabled() ? URIUtils.encodeURI((String)"cocoon://_plugins/odf-pilotage/final/container-rules.pdf", parameters) : URIUtils.encodeURI((String)"cocoon://_plugins/odf-pilotage/pilotage/report.pdf", parameters);
    }

    protected Binary _getPDFAsBinary(Source pdfSource, Container container, LocalDate date) throws IOException {
        Binary binary = new Binary();
        try (InputStream is = pdfSource.getInputStream();){
            binary.setEncoding("UTF-8");
            binary.setMimeType("application/pdf");
            binary.setLastModificationDate(ZonedDateTime.now());
            binary.setFilename(this._getPDFFileName(container, date));
            binary.setInputStream(is);
        }
        return binary;
    }

    private String _getPDFFileName(Container container, LocalDate date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String dateAsString = date.format(formatter);
        return "MCC " + container.getTitle() + " " + container.getCode() + " " + dateAsString + ".pdf";
    }

    protected void _registerPDF(Container container, Binary binary, LocalDate date) throws WorkflowException {
        ModifiableIndexableRepeater repeater = container.getRepeater("mcc-validated-pdf", true);
        ModifiableModelAwareRepeaterEntry entry = repeater.addEntry();
        entry.setValue("pdf", (Object)binary);
        entry.setValue("date", (Object)date);
        HashMap<String, Serializable> paramsEdit = new HashMap<String, Serializable>();
        paramsEdit.put(CheckRightsCondition.FORCE, Boolean.valueOf(true));
        paramsEdit.put(AbstractWorkflowComponent.CONTEXT_PARAMETERS_KEY, new HashMap());
        this._contentWorkflowHelper.doAction((WorkflowAwareContent)container, MCCWorkflowHelper.MCC_WORKFLOW_ACTION_ID.intValue(), paramsEdit);
    }

    protected boolean _isMailBodyInHTML(JobExecutionContext context) throws Exception {
        return true;
    }

    protected I18nizableText _getSuccessMailSubject(JobExecutionContext context) throws Exception {
        return new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_VALIDATED_PDF_CONTAINER_CFVU_MAIL_SUBJECT");
    }

    protected String _getSuccessMailBody(JobExecutionContext context) throws Exception {
        StandardMailBodyHelper.MailBodyBuilder bodyBuilder = StandardMailBodyHelper.newHTMLBody().withTitle(this._getSuccessMailSubject(context));
        String contextualParametersAsString = context.getJobDetail().getJobDataMap().getString("parameterValues#contextualParameters");
        Map contextualParameters = this._jsonUtils.convertJsonToMap(contextualParametersAsString);
        List containerIdsInSuccess = (List)context.get((Object)_CONTAINER_IDS_SUCCESS_KEY);
        if (!containerIdsInSuccess.isEmpty()) {
            bodyBuilder.addMessage(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_VALIDATED_PDF_CONTAINER_CFVU_MAIL_MSG"));
            bodyBuilder.addMessage(this._contentsToHtml(containerIdsInSuccess, contextualParameters));
        }
        return bodyBuilder.build();
    }

    protected I18nizableText _getErrorMailSubject(JobExecutionContext context) throws Exception {
        return new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_VALIDATED_PDF_CONTAINER_CFVU_MAIL_SUBJECT");
    }

    protected String _getErrorMailBody(JobExecutionContext context, Throwable throwable) throws Exception {
        List containerIdsInError;
        StandardMailBodyHelper.MailBodyBuilder bodyBuilder = StandardMailBodyHelper.newHTMLBody().withTitle(this._getSuccessMailSubject(context));
        String contextualParametersAsString = context.getJobDetail().getJobDataMap().getString("parameterValues#contextualParameters");
        Map contextualParameters = this._jsonUtils.convertJsonToMap(contextualParametersAsString);
        List containerIdsInSuccess = (List)context.get((Object)_CONTAINER_IDS_SUCCESS_KEY);
        if (!containerIdsInSuccess.isEmpty()) {
            bodyBuilder.addMessage(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_VALIDATED_PDF_CONTAINER_CFVU_MAIL_MSG"));
            bodyBuilder.addMessage(this._contentsToHtml(containerIdsInSuccess, contextualParameters));
        }
        if (!(containerIdsInError = (List)context.get((Object)_CONTAINER_IDS_ERROR_KEY)).isEmpty()) {
            bodyBuilder.addMessage(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_VALIDATED_PDF_CONTAINER_CFVU_MAIL_ERROR_MSG"));
            bodyBuilder.addMessage(this._contentsToHtml(containerIdsInError, contextualParameters));
            bodyBuilder.addMessage(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_VALIDATED_PDF_CONTAINER_CFVU_MAIL_ERROR_LOG_MSG"));
        }
        return bodyBuilder.build();
    }

    private String _contentsToHtml(List<String> contentIds, Map<String, Object> contextualParameters) {
        StringBuilder htmlMessage = new StringBuilder("<ul>");
        for (String id : contentIds) {
            Container container = (Container)this._resolver.resolveById(id);
            String href = this._contentHelper.getContentBOUrl((Content)container, contextualParameters);
            htmlMessage.append("<li>");
            htmlMessage.append("<a href=\"").append(href).append("\">").append(container.getTitle()).append("</a>");
            htmlMessage.append("</li>");
        }
        htmlMessage.append("</ul>");
        return htmlMessage.toString();
    }
}

