/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
 /**
 * This class controls the ribbon button to manage rules of year container
 * @private
 */
Ext.define('Ametys.plugins.odfpilotage.controllers.YearContainerController', {
    extend: 'Ametys.ribbon.element.ui.ButtonController',

    constructor: function (config)
    {
        this.callParent(arguments);
        
        Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onModified, this);
    },
    
    /**
     * Listener on modified message.
     * Update the state of the controller accordingly.
     * @param {Ametys.message.Message} message the message of type modified.
     * @private
     */
    _onModified: function(message)
    {
        if (this.updateTargetsInCurrentSelectionTargets(message))
        {
            this.refresh();
        }
    },

    updateState: function()
    {
        this.callParent(arguments);
        if (!this.isDisabled())
        {
            this.disable();
            
            var targets = this.getMatchingTargets();
            if (targets.length > 0)
            {
                var contentTarget = targets[0]; // No multiselection
                var containerId = contentTarget.getParameters().id;
                Ametys.data.ServerComm.callMethod({
                    role: "org.ametys.plugins.odfpilotage.helper.PilotageHelper",
                    methodName: "isContainerOfTypeYear",
                    parameters: [containerId],
                    callback: {
                        handler: this._isYearContainerCB,
                        scope: this
                    },
                    waitMessage: false
                });
            }
        }
    },
    
    /**
     * @private
     * Callback after checking if it is a year container
     * @param {Boolean} isYearContainer true it is a year container
     */
    _isYearContainerCB: function(isYearContainer)
    {
        if (isYearContainer)
        {
            this.enable();
        }
        else
        {
            this.disable();
            this.setAdditionalDescription("{{i18n plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_CONTROLLER_ERROR_NO_YEAR_CONTAINER_MSG}}");
        }
    }
});