/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
/**
 * Helper for controllers that should be aware of attributes restrictions
 */
Ext.define('Ametys.plugins.odf.pilotage.helper.ODFPilotageControllerHelper', {
	singleton: true,
	
    /**
     * Refresh the controller from the content informations state of given target
     * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function
     * @param {Ametys.message.MessageTarget} target The content target
     * @param {Function} callback The function to call at the end
     * @protected
     */
    getRestrictionStatus: function (controller, target, modelPath, callback)
    {
        this.getRestrictionStatusFromId(controller, target.getParameters().id, modelPath, callback);
    },
    
    /**
     * Refresh the controller from the content informations state of target content id
     * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function
     * @param {String} contentId The id of the content
     * @param {Function} callback The function to call at the end
     * @protected
     */
    getRestrictionStatusFromId: function (controller, contentId, modelPath, callback)
    {
        controller.disable();
        
        callback = callback || this._getRestrictionStatusCb;
        
        controller.serverCall ('getRestrictionStatus', [contentId, modelPath], Ext.bind(callback, this, [controller], 1), { cancelCode: controller.self.getName() + "$" + controller.getId(), refreshing: true });
    },
    
    /**
     * @private
     */
    _getRestrictionStatusCb: function(params, controller)
    {
        var contentWithInvalidRestrictionStatus = params['invalidrestrictionstatus-contents'] || [];
        if (contentWithInvalidRestrictionStatus.length == 0)
        {
            controller.enable();
            controller.setAdditionalDescription("");
        }
        else
        {
            // FIXME
            // Be careful ! This helper does not currently support multi selection correctly,
            // as button will be disabled as soon as a content has an invalid pilotage status.
            // For now, this helper is use on controllers with no multiselection enabled
            var description = this._handlingMultiple("", contentWithInvalidRestrictionStatus, "{{i18n plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_CONTROLLER_STATUS_RESTRICTIONS_DISABLED_MSG}}");
            
            controller.setAdditionalDescription(description);
            controller.disable();
        }
    },
    
    /**
     * @private
     */
    _handlingMultiple: function(description, contents)
    {
        if (contents.length > 0)
        {
            for (var i=0; i < contents.length; i++)
            {
                if (i != 0) 
                {
                    description += "<br/>";
                }
                
                description += Ext.String.format("{{i18n plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_CONTROLLER_STATUS_RESTRICTIONS_DISABLED_MSG}}", contents[i].title);
            }
        }
        
        return description;
    }
});
    