/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button for adding a task.
 * One of the parameters of the schedulable must be named 'extensionId' and fill widget parameters for another parameter named 'outputFormat'.
 * The output format depends of the report type.
 * @private
 */
Ext.define('Ametys.plugins.odfpilotage.controllers.ODFSelectionAndReportAwareAddTaskButtonController', {
    extend: 'Ametys.plugins.coreui.schedule.SelectionAwareAddTaskButtonController',
    
    _configureSchedulerParameters: function(config)
    {
        let schedulable = config.schedulable;
        let extensionId = (config["schedulable-parameters"] || {}).extensionId;
        
        this.serverCall("getParameters", [config.schedulable], function(parameters) {
            var outputFormatParam = parameters[schedulable + "$outputFormat"];
            if (extensionId && outputFormatParam != null)
            {
                outputFormatParam["widget-params"] = Ext.apply(outputFormatParam["widget-params"] || {}, { "extensionId": extensionId }); 
            }
            
            this.allParameters = parameters;
        }, {scope: this, errorMessage: true});
    }
});
