<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:mcc="org.ametys.plugins.odfpilotage.xslt.MCCXSLTHelper"
                              xmlns:fo="http://www.w3.org/1999/XSL/Format"
                              exclude-result-prefixes="i18n mcc">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/pdf.xsl"/>
    
    <xsl:param name="isDefinitive" select="'false'"/>
    
    <xsl:variable name="mccWorkflowRoot" select="/"/>
    
    <xsl:template name="xsl-region-before">
        <xsl:param name="format" select="'a4'"/>
        <xsl:param name="orientation" select="$mainOrientation"/>
        
        <xsl:if test="$isDefinitive != 'true'">
            <xsl:call-template name="watermark">
                <xsl:with-param name="format" select="$format"/>
                <xsl:with-param name="orientation" select="$orientation"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="watermark-label">
        <xsl:choose>
            <xsl:when test="not($mccWorkflowRoot/mcc-workflow/workflow-step) or $mccWorkflowRoot/mcc-workflow/workflow-step[text() = 'MCC_ORGUNIT_CONTROLLED' or text() = 'MCC_ORGUNIT_VALIDATED' or text() = 'MCC_CFVU_CONTROLLED' or text() = 'MCC_CFVU_VALIDATED']">
                <!-- No watermark for advanced step -->
            </xsl:when>
            <xsl:otherwise>
                <i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_WATERMARK_WORK" i18n:catalogue="plugin.odf-pilotage"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="date-footer">
        <xsl:choose>
            <xsl:when test="$isDefinitive != 'true'">
                <xsl:choose>
                    <xsl:when test="$mccWorkflowRoot/mcc-workflow/workflow-step[text() = 'MCC_ORGUNIT_CONTROLLED']">
                        <fo:block><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_ORGUNIT_CONTROL_STEP_LABEL"/></fo:block>
                    </xsl:when>
                    <xsl:when test="$mccWorkflowRoot/mcc-workflow/workflow-step[text() = 'MCC_ORGUNIT_VALIDATED']">
                        <fo:block><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_ORGUNIT_VALIDATION_STEP_LABEL"/></fo:block>
                    </xsl:when>
                    <xsl:when test="$mccWorkflowRoot/mcc-workflow/workflow-step[text() = 'MCC_CFVU_CONTROLLED']">
                        <fo:block><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_CFVU_CONTROL_STEP_LABEL"/></fo:block>
                    </xsl:when>
                    <xsl:when test="$mccWorkflowRoot/mcc-workflow/workflow-step[text() = 'MCC_CFVU_VALIDATED']">
                        <fo:block><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_CFVU_VALIDATE_STEP_LABEL"/></fo:block>
                    </xsl:when>
                    <xsl:otherwise>
                    </xsl:otherwise>
                </xsl:choose>
                <fo:block><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_NO_DEFINITIVE_DATE"/></fo:block>
                <fo:block><i18n:date-time pattern="dd/MM/yyyy HH:mm" /></fo:block>
            </xsl:when>
            <xsl:otherwise>
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_VALIDATED_PDF_CONTAINER_CFVU_PDF_DATE_FOOTER"/>
                    <i18n:param><i18n:date pattern="dd/MM/yyyy" src-pattern="yyyy-MM-dd" ><xsl:value-of select="mcc:getMCCCFVUValidationDate($mainContent/@id)" /></i18n:date></i18n:param>
                </i18n:translate>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>