/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.observation;

import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.cms.ObservationConstants;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.odf.ProgramItem;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;

/**
 * Observer to clear cache of steps.
 */
public class ClearCachesObserver implements Observer, Serviceable
{
    /** The pilotage helper */
    protected PilotageHelper _pilotageHelper;
    
    public void service(ServiceManager manager) throws ServiceException
    {
        _pilotageHelper = (PilotageHelper) manager.lookup(PilotageHelper.ROLE);
    }
    
    public boolean supports(Event event)
    {
        return event.getId().equals(ObservationConstants.EVENT_CONTENT_MODIFIED) && event.getArguments().get(ObservationConstants.ARGS_CONTENT) instanceof ProgramItem;
    }

    public int getPriority()
    {
        return MAX_PRIORITY;
    }
    
    public void observe(Event event, Map<String, Object> transientVars) throws Exception
    {
        _pilotageHelper.invalidateAllCaches();
    }
}
