/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.schedulable;

import java.util.Map;

import org.quartz.JobDataMap;

import org.ametys.core.schedule.Schedulable;
import org.ametys.plugins.core.schedule.Scheduler;
import org.ametys.plugins.odfpilotage.report.impl.MCCDiffReport;

/**
 * {@link Schedulable} for pilotage  diff report by orgunit.
 */
public class OrgUnitDiffReportSchedulable extends OrgUnitReportSchedulable
{
    /** The key for the old catalog */
    public static final String JOBDATAMAP_CATALOG_OLD_KEY = "catalogOld";
    
    @Override
    public boolean forGenericReports()
    {
        return false;
    }
    
    @Override
    protected Map<String, String> getReportParameters(JobDataMap jobDataMap)
    {
        Map<String, String> reportParameters = super.getReportParameters(jobDataMap);
        reportParameters.put(MCCDiffReport.PARAMETER_CATALOG_OLD, jobDataMap.getString(Scheduler.PARAM_VALUES_PREFIX + JOBDATAMAP_CATALOG_OLD_KEY));
        return reportParameters;
    }
}
