/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.helper;

import com.opensymphony.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.odf.course.Course;
import org.ametys.odf.program.Program;
import org.ametys.odf.tree.ODFContentsTreeHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelAwareRepeater;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.commons.lang3.StringUtils;

public class MicroSkillsTreeHelper
extends ODFContentsTreeHelper
implements Contextualizable {
    public static final String COURSE_EDIT_RIGHT_ID = "ODF_Rights_Course_Edit";
    public static final String PROGRAM_EDIT_RIGHT_ID = "ODF_Rights_Program_Edit";
    public static final String INEXISTING_SKILL_WARN = "INEXISTING_SKILL";
    public static final String NOT_IN_PROGRAM_WARN = "NOT_IN_PROGRAM";
    public static final int EDIT_ACTION_ID = 2;
    protected Context _context;
    protected AmetysObjectResolver _resolver;
    protected RightManager _rightManager;
    protected ContentWorkflowHelper _contentWorkflowHelper;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._contentWorkflowHelper = (ContentWorkflowHelper)manager.lookup(ContentWorkflowHelper.ROLE);
    }

    @Callable(rights={"ODF_Rights_Pilotage_MICROSKILLS"})
    public Map<String, Object> getSkillsColumns(String programId) {
        LinkedHashMap<String, Object> skills = new LinkedHashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)programId)) {
            ContentValue[] transversalSkills;
            Program program = (Program)this._ametysResolver.resolveById(programId);
            ArrayList<ContentValue> macroSkills = new ArrayList<ContentValue>();
            ContentValue[] contentMacroSkills = (ContentValue[])program.getValue("skills", true);
            if (contentMacroSkills != null && contentMacroSkills.length > 0) {
                macroSkills.addAll(Arrays.asList(contentMacroSkills));
            }
            if ((transversalSkills = (ContentValue[])program.getValue("transversalSkills", true)) != null && transversalSkills.length > 0) {
                macroSkills.addAll(Arrays.asList(transversalSkills));
            }
            Locale locale = Locale.of((String)StringUtils.defaultIfBlank((CharSequence)((String)ContextHelper.getRequest((Context)this._context).getAttribute("locale")), (CharSequence)"fr"));
            for (ContentValue macroSkillContentValue : macroSkills) {
                Optional optionalContent = macroSkillContentValue.getContentIfExists();
                if (!optionalContent.isPresent()) continue;
                Map<String, Object> macroSkillInfos = this._macroSkillToColumnJson((Content)optionalContent.get(), locale);
                skills.put(macroSkillContentValue.getContentId(), macroSkillInfos);
            }
        }
        return skills;
    }

    private Map<String, Object> _skillToColumnJson(Content skill, Locale locale) {
        HashMap<String, Object> skillInfos = new HashMap<String, Object>();
        skillInfos.put("id", skill.getId());
        skillInfos.put("code", skill.getValue("code"));
        skillInfos.put("skillCode", skill.getValue("skillCode"));
        skillInfos.put("title", skill.getTitle(locale));
        return skillInfos;
    }

    private Map<String, Object> _macroSkillToColumnJson(Content macroSkill, Locale locale) {
        Map<String, Object> skillInfos = this._skillToColumnJson(macroSkill, locale);
        ContentValue[] microSkills = (ContentValue[])macroSkill.getValue("microSkills");
        if (microSkills != null) {
            LinkedHashMap<String, Map<String, Object>> microSkillsInfos = new LinkedHashMap<String, Map<String, Object>>();
            for (ContentValue microSkill : microSkills) {
                Optional optionalContent = microSkill.getContentIfExists();
                if (!optionalContent.isPresent()) continue;
                Content microSkillContent = (Content)optionalContent.get();
                String microSkillId = microSkillContent.getId();
                Map<String, Object> microSkillInfo = this._skillToColumnJson(microSkillContent, locale);
                microSkillsInfos.put(microSkillId, microSkillInfo);
            }
            skillInfos.put("microSkills", microSkillsInfos);
        }
        return skillInfos;
    }

    protected Map<String, Object> content2Json(Content content, List<String> path) {
        Program program;
        Map infos = super.content2Json(content, path);
        String programId = path.get(0);
        infos.computeIfAbsent("notEditableDataIndex", l -> new ArrayList());
        if (content instanceof Course) {
            Map<String, Object> acquiredMicroSkills;
            ContentValue[] acquiredMicroSkillsValues;
            Course course = (Course)content;
            if (!this._contentWorkflowHelper.isAvailableAction((WorkflowAwareContent)course, 2)) {
                infos.put("notEditableData", true);
            }
            if ((acquiredMicroSkillsValues = course.getAcquiredSkills(programId)) != null && (acquiredMicroSkills = Arrays.stream(acquiredMicroSkillsValues).map(value -> value.getContentId()).collect(Collectors.toMap(value -> value, value -> true))) != null) {
                infos.putAll(acquiredMicroSkills);
            }
        } else if (content instanceof Program && (program = (Program)content).hasValue("blockingMicroSkills")) {
            if (!this._contentWorkflowHelper.isAvailableAction((WorkflowAwareContent)program, 2)) {
                infos.put("notEditableData", true);
            }
            if (program.hasValue("blockingMicroSkills")) {
                Map<String, Boolean> blockingMicroSkills = Arrays.stream((ContentValue[])program.getValue("blockingMicroSkills")).map(value -> value.getContentId()).collect(Collectors.toMap(value -> value, value -> true));
                infos.putAll(blockingMicroSkills);
            }
        } else if (!path.get(0).equals(content.getId())) {
            infos.put("notEditableData", true);
        }
        return infos;
    }

    @Callable(rights={""})
    public Map<String, Object> saveEdition(String contentId, Map<String, Object> changes, String programRootId) {
        Content content = (Content)this._ametysResolver.resolveById(contentId);
        if (content instanceof Course) {
            Course course = (Course)content;
            return this._saveEditionForCourse(programRootId, course, changes);
        }
        if (content instanceof Program) {
            Program program = (Program)content;
            return this._saveEditionForProgram(program, changes);
        }
        return Map.of();
    }

    private Map<String, Object> _saveEditionForCourse(String programRootId, Course course, Map<String, Object> changes) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Program program = (Program)this._resolver.resolveById(programRootId);
        Set<String> programMicroSkillsIds = this._getMicroSkills(program);
        if (!this._rightManager.currentUserHasRight(COURSE_EDIT_RIGHT_ID, (Object)course).equals((Object)RightManager.RightResult.RIGHT_ALLOW)) {
            result.put("success", false);
            result.put("errorMsg", "unauthorized");
            return result;
        }
        ModifiableModelAwareRepeater acquiredMicroSkillsRepeater = (ModifiableModelAwareRepeater)course.getValue("acquiredMicroSkills");
        Map<String, Map<String, Object>> skillsByProgramId = this._getCourseSkillsByProgramAsMap(acquiredMicroSkillsRepeater);
        Map entryForProgram = skillsByProgramId.computeIfAbsent(programRootId, entry -> new HashMap<String, String>(Map.of("program", programRootId)));
        List currentMicroSkillsIds = (List)entryForProgram.computeIfAbsent("microSkills", microSkills -> new ArrayList());
        for (String microSkillId : changes.keySet()) {
            if (!this._checkValidSkills(microSkillId, programMicroSkillsIds, result)) continue;
            boolean isMicroSkillSelected = (Boolean)changes.get(microSkillId);
            if (currentMicroSkillsIds.contains(microSkillId) && !isMicroSkillSelected) {
                currentMicroSkillsIds.remove(microSkillId);
                continue;
            }
            if (currentMicroSkillsIds.contains(microSkillId) || !isMicroSkillSelected) continue;
            currentMicroSkillsIds.add(microSkillId);
        }
        if (currentMicroSkillsIds.isEmpty()) {
            skillsByProgramId.remove(programRootId);
        }
        try {
            HashMap<String, ArrayList<Map<String, Object>>> inputsForEditCourse = new HashMap<String, ArrayList<Map<String, Object>>>();
            inputsForEditCourse.put("acquiredMicroSkills", new ArrayList<Map<String, Object>>(skillsByProgramId.values()));
            this._contentWorkflowHelper.editContent((WorkflowAwareContent)course, inputsForEditCourse, 2);
        }
        catch (WorkflowException | AmetysRepositoryException e) {
            result.put("success", false);
            result.put("errorMsg", e.getMessage());
        }
        if (!result.containsKey("errorMsg")) {
            result.put("success", true);
        }
        return result;
    }

    private Content _getIfStillExists(String microSkill) {
        try {
            return (Content)this._resolver.resolveById(microSkill);
        }
        catch (UnknownAmetysObjectException e) {
            return null;
        }
    }

    private Map<String, Map<String, Object>> _getCourseSkillsByProgramAsMap(ModifiableModelAwareRepeater courseAcquiredMicroSkills) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        if (courseAcquiredMicroSkills != null) {
            List skillByProgramEntries = courseAcquiredMicroSkills.getEntries();
            for (ModelAwareRepeaterEntry skillByProgramEntry : skillByProgramEntries) {
                ContentValue[] microSkillsContentValues;
                HashMap<String, Object> entry = new HashMap<String, Object>();
                ContentValue contentValueProgram = (ContentValue)skillByProgramEntry.getValue("program");
                ArrayList<String> microSkillsIds = new ArrayList<String>();
                for (ContentValue microSkillContentValue : microSkillsContentValues = (ContentValue[])skillByProgramEntry.getValue("microSkills")) {
                    microSkillsIds.add(microSkillContentValue.getContentId());
                }
                entry.put("program", contentValueProgram.getContentId());
                entry.put("microSkills", microSkillsIds);
                result.put(contentValueProgram.getContentId(), entry);
            }
        }
        return result;
    }

    private Map<String, Object> _saveEditionForProgram(Program program, Map<String, Object> changes) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this._rightManager.currentUserHasRight(PROGRAM_EDIT_RIGHT_ID, (Object)program).equals((Object)RightManager.RightResult.RIGHT_ALLOW)) {
            result.put("success", false);
            result.put("errorMsg", "unauthorized");
            return result;
        }
        Set<String> programMicroSkillsIds = this._getMicroSkills(program);
        ArrayList<String> blockingMicroSkillsToSet = new ArrayList<String>();
        if (program.hasValue("blockingMicroSkills")) {
            blockingMicroSkillsToSet.addAll(Arrays.stream((ContentValue[])program.getValue("blockingMicroSkills")).map(value -> value.getContentId()).toList());
        }
        for (String microSkillId : changes.keySet()) {
            if (!this._checkValidSkills(microSkillId, programMicroSkillsIds, result)) continue;
            boolean isMicroSkillSelected = (Boolean)changes.get(microSkillId);
            if (blockingMicroSkillsToSet.contains(microSkillId) && !isMicroSkillSelected) {
                blockingMicroSkillsToSet.remove(microSkillId);
                continue;
            }
            if (blockingMicroSkillsToSet.contains(microSkillId) || !isMicroSkillSelected) continue;
            blockingMicroSkillsToSet.add(microSkillId);
        }
        try {
            HashMap<String, ArrayList<String>> inputsForEditProgram = new HashMap<String, ArrayList<String>>();
            inputsForEditProgram.put("blockingMicroSkills", blockingMicroSkillsToSet);
            this._contentWorkflowHelper.editContent((WorkflowAwareContent)program, inputsForEditProgram, 2);
        }
        catch (WorkflowException | AmetysRepositoryException e) {
            result.put("success", false);
            result.put("errorMsg", e.getMessage());
        }
        if (!result.containsKey("errorMsg")) {
            result.put("success", true);
        }
        return result;
    }

    private Set<String> _getMicroSkills(Program program) {
        HashSet<String> programMicroSkillsIds = new HashSet<String>();
        programMicroSkillsIds.addAll(program.getTransversalSkills().stream().map(macroSkill -> (ContentValue[])macroSkill.getValue("microSkills", false, (Object)new ContentValue[0])).flatMap(Arrays::stream).map(ContentValue::getContentId).toList());
        programMicroSkillsIds.addAll(program.getSkills().stream().map(macroSkill -> (ContentValue[])macroSkill.getValue("microSkills", false, (Object)new ContentValue[0])).flatMap(Arrays::stream).map(ContentValue::getContentId).toList());
        return programMicroSkillsIds;
    }

    private boolean _checkValidSkills(String microSkillId, Set<String> programMicroSkillsIds, Map<String, Object> result) {
        Content microSkill = this._getIfStillExists(microSkillId);
        if (microSkill == null) {
            Map warnings = (Map)result.computeIfAbsent("warnings", e -> new HashMap());
            warnings.put(INEXISTING_SKILL_WARN, true);
            Set uncommitedChanges = (Set)warnings.computeIfAbsent("notModifiedSkills", e -> new HashSet());
            uncommitedChanges.add(microSkillId);
            return false;
        }
        if (!programMicroSkillsIds.contains(microSkillId)) {
            Map warnings = (Map)result.computeIfAbsent("warnings", e -> new HashMap());
            Set notInProgram = (Set)warnings.computeIfAbsent(NOT_IN_PROGRAM_WARN, k -> new HashSet());
            notInProgram.add("'" + microSkill.getTitle() + "' [" + String.valueOf(microSkill.getValue("code")) + "]");
            Set uncommitedChanges = (Set)warnings.computeIfAbsent("notModifiedSkills", e -> new HashSet());
            uncommitedChanges.add(microSkillId);
            return false;
        }
        return true;
    }
}

