/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.manager;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.model.restrictions.RestrictedModelItem;
import org.ametys.cms.repository.Content;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.contenttype.ODFContentTypeAttributeManager;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.plugins.core.impl.cache.AbstractCacheKey;
import org.ametys.plugins.odfpilotage.helper.MCCWorkflowHelper;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.plugins.odfpilotage.helper.PilotageStatusHelper;
import org.ametys.plugins.odfpilotage.manager.ODFStatusRestrictionsViewParser;
import org.ametys.plugins.odfpilotage.rule.RulesManager;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ItemParserHelper;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemContainer;
import org.ametys.runtime.model.ViewItemGroup;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.util.log.SLF4JLoggerAdapter;
import org.apache.commons.lang.StringUtils;

public class ODFPilotageContentTypeAttributeManager
extends ODFContentTypeAttributeManager
implements Configurable,
Contextualizable,
Serviceable,
Initializable {
    private static String _ATTRIBUTE_FILE_PATH = "/org/ametys/plugins/odfpilotage/manager/restrictions.xml";
    private static String _ATTRIBUTE_FILE_PATH_TO_OVERRIDE = "/WEB-INF/param/odf/pilotage/restrictions.xml";
    private static final String __PILOTAGE_STATUS_UNMODIFIABLE_ATTRIBUTES_CACHE_ID = ODFPilotageContentTypeAttributeManager.class.getName() + "$unmodifiableAttributes";
    private static final String __MCC_STATUS_UNMODIFIABLE_ATTRIBUTES_CACHE_ID = ODFPilotageContentTypeAttributeManager.class.getName() + "$parentProgramsForRules";
    protected Context _cocoonContext;
    protected PilotageStatusHelper _pilotageStatusHelper;
    protected MCCWorkflowHelper _mccWorkflowHelper;
    protected PilotageHelper _pilotageHelper;
    protected RightManager _rightManager;
    protected CurrentUserProvider _currentUserProvider;
    protected Map<String, Map<StatusRestriction, List<String>>> _disabledAttributes;
    protected AbstractCacheManager _cacheManager;
    protected ContentTypeExtensionPoint _contentTypeEP;
    private org.apache.avalon.framework.context.Context _context;
    private ServiceManager _manager;

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._pilotageStatusHelper = (PilotageStatusHelper)((Object)manager.lookup(PilotageStatusHelper.ROLE));
        this._mccWorkflowHelper = (MCCWorkflowHelper)((Object)manager.lookup(MCCWorkflowHelper.ROLE));
        this._pilotageHelper = (PilotageHelper)((Object)manager.lookup(PilotageHelper.ROLE));
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
        this._contentTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = context;
        this._cocoonContext = (Context)context.get((Object)"environment-context");
    }

    public void initialize() throws Exception {
        this._cacheManager.createRequestCache(__PILOTAGE_STATUS_UNMODIFIABLE_ATTRIBUTES_CACHE_ID, new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_PILOTAGE_STATUS_UNMODIFIABLE_ATTRIBUTES_LABEL"), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_PILOTAGE_STATUS_UNMODIFIABLE_ATTRIBUTES_DESCRIPTION"), true);
        this._cacheManager.createRequestCache(__MCC_STATUS_UNMODIFIABLE_ATTRIBUTES_CACHE_ID, new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_MCC_STATUS_UNMODIFIABLE_ATTRIBUTES_LABEL"), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_MCC_STATUS_UNMODIFIABLE_ATTRIBUTES_DESCRIPTION"), true);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        block14: {
            this._disabledAttributes = new HashMap<String, Map<StatusRestriction, List<String>>>();
            try {
                File xml = new File(this._cocoonContext.getRealPath(_ATTRIBUTE_FILE_PATH_TO_OVERRIDE));
                if (!xml.isFile()) {
                    try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(_ATTRIBUTE_FILE_PATH);){
                        Configuration cfg = new DefaultConfigurationBuilder().build(is);
                        this._fillDisabledAttributesMap(cfg);
                        break block14;
                    }
                }
                try (FileInputStream is = new FileInputStream(xml);){
                    Configuration cfg = new DefaultConfigurationBuilder().build((InputStream)is);
                    this._fillDisabledAttributesMap(cfg);
                }
            }
            catch (Exception e) {
                throw new ConfigurationException("Error while parsing restrictions.xml", (Throwable)e);
            }
        }
    }

    protected void _fillDisabledAttributesMap(Configuration cfg) throws ConfigurationException {
        for (Configuration contentTypeConf : cfg.getChildren("content-type")) {
            String contentTypeId = contentTypeConf.getAttribute("id");
            ContentType contentType = (ContentType)this._contentTypeEP.getExtension(contentTypeId);
            HashMap<StatusRestriction, List<String>> attributesByState = new HashMap<StatusRestriction, List<String>>();
            for (Configuration statusConf : contentTypeConf.getChildren("status")) {
                ODFStatusRestrictionsViewParser parser = new ODFStatusRestrictionsViewParser(contentType);
                try {
                    LifecycleHelper.setupComponent((Object)((Object)parser), (Logger)new SLF4JLoggerAdapter(this.getLogger()), (org.apache.avalon.framework.context.Context)this._context, (ServiceManager)this._manager, null);
                    View view = parser.parseView(new ItemParserHelper.ConfigurationAndPluginName(statusConf, ""));
                    List<String> attributes = this._getAttributePathsFromView((ViewItemContainer)view, "");
                    String statusName = statusConf.getAttribute("name");
                    StatusRestriction statusRestriction = StringUtils.isNotBlank((String)statusName) ? StatusRestriction.valueOf(statusName) : StatusRestriction.NONE;
                    attributesByState.put(statusRestriction, attributes);
                }
                catch (Exception e) {
                    throw new ConfigurationException("Unable to parse ODF status restrictions for content type ", statusConf, (Throwable)e);
                }
                finally {
                    LifecycleHelper.dispose((Object)((Object)parser));
                }
            }
            this._disabledAttributes.put(contentTypeConf.getAttribute("id"), attributesByState);
        }
    }

    private List<String> _getAttributePathsFromView(ViewItemContainer view, String prefix) {
        ArrayList<String> attributePaths = new ArrayList<String>();
        List viewItems = view.getViewItems();
        for (ViewItem viewItem : viewItems) {
            attributePaths.add(prefix + viewItem.getName());
            if (!(viewItem instanceof ViewItemGroup)) continue;
            ViewItemGroup group = (ViewItemGroup)viewItem;
            attributePaths.addAll(this._getAttributePathsFromView((ViewItemContainer)group, viewItem.getName() + "/"));
        }
        return attributePaths;
    }

    private Cache<CacheKey, List<String>> _getPilotageStatusUnmodifiableAttributesCache() {
        return this._cacheManager.get(__PILOTAGE_STATUS_UNMODIFIABLE_ATTRIBUTES_CACHE_ID);
    }

    private Cache<CacheKey, List<String>> _getMCCStatusUnmodifiableAttributesCache() {
        return this._cacheManager.get(__MCC_STATUS_UNMODIFIABLE_ATTRIBUTES_CACHE_ID);
    }

    public boolean canWrite(Content content, RestrictedModelItem<Content> definition) throws AmetysRepositoryException {
        boolean canWrite = super.canWrite(content, definition);
        canWrite &= this._canWriteStatusRestrictions(content, definition.getPath());
        return canWrite &= this._pilotageHelper.canWriteMccRestrictions(content, definition.getPath());
    }

    private boolean _canWriteStatusRestrictions(Content content, String attributePath) {
        if (content == null || !(content instanceof ProgramItem) && !(content instanceof CoursePart)) {
            return true;
        }
        for (String type : content.getTypes()) {
            if (!this._disabledAttributes.containsKey(type)) continue;
            Map<StatusRestriction, List<String>> attributesRestrictions = this._disabledAttributes.get(type);
            if (!this._checkPilotageStatus(content, attributePath, attributesRestrictions)) {
                return false;
            }
            return this._checkMCCStatus(content, attributePath, attributesRestrictions);
        }
        return true;
    }

    private boolean _checkMCCStatus(Content content, String attributPath, Map<StatusRestriction, List<String>> attributesRestrictions) {
        UserIdentity user = this._currentUserProvider.getUser();
        CacheKey cacheKey = CacheKey.of(content.getId(), user);
        List unmodifiableAttributes = (List)this._getMCCStatusUnmodifiableAttributesCache().get((Object)cacheKey, __ -> this._getUnmodifiableAttributesForMCCStatus(content, user, attributesRestrictions));
        return !unmodifiableAttributes.contains(attributPath);
    }

    private List<String> _getUnmodifiableAttributesForMCCStatus(Content content, UserIdentity user, Map<StatusRestriction, List<String>> attributesRestrictions) {
        Set userRights;
        List<String> mccRulesAttributes = RulesManager.isRulesEnabled() ? Optional.ofNullable(attributesRestrictions.get((Object)StatusRestriction.RULES_VALIDATED)).orElse(List.of()) : List.of();
        List<String> mccAttributes = Optional.ofNullable(attributesRestrictions.get((Object)StatusRestriction.MCC_VALIDATED)).orElse(List.of());
        List mccOrgunitControlAttributes = Optional.ofNullable(attributesRestrictions.get((Object)StatusRestriction.MCC_ORGUNIT_CONTROLLED)).orElse(List.of());
        List mccOrgunitValidationAttributes = Optional.ofNullable(attributesRestrictions.get((Object)StatusRestriction.MCC_ORGUNIT_VALIDATED)).orElse(List.of());
        List mccCFVUControlAttributes = Optional.ofNullable(attributesRestrictions.get((Object)StatusRestriction.MCC_CFVU_CONTROLLED)).orElse(List.of());
        List mccCFVUValidationAttributes = Optional.ofNullable(attributesRestrictions.get((Object)StatusRestriction.MCC_CFVU_VALIDATED)).orElse(List.of());
        ArrayList<String> unmodifiableAttributes = new ArrayList<String>();
        Container parentContainerWithHigherMCCStatus = content instanceof ProgramItem ? this._mccWorkflowHelper.getParentContainerWithHigherMCCStatus((ProgramItem)content) : this._mccWorkflowHelper.getParentContainerWithHigherMCCStatus((CoursePart)content);
        Set set = userRights = parentContainerWithHigherMCCStatus != null ? this._rightManager.getUserRights(user, (Object)parentContainerWithHigherMCCStatus) : Set.of();
        if (parentContainerWithHigherMCCStatus != null && this._mccWorkflowHelper.isMCCCFVUValidated(parentContainerWithHigherMCCStatus) && !userRights.contains("ODF_Pilotage_MCC_CFVU_Validated_Super_Rights")) {
            unmodifiableAttributes.addAll(mccRulesAttributes);
            unmodifiableAttributes.addAll(mccAttributes);
            unmodifiableAttributes.addAll(mccOrgunitControlAttributes);
            unmodifiableAttributes.addAll(mccOrgunitValidationAttributes);
            unmodifiableAttributes.addAll(mccCFVUControlAttributes);
            unmodifiableAttributes.addAll(mccCFVUValidationAttributes);
        } else if (parentContainerWithHigherMCCStatus != null && this._mccWorkflowHelper.isMCCCFVUControlled(parentContainerWithHigherMCCStatus) && !userRights.contains("ODF_Pilotage_MCC_CFVU_Validated_Super_Rights") && !userRights.contains("ODF_Pilotage_MCC_CFVU_Controlled_Super_Rights")) {
            unmodifiableAttributes.addAll(mccRulesAttributes);
            unmodifiableAttributes.addAll(mccAttributes);
            unmodifiableAttributes.addAll(mccOrgunitControlAttributes);
            unmodifiableAttributes.addAll(mccOrgunitValidationAttributes);
            unmodifiableAttributes.addAll(mccCFVUControlAttributes);
        } else if (parentContainerWithHigherMCCStatus != null && this._mccWorkflowHelper.isMCCOrgUnitValidated(parentContainerWithHigherMCCStatus) && !userRights.contains("ODF_Pilotage_MCC_CFVU_Validated_Super_Rights") && !userRights.contains("ODF_Pilotage_MCC_CFVU_Controlled_Super_Rights") && !userRights.contains("ODF_Pilotage_MCC_Orgunit_Validated_Super_Rights")) {
            unmodifiableAttributes.addAll(mccRulesAttributes);
            unmodifiableAttributes.addAll(mccAttributes);
            unmodifiableAttributes.addAll(mccOrgunitControlAttributes);
            unmodifiableAttributes.addAll(mccOrgunitValidationAttributes);
        } else if (!(parentContainerWithHigherMCCStatus == null || !this._mccWorkflowHelper.isMCCOrgUnitControlled(parentContainerWithHigherMCCStatus) || userRights.contains("ODF_Pilotage_MCC_CFVU_Validated_Super_Rights") || userRights.contains("ODF_Pilotage_MCC_CFVU_Controlled_Super_Rights") || userRights.contains("ODF_Pilotage_MCC_Orgunit_Validated_Super_Rights") || userRights.contains("ODF_Pilotage_MCC_Orgunit_Controlled_Super_Rights"))) {
            unmodifiableAttributes.addAll(mccRulesAttributes);
            unmodifiableAttributes.addAll(mccAttributes);
            unmodifiableAttributes.addAll(mccOrgunitControlAttributes);
        } else {
            unmodifiableAttributes.addAll(this._getUnmodifiableAttributesForRules(content, user, mccRulesAttributes));
            unmodifiableAttributes.addAll(this._getUnmodifiableAttributesForMCCFields(content, user, mccAttributes));
        }
        return unmodifiableAttributes;
    }

    private List<String> _getUnmodifiableAttributesForRules(Content content, UserIdentity user, List<String> mccRulesMentionAttributes) {
        Set userRights;
        Container parentContainerWithHigherMCCStatus;
        ArrayList<String> unmodifiableAttributes = new ArrayList<String>();
        Container container = parentContainerWithHigherMCCStatus = content instanceof ProgramItem ? this._mccWorkflowHelper.getParentContainerWithHigherMCCStatusForRules((ProgramItem)content) : this._mccWorkflowHelper.getParentContainerWithHigherMCCStatusForRules((CoursePart)content);
        if (!(parentContainerWithHigherMCCStatus == null || !this._mccWorkflowHelper.isRulesValidated(parentContainerWithHigherMCCStatus) || (userRights = this._rightManager.getUserRights(user, (Object)parentContainerWithHigherMCCStatus)).contains("ODF_Pilotage_Rules_Validated_Super_Rights") || userRights.contains("ODF_Pilotage_MCC_CFVU_Validated_Super_Rights") || userRights.contains("ODF_Pilotage_MCC_CFVU_Controlled_Super_Rights") || userRights.contains("ODF_Pilotage_MCC_Orgunit_Validated_Super_Rights") || userRights.contains("ODF_Pilotage_MCC_Orgunit_Controlled_Super_Rights"))) {
            unmodifiableAttributes.addAll(mccRulesMentionAttributes);
        }
        return unmodifiableAttributes;
    }

    private List<String> _getUnmodifiableAttributesForMCCFields(Content content, UserIdentity user, List<String> mccMentionAttributes) {
        Set userRights;
        Container parentContainerWithHigherMCCStatus;
        ArrayList<String> unmodifiableAttributes = new ArrayList<String>();
        Container container = parentContainerWithHigherMCCStatus = content instanceof ProgramItem ? this._mccWorkflowHelper.getParentContainerWithHigherMCCStatusForMCCFields((ProgramItem)content) : this._mccWorkflowHelper.getParentContainerWithHigherMCCStatusForMCCFields((CoursePart)content);
        if (!(parentContainerWithHigherMCCStatus == null || !this._mccWorkflowHelper.isMCCValidated(parentContainerWithHigherMCCStatus) || (userRights = this._rightManager.getUserRights(user, (Object)parentContainerWithHigherMCCStatus)).contains("ODF_Pilotage_MCC_Validated_Super_Rights") || userRights.contains("ODF_Pilotage_MCC_CFVU_Validated_Super_Rights") || userRights.contains("ODF_Pilotage_MCC_CFVU_Controlled_Super_Rights") || userRights.contains("ODF_Pilotage_MCC_Orgunit_Validated_Super_Rights") || userRights.contains("ODF_Pilotage_MCC_Orgunit_Controlled_Super_Rights"))) {
            unmodifiableAttributes.addAll(mccMentionAttributes);
        }
        return unmodifiableAttributes;
    }

    private boolean _checkPilotageStatus(Content content, String attributPath, Map<StatusRestriction, List<String>> attributesRestrictions) {
        UserIdentity user = this._currentUserProvider.getUser();
        CacheKey cacheKey = CacheKey.of(content.getId(), user);
        List unmodifiableAttributes = (List)this._getPilotageStatusUnmodifiableAttributesCache().get((Object)cacheKey, __ -> this._getUnmodifiableAttributesForPilotageStatus(content, attributesRestrictions));
        return !unmodifiableAttributes.contains(attributPath);
    }

    private List<String> _getUnmodifiableAttributesForPilotageStatus(Content content, Map<StatusRestriction, List<String>> attributesRestrictions) {
        List mentionsAttributes = Optional.ofNullable(attributesRestrictions.get((Object)StatusRestriction.MENTION_VALIDATED)).orElse(List.of());
        List orgunitAttributes = Optional.ofNullable(attributesRestrictions.get((Object)StatusRestriction.ORGUNIT_VALIDATED)).orElse(List.of());
        List cfvuAttributes = Optional.ofNullable(attributesRestrictions.get((Object)StatusRestriction.CFVU_VALIDATED)).orElse(List.of());
        Program parentProgramWithHigherPilotageStatus = content instanceof ProgramItem ? this._pilotageStatusHelper.getParentProgramWithHigherPilotageStatus((ProgramItem)content) : this._pilotageStatusHelper.getParentProgramWithHigherPilotageStatus((CoursePart)content);
        ArrayList<String> unmodifiableAttributes = new ArrayList<String>();
        if (parentProgramWithHigherPilotageStatus != null && !this._pilotageStatusHelper.hasEditSuperRight(parentProgramWithHigherPilotageStatus)) {
            PilotageStatusHelper.PilotageStatus pilotageStatus = this._pilotageStatusHelper.getPilotageStatus((Content)parentProgramWithHigherPilotageStatus);
            switch (pilotageStatus) {
                case MENTION_VALIDATED: {
                    unmodifiableAttributes.addAll(mentionsAttributes);
                    break;
                }
                case ORGUNIT_VALIDATED: {
                    unmodifiableAttributes.addAll(mentionsAttributes);
                    unmodifiableAttributes.addAll(orgunitAttributes);
                    break;
                }
                case CFVU_VALIDATED: {
                    unmodifiableAttributes.addAll(mentionsAttributes);
                    unmodifiableAttributes.addAll(orgunitAttributes);
                    unmodifiableAttributes.addAll(cfvuAttributes);
                    break;
                }
            }
        }
        return unmodifiableAttributes;
    }

    public static enum StatusRestriction {
        MENTION_VALIDATED,
        ORGUNIT_VALIDATED,
        CFVU_VALIDATED,
        RULES_VALIDATED,
        MCC_VALIDATED,
        MCC_ORGUNIT_CONTROLLED,
        MCC_ORGUNIT_VALIDATED,
        MCC_CFVU_CONTROLLED,
        MCC_CFVU_VALIDATED,
        NONE;

    }

    static final class CacheKey
    extends AbstractCacheKey {
        private CacheKey(String contentId, UserIdentity user) {
            super(new Object[]{user, contentId});
        }

        static CacheKey of(String contentId, UserIdentity user) {
            return new CacheKey(contentId, user);
        }
    }
}

