/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.impl;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.catalog.CatalogsManager;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfpilotage.report.impl.AbstractExtract;
import org.ametys.plugins.odfpilotage.report.impl.tree.ProgramItemTree;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractMaquetteExtract
extends AbstractExtract
implements Initializable {
    protected static final ProgramItemComparator PROGRAM_ITEM_COMPARATOR = new ProgramItemComparator();
    protected View _courseView;
    protected View _courseListView;
    protected View _containerView;
    protected View _subProgramView;
    protected View _programView;
    protected ContentTypeExtensionPoint _contentTypeEP;
    protected CatalogsManager _catalogsManager;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._catalogsManager = (CatalogsManager)manager.lookup(CatalogsManager.ROLE);
        this._contentTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
    }

    public void initialize() throws Exception {
        this._courseView = this.getView("org.ametys.plugins.odf.Content.course", "report-maquette");
        this._courseListView = this.getView("org.ametys.plugins.odf.Content.courseList", "report-maquette");
        this._containerView = this.getView("org.ametys.plugins.odf.Content.container", "report-maquette");
        this._subProgramView = this.getView("org.ametys.plugins.odf.Content.subProgram", "report-maquette");
        this._programView = this.getView("org.ametys.plugins.odf.Content.program", "report-maquette");
    }

    protected View getView(String contentTypeId, String viewName) {
        ContentType courseContentType = (ContentType)this._contentTypeEP.getExtension(contentTypeId);
        return courseContentType.getView(viewName);
    }

    @Override
    public Set<String> getSupportedOutputFormats() {
        return Set.of("doc", "xls");
    }

    @Override
    public void saxProgramItem(ContentHandler handler, String programItemId, Map<String, String> reportParameters) {
        ProgramItem programItem = (ProgramItem)this._resolver.resolveById(programItemId);
        if (!(programItem instanceof Program)) {
            throw new UnsupportedOperationException("The report '" + this.getType() + "' can be launch only on programs.");
        }
        Program program = (Program)programItem;
        ProgramItemTree programTree = this.createTreeFromProgramItem(programItem, reportParameters);
        try {
            handler.startDocument();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("type", this.getType());
            XMLUtils.startElement((ContentHandler)handler, (String)"report", (Attributes)attrs);
            this.saxGlobalInformations(handler, programItem, reportParameters);
            this._reportHelper.saxNaturesEnseignement(handler, this.getLogger());
            this.saxTree(handler, programTree);
            XMLUtils.endElement((ContentHandler)handler, (String)"report");
            handler.endDocument();
        }
        catch (Exception e) {
            this.getLogger().error("An error occured while generating 'Maquette' extract for program '{}' ({})", new Object[]{program.getTitle(), program.getCode(), e});
        }
    }

    protected ProgramItemTree createTreeFromProgramItem(ProgramItem programItem, Map<String, String> reportParameters) {
        ProgramItemTree programItemTree = new ProgramItemTree(programItem);
        this.populateTree(programItemTree);
        return programItemTree;
    }

    protected abstract void populateTree(ProgramItemTree var1);

    protected void saxTree(ContentHandler handler, ProgramItemTree tree) throws SAXException {
        ProgramItem programItem = tree.getCurrent();
        if (programItem instanceof Program) {
            Program program = (Program)programItem;
            this.saxContent(handler, "program", (Content)program, this._programView, tree, true);
        } else if (programItem instanceof SubProgram) {
            SubProgram subProgram = (SubProgram)programItem;
            this.saxContent(handler, "subProgram", (Content)subProgram, this._subProgramView, tree, true);
        } else if (programItem instanceof Container) {
            Container container = (Container)programItem;
            this.saxContent(handler, "container", (Content)container, this._containerView, tree, true);
        } else if (programItem instanceof CourseList) {
            CourseList courseList = (CourseList)programItem;
            this.saxContent(handler, "courseList", (Content)courseList, this._courseListView, tree, true);
        } else if (programItem instanceof Course) {
            Course course = (Course)programItem;
            this.saxContent(handler, "course", (Content)course, this._courseView, tree, true);
        }
    }

    protected void saxContent(ContentHandler handler, String tagName, Content content, View view, ProgramItemTree tree, boolean saxHierarchy) throws SAXException {
        AttributesImpl attr = this.getProgramItemAttributes((ProgramItem)content, tree);
        XMLUtils.startElement((ContentHandler)handler, (String)tagName, (Attributes)attr);
        content.dataToSAX(handler, (ViewItemAccessor)view);
        if (saxHierarchy) {
            for (ProgramItemTree child : tree.getChildren()) {
                this.saxTree(handler, child);
            }
        }
        XMLUtils.endElement((ContentHandler)handler, (String)tagName);
    }

    protected AttributesImpl getProgramItemAttributes(ProgramItem programItem, ProgramItemTree tree) {
        Content content = (Content)programItem;
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", content.getId());
        attrs.addCDATAAttribute("name", content.getName());
        attrs.addCDATAAttribute("path", tree.getPath().toString());
        return attrs;
    }

    protected List<ProgramItem> getOrderedChildren(ProgramItem programItem) {
        List children = this._odfHelper.getChildProgramItems(programItem);
        children.sort(PROGRAM_ITEM_COMPARATOR);
        return children;
    }

    protected void saxGlobalInformations(ContentHandler handler, ProgramItem programItem, Map<String, String> reportParameters) throws SAXException {
        String catalog = programItem.getCatalog();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", catalog);
        XMLUtils.createElement((ContentHandler)handler, (String)"catalog", (Attributes)attrs, (String)this._catalogsManager.getCatalog(catalog).getTitle());
        XMLUtils.createElement((ContentHandler)handler, (String)"title", (String)((Content)programItem).getTitle());
        XMLUtils.createElement((ContentHandler)handler, (String)"lang", (String)programItem.getLanguage());
    }

    protected static final class ProgramItemComparator
    implements Comparator<ProgramItem> {
        protected ProgramItemComparator() {
        }

        @Override
        public int compare(ProgramItem p1, ProgramItem p2) {
            if (p1 instanceof CourseList && !(p2 instanceof CourseList)) {
                return 1;
            }
            if (!(p1 instanceof CourseList) && p2 instanceof CourseList) {
                return -1;
            }
            if (p1 instanceof CourseList) {
                CourseList cl1 = (CourseList)p1;
                if (p2 instanceof CourseList) {
                    CourseList.ChoiceType t2;
                    CourseList cl2 = (CourseList)p2;
                    CourseList.ChoiceType t1 = cl1.getType();
                    if (t1.equals((Object)(t2 = cl2.getType()))) {
                        return 0;
                    }
                    if (t1.equals((Object)CourseList.ChoiceType.MANDATORY) || !t2.equals((Object)CourseList.ChoiceType.MANDATORY) && t1.equals((Object)CourseList.ChoiceType.CHOICE)) {
                        return -1;
                    }
                    return 1;
                }
            }
            return 0;
        }
    }
}

