/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.pipeline;

import java.io.IOException;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.odfpilotage.report.PilotageReport;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PilotageReportZipGenerator
extends ServiceableGenerator {
    public static final String MANIFEST_TYPE = "type";
    public static final String MANIFEST_DATE = "date";
    public static final String MANIFEST_TARGET = "target";
    private JSONUtils _jsonUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        PilotageReport pilotageReport = (PilotageReport)request.getAttribute("report");
        PilotageReport.PilotageReportTarget target = (PilotageReport.PilotageReportTarget)((Object)request.getAttribute("reportTarget"));
        Map reportParameters = (Map)request.getAttribute("reportParameters");
        this.contentHandler.startDocument();
        this.contentHandler.startPrefixMapping("zip", "http://apache.org/cocoon/zip-archive/1.0");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"http://apache.org/cocoon/zip-archive/1.0", (String)"archive");
        PilotageReport.PilotageReportContent content = pilotageReport.getReportContent(target, reportParameters);
        request.setAttribute("reportPluginName", (Object)pilotageReport.getPluginName());
        Map<String, String> files = content.files();
        if (files.isEmpty()) {
            request.setAttribute("reportStatus", (Object)"NO_FILE");
        } else {
            this._createZipEntries(files);
            this._addManifestEntry(pilotageReport, target, reportParameters);
            request.setAttribute("reportZipName", (Object)content.zipName());
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"http://apache.org/cocoon/zip-archive/1.0", (String)"archive");
        this.contentHandler.endPrefixMapping("zip");
        this.contentHandler.endDocument();
    }

    private void _addManifestEntry(PilotageReport report, PilotageReport.PilotageReportTarget target, Map<String, String> reportParameters) throws SAXException {
        HashMap<String, Object> manifestData = new HashMap<String, Object>();
        manifestData.put(MANIFEST_TYPE, report.getId());
        manifestData.put(MANIFEST_DATE, LocalDate.now());
        manifestData.put(MANIFEST_TARGET, target.name().toLowerCase());
        manifestData.putAll(reportParameters);
        AttributesImpl zipAttrs = new AttributesImpl();
        zipAttrs.addCDATAAttribute("name", "manifest.json");
        zipAttrs.addCDATAAttribute("serializer", "text");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"http://apache.org/cocoon/zip-archive/1.0", (String)"entry", (Attributes)zipAttrs);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"text", (String)this._jsonUtils.convertObjectToJson(manifestData));
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"http://apache.org/cocoon/zip-archive/1.0", (String)"entry");
    }

    private void _createZipEntries(Map<String, String> filesList) throws SAXException {
        for (String filename : filesList.keySet()) {
            AttributesImpl zipAttrs = new AttributesImpl();
            zipAttrs.addCDATAAttribute("name", filename);
            zipAttrs.addCDATAAttribute("src", filesList.get(filename));
            XMLUtils.createElementNS((ContentHandler)this.contentHandler, (String)"http://apache.org/cocoon/zip-archive/1.0", (String)"entry", (Attributes)zipAttrs);
        }
    }
}

