/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.pipeline;

import java.util.HashMap;
import java.util.Map;
import org.ametys.core.util.URIUtils;
import org.ametys.odf.ProgramItem;
import org.ametys.plugins.odfpilotage.report.PilotageReport;
import org.ametys.plugins.odfpilotage.report.ReportExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;

public class SetReportParametersAndHeaderAction
extends ServiceableAction {
    public static final String PARAMETER_PREFIX = SetReportParametersAndHeaderAction.class.getName() + "$";
    protected ReportExtensionPoint _reportEP;
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._reportEP = (ReportExtensionPoint)((Object)smanager.lookup(ReportExtensionPoint.ROLE));
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String reportId = request.getParameter("reportId");
        PilotageReport report = (PilotageReport)this._reportEP.getExtension(reportId);
        request.setAttribute("report", (Object)report);
        String outputFormat = parameters.getParameter("outputFormat");
        if (!report.isSupportedFormat(outputFormat)) {
            throw new UnsupportedOperationException("Impossible to launch the report '" + report.getType() + "' with the output format '" + outputFormat + "'.");
        }
        request.setAttribute("reportPluginName", (Object)report.getPluginName());
        HashMap<String, String> reportParameters = new HashMap<String, String>();
        reportParameters.put("outputFormat", outputFormat);
        request.setAttribute("reportParameters", reportParameters);
        Response response = ObjectModelHelper.getResponse((Map)objectModel);
        ProgramItem programItem = (ProgramItem)this._resolver.resolveById(request.getParameter("programItem"));
        String fileName = URIUtils.encodeHeader((String)report.getReportFileName(programItem, reportParameters, outputFormat));
        response.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\";filename*=UTF-8''" + fileName);
        return Map.of("reportType", report.getType());
    }
}

