/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.tree;

import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.tree.AbstractStaticODFTreeIndicator;
import org.ametys.odf.tree.ODFTreeIndicator;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ExcludedFromMCCIndicator
extends AbstractStaticODFTreeIndicator {
    protected PilotageHelper _pilotageHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._pilotageHelper = (PilotageHelper)((Object)smanager.lookup(PilotageHelper.ROLE));
    }

    public ODFTreeIndicator.IndicatorData getIndicatorData(Content content) {
        CourseList courseList;
        if (content instanceof Course) {
            Course course = (Course)content;
            if (this._pilotageHelper.isExcludedFromMCC(course)) {
                return new ODFTreeIndicator.IndicatorData(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_EXCLUDED_FROM_MCC_TREE_INDICATORS_TOOLTIP"), null, this.getIconGlyph(), Map.of());
            }
            if (this._pilotageHelper.isParentExcludedInMCC((ProgramItem)course)) {
                return new ODFTreeIndicator.IndicatorData(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_EXCLUDED_FROM_MCC_TREE_INDICATORS_PARENT_TOOLTIP"), null, "grey-color " + this.getIconGlyph(), Map.of());
            }
        } else if (content instanceof CourseList && this._pilotageHelper.isParentExcludedInMCC((ProgramItem)(courseList = (CourseList)content))) {
            return new ODFTreeIndicator.IndicatorData(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_EXCLUDED_FROM_MCC_TREE_INDICATORS_PARENT_TOOLTIP"), null, "grey-color " + this.getIconGlyph(), Map.of());
        }
        return null;
    }
}

