  /*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

const HashMap = Java.type("java.util.HashMap");
const AbstractContentWorkflowComponent = Java.type("org.ametys.cms.workflow.AbstractContentWorkflowComponent");
const ContentWorkflowHelper = Ametys.serviceManager.lookup("org.ametys.cms.workflow.ContentWorkflowHelper");
const OdfReferenceTableHelper = Ametys.serviceManager.lookup("org.ametys.odf.enumeration.OdfReferenceTableHelper");

let neutralizationContent = _createRefContent("Neutralisation", "ignore");
let zeroContent = _createRefContent("Note à zéro", "zero");  

let count = 0;
let queryFilter = "@ametys-internal:contentType='org.ametys.plugins.odf.Content.container' and (@ametys:justifiedAbsence != '' or @ametys:unjustifiedAbsence != '')"
Repository.query("//element(*, ametys:content)[" + queryFilter + "]").forEach(function(content) {
    count++;
    Content.migrate(             
        content,             
        [_absenceToContent],             
        false,             
        null,             
        false,
        true
    );
});
logger.info(`${count} content(s) migrated`);
   
function _createRefContent(title, code)
{
    let item = OdfReferenceTableHelper.getItemFromCode("odf-enumeration.AbsenceImpact", code);
    if (item != null)
    {
        return item.getContent();
    }
    else
    {
        let titleVariants = new HashMap();
        titleVariants.put("fr", title);
        
        let result = ContentWorkflowHelper.createContent("reference-table", 1, title, titleVariants, ["odf-enumeration.AbsenceImpact"], []);
        let content = result.get(AbstractContentWorkflowComponent.CONTENT_KEY);
        content.setValue("code", code);
        content.saveChanges();
        return content;
    }
}
    
function _absenceToContent(content)
{
    let node = content.getNode();
    if (node.hasProperty("ametys:justifiedAbsence"))
    {
        let value = node.getProperty("ametys:justifiedAbsence").getString();
        let c = _value2Content(value);
        if (c != null)
        {
            content.setValue("justifiedAbsence", c);      
        }
    }
    
    if (node.hasProperty("ametys:unjustifiedAbsence"))
    {
        let value = node.getProperty("ametys:unjustifiedAbsence").getString();
        let c = _value2Content(value);
        if (c != null)
        {
            content.setValue("unjustifiedAbsence", c);      
        }
    }
}

function _value2Content(value)
{
    if (value == "zero")
    {
        return zeroContent;
    }
    else if (value == "neutralization")
    {
        return neutralizationContent;
    }
    return null;
}