<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

    <xsl:template match="/">
    <text>
    
/**
 * This class is the model for nodes of the program tree.
 * @private
 */
Ext.define('Ametys.plugins.odf.pilotage.tree.CostModelingContentsTreeModel', {
    extend : 'Ametys.plugins.odf.tree.ODFContentsTreeModel',

    fields : [
        {
            name: 'effectivesGlobal',
            mapping: 'effectives',
            convert: function(value, node)
            {
                if (value == undefined || !Ext.isObject(value)) return value;
                if (value.estimated != undefined) return value.estimated;
                return null;
            }
        },
        {
            name: 'effectivesLocal',
            mapping: 'effectives',
            convert: function(value, node)
            {
                if (value == undefined || !Ext.isObject(value)) return value;
                if (value.local != undefined) return value.local;
                return null;
            }
        },
        {
            name: 'effectivesType',
            mapping: 'effectives',
            convert: function(value, node)
            {
                if (value == undefined || !Ext.isObject(value)) return '';
                if (value.overridden != undefined) return 'overridden';
                if (value.entered != undefined) return 'entered';
                if (value.estimated != undefined) return 'estimated';
                if (value.computed != undefined) return 'computed';
                return '';
            }
        },
        {
            name: 'groupsDisplay',
            mapping: 'groups',
            convert: function(value, node)
            {
                if (value == undefined || !Ext.isObject(value)) return value;
                if (value.overridden != undefined) return value.overridden;
                if (value.entered != undefined) return value.entered;
                if (value.computed != undefined) return value.computed;
                return null;
            }
        },
        {
            name: 'groupType',
            mapping: 'groups',
            convert: function(value, node)
            {
                if (value == undefined || !Ext.isObject(value)) return '';
                if (value.overridden != undefined) return 'overridden';
                if (value.entered != undefined) return 'entered';
                if (value.computed != undefined) return 'computed';
                return '';
            }
        },
        <xsl:for-each select="items[@contentTypeId = 'odf-enumeration.EnseignementNature']/item">
        {
            name: '<xsl:value-of select="@code"/>',
            mapping: 'volumesOfHours',
            convert: function(value, node)
            {
                if (value == undefined || !Ext.isObject(value)) return value;
                if (value['<xsl:value-of select="@id"/>'] != undefined) return value['<xsl:value-of select="@id"/>'];
                return null;
            }
        },
        </xsl:for-each>
        {
            name: 'eqTDglobal',
            mapping: 'eqTD',
            convert: function(value, node)
            {
                if (value == undefined || !Ext.isObject(value)) return value;
                if (value.global != undefined) return value.global;
                return null;
            }
        },
        {
            name: 'eqTDprorated',
            mapping: 'eqTD',
            convert: function(value, node)
            {
                if (value == undefined || !Ext.isObject(value)) return value;
                if (value.prorated != undefined) return value.prorated;
                return null;
            }
        },
        {
            name: 'eqTDlocal',
            mapping: 'eqTD',
            convert: function(value, node)
            {
                if (value == undefined || !Ext.isObject(value)) return value;
                if (value.local != undefined) return value.local;
                return null;
            }
        },
        {
            name: 'currentYearEffectives',
            mapping: 'previousData',
            convert: function(value, node)
            {
                if (value == undefined || !Ext.isObject(value)) return value;
                if (value.currentYearEffectives != undefined) return value.currentYearEffectives;
                return null;
            }
        },
        {
            name: 'currentYearGroups',
            mapping: 'previousData',
            convert: function(value, node)
            {
                if (value == undefined || !Ext.isObject(value)) return value;
                if (value.currentYearGroups != undefined) return value.currentYearGroups;
                return null;
            }
        },
        {
            name: 'precedingYearEffectives',
            mapping: 'previousData',
            convert: function(value, node)
            {
                if (value == undefined || !Ext.isObject(value)) return value;
                if (value.precedingYearEffectives != undefined) return value.precedingYearEffectives;
                return null;
            }
        },
        {
            name: 'precedingYearGroups',
            mapping: 'previousData',
            convert: function(value, node)
            {
                if (value == undefined || !Ext.isObject(value)) return value;
                if (value.precedingYearGroups != undefined) return value.precedingYearGroups;
                return null;
            }
        }
    ]
});
</text>
</xsl:template>
</xsl:stylesheet>