/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.report.consistency;

/**
 * Status of the analysis.
 */
public enum ConsistencyAnalysisStatus
{
    /** No error */
    OK("green", "white"),
    /** Analysis for computation or informations only */
    NEUTRAL("white", "black"),
    /** Errors in the analysis */
    KO("red", "white");

    private String _bgColor;
    private String _fontColor;
    
    private ConsistencyAnalysisStatus(String bgColor, String fontColor)
    {
        this._bgColor = bgColor;
        this._fontColor = fontColor;
    }
    
    /**
     * Get the background color for the resume.
     * @return The background color
     */
    public String getBgColor()
    {
        return _bgColor;
    }
    
    /**
     * Get the font color for the resume.
     * @return The font color
     */
    public String getFontColor()
    {
        return _fontColor;
    }
}
