/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.report.impl;

import java.util.List;
import java.util.Map;

import org.ametys.odf.ProgramItem;
import org.ametys.plugins.odfpilotage.report.impl.tree.ProgramItemTree;

/**
 * Class to generate course extract as DOC.
 */
public class MaquetteExtract extends AbstractMaquetteExtract
{
    @Override
    protected String getType(Map<String, String> reportParameters)
    {
        return "maquette";
    }
    
    @Override
    protected void populateTree(ProgramItemTree tree)
    {
        ProgramItem programItem = tree.getCurrent();
        List<ProgramItem> children = getOrderedChildren(programItem);
        for (ProgramItem child : children)
        {
            ProgramItemTree childTree = tree.addChild(child);
            populateTree(childTree);
        }
    }
}
