/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.cost.entity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ametys.cms.data.ContentDataHelper;
import org.ametys.cms.data.holder.group.IndexableRepeater;
import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfpilotage.cost.entity.CostComputationData;
import org.ametys.plugins.odfpilotage.cost.entity.Effectives;
import org.ametys.plugins.odfpilotage.cost.entity.EqTD;
import org.ametys.plugins.odfpilotage.cost.entity.Groups;
import org.ametys.plugins.odfpilotage.cost.entity.NormDetails;
import org.ametys.plugins.odfpilotage.cost.entity.OverriddenData;
import org.ametys.plugins.odfpilotage.cost.entity.ProgramItemData;
import org.ametys.plugins.odfpilotage.cost.entity.VolumesOfHours;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.runtime.config.Config;

public class CostComputationDataCache {
    private Map<String, String> _eqTDComputationByNature;
    private Map<String, Double> _eqTDByNature;
    private Map<String, NormDetails> _effectiveMinMaxByNature;
    private Map<String, Map<String, NormDetails>> _normDetailsByNormAndNature;
    private String _yearNature;
    private CostComputationData _costData;
    private Set<String> _exploredItems;
    private OverriddenData _overriddenData;

    public CostComputationDataCache(List<Program> programs, List<OdfReferenceTableEntry> norms, List<OdfReferenceTableEntry> teachingNatures, String yearNature, OverriddenData overriddenData) {
        this._costData = new CostComputationData(programs);
        this._exploredItems = new HashSet<String>();
        this._initializeNatureData(teachingNatures);
        this._initializeNormData(norms);
        this._yearNature = yearNature;
        this._overriddenData = overriddenData;
    }

    protected void _initializeNormData(List<OdfReferenceTableEntry> norms) {
        this._normDetailsByNormAndNature = new HashMap<String, Map<String, NormDetails>>();
        for (OdfReferenceTableEntry normeEntry : norms) {
            HashMap<String, NormDetails> normDetailsByNature = new HashMap<String, NormDetails>();
            if (normeEntry.getContent().hasValue("groupEffectives")) {
                IndexableRepeater groupEffectives = normeEntry.getContent().getRepeater("groupEffectives");
                for (ModelAwareRepeaterEntry groupEffectivesEntry : groupEffectives.getEntries()) {
                    NormDetails normDetails = new NormDetails((Long)groupEffectivesEntry.getValue("effectifMax"), (Long)groupEffectivesEntry.getValue("effectifMinSup"), normeEntry.getLabel((String)Config.getInstance().getValue("odf.programs.lang")));
                    normDetailsByNature.put(ContentDataHelper.getContentIdFromContentData((ModelAwareDataHolder)groupEffectivesEntry, (String)"natureEnseignement"), normDetails);
                }
            }
            this._normDetailsByNormAndNature.put(normeEntry.getId(), normDetailsByNature);
        }
    }

    protected void _initializeNatureData(List<OdfReferenceTableEntry> teachingNatures) {
        this._eqTDComputationByNature = new HashMap<String, String>();
        this._eqTDByNature = new HashMap<String, Double>();
        this._effectiveMinMaxByNature = new HashMap<String, NormDetails>();
        for (OdfReferenceTableEntry teachingNature : teachingNatures) {
            String id = teachingNature.getId();
            String eqTDComputationMode = (String)teachingNature.getContent().getValue("eqTDComputationMode", true, (Object)"org.ametys.plugins.odfpilotage.cost.eqtd.GroupsMode");
            this._eqTDComputationByNature.put(id, eqTDComputationMode);
            Double eqTD = PilotageHelper.transformEqTD2Double((String)teachingNature.getContent().getValue("eqTD"));
            if (eqTD != null) {
                this._eqTDByNature.put(id, eqTD);
            }
            NormDetails normDetails = new NormDetails((Long)teachingNature.getContent().getValue("effectifMax"), (Long)teachingNature.getContent().getValue("effectifMinSup"));
            this._effectiveMinMaxByNature.put(id, normDetails);
        }
    }

    public boolean addExploredItem(String exploredItem) {
        return this._exploredItems.add(exploredItem);
    }

    public CostComputationData getCostComputationData() {
        return this._costData;
    }

    public String getEqTDComputationByNature(String natureId) {
        return this._eqTDComputationByNature.get(natureId);
    }

    public Double getEqTDByNature(String natureId) {
        return this._eqTDByNature.get(natureId);
    }

    public NormDetails getEffectiveMinMaxByNature(String natureId) {
        return this._effectiveMinMaxByNature.get(natureId);
    }

    public NormDetails getNormDetailsForNature(String normId, String natureId) {
        return this._normDetailsByNormAndNature.get(normId).get(natureId);
    }

    public boolean normExists(String normId) {
        return this._normDetailsByNormAndNature.containsKey(normId);
    }

    public boolean natureInNormExists(String normId, String natureId) {
        return this._normDetailsByNormAndNature.get(normId).containsKey(natureId);
    }

    public String getYearNature() {
        return this._yearNature;
    }

    public ProgramItemData getProgramItemData(String programItemId) {
        return Optional.of(programItemId).map(this._costData::get).orElse(null);
    }

    public Effectives getEffectives(String programItemId) {
        return Optional.of(programItemId).map(this._costData::get).map(ProgramItemData::getEffectives).orElse(null);
    }

    public void putEffectives(String programItemId, Effectives effectives) {
        ProgramItemData data = this._costData.computeIfAbsent(programItemId, __ -> new ProgramItemData());
        data.setEffectives(effectives);
    }

    public Double getWeight(String programItemId) {
        return Optional.of(programItemId).map(this._costData::get).map(ProgramItemData::getWeight).orElse(null);
    }

    public void putWeight(String programItemId, Double weight) {
        ProgramItemData data = this._costData.computeIfAbsent(programItemId, __ -> new ProgramItemData());
        data.setWeight(weight);
    }

    public Set<String> getPathes(String programItemId) {
        return Optional.of(programItemId).map(this._costData::get).map(ProgramItemData::getPathes).orElse(null);
    }

    public void putPathes(String programItemId, Set<String> pathes) {
        ProgramItemData data = this._costData.computeIfAbsent(programItemId, __ -> new ProgramItemData());
        data.setPathes(pathes);
    }

    public VolumesOfHours getVolumesOfHours(String programItemId) {
        return Optional.of(programItemId).map(this._costData::get).map(ProgramItemData::getVolumesOfHours).orElse(null);
    }

    public void putVolumesOfHours(String programItemId, VolumesOfHours volumesOfHours) {
        ProgramItemData data = this._costData.computeIfAbsent(programItemId, __ -> new ProgramItemData());
        data.setVolumesOfHours(volumesOfHours);
    }

    public Groups getGroups(String programItemId) {
        return Optional.of(programItemId).map(this._costData::get).map(ProgramItemData::getGroups).orElse(null);
    }

    public void putGroups(String programItemId, Groups groups) {
        ProgramItemData data = this._costData.computeIfAbsent(programItemId, __ -> new ProgramItemData());
        data.setGroups(groups);
    }

    public EqTD getEqTD(String programItemId) {
        return Optional.of(programItemId).map(this._costData::get).map(ProgramItemData::getEqTD).orElse(null);
    }

    public void putEqTD(String programItemId, EqTD eqTD) {
        ProgramItemData data = this._costData.computeIfAbsent(programItemId, __ -> new ProgramItemData());
        data.setEqTD(eqTD);
    }

    public boolean isCoursePart(String programItemId) {
        return Optional.of(programItemId).map(this._costData::get).map(ProgramItemData::isCoursePart).orElse(false);
    }

    public void setIsCoursePart(String programItemId, boolean isCoursePart) {
        ProgramItemData data = this._costData.computeIfAbsent(programItemId, __ -> new ProgramItemData());
        data.setIsCoursePart(isCoursePart);
    }

    public NormDetails getNormDetails(String programItemId) {
        return Optional.of(programItemId).map(this._costData::get).map(ProgramItemData::getNormDetails).orElse(null);
    }

    public void putNormDetails(String programItemId, NormDetails normDetails) {
        ProgramItemData data = this._costData.computeIfAbsent(programItemId, __ -> new ProgramItemData());
        data.setNormDetails(normDetails);
    }

    public Long getOverriddenEffective(String programItemId) {
        return this._overriddenData.getEffective(programItemId);
    }

    public Long getOverriddenGroups(String programItemId) {
        return this._overriddenData.getNumberOfGroups(programItemId);
    }

    public Double getOverriddenVolumeOfHours(String programItemId) {
        return this._overriddenData.getVolumeOfHours(programItemId);
    }
}

