/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.helper;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableDefaultContent;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractWorkflowHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    protected static final String __AUTHOR_SUFFIX = "_author";
    protected static final String __DATE_SUFFIX = "_date";
    protected static final String __COMMENT_SUFFIX = "_comment";
    protected ODFHelper _odfHelper;
    protected PilotageHelper _pilotageHelper;
    protected AmetysObjectResolver _resolver;
    protected RightManager _rightManager;
    protected ObservationManager _observationManager;
    protected CurrentUserProvider _currentUserProvider;
    protected AbstractCacheManager _cacheManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._odfHelper = (ODFHelper)manager.lookup(ODFHelper.ROLE);
        this._pilotageHelper = (PilotageHelper)((Object)manager.lookup(PilotageHelper.ROLE));
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
    }

    protected ODFWorkflowStep getWorkflowStep(ModelAwareDataHolder workflowHolder, String prefixAttributeName, String stepId) {
        if (workflowHolder.hasValue(prefixAttributeName + __DATE_SUFFIX)) {
            UserIdentity author = (UserIdentity)workflowHolder.getValue(prefixAttributeName + __AUTHOR_SUFFIX);
            LocalDate date = (LocalDate)workflowHolder.getValue(prefixAttributeName + __DATE_SUFFIX);
            String comment = (String)workflowHolder.getValue(prefixAttributeName + __COMMENT_SUFFIX, false, (Object)"");
            return new ODFWorkflowStep(stepId, date, author, comment);
        }
        return null;
    }

    protected LocalDate getWorkflowStepDate(ModelAwareDataHolder workflowHolder, String prefixAttributeName) {
        return (LocalDate)workflowHolder.getValue(prefixAttributeName + __DATE_SUFFIX, false, null);
    }

    protected void setWorkflowStep(ModifiableDefaultContent content, ModifiableModelAwareDataHolder workflowHolder, String prefixAttributeName, LocalDate date, UserIdentity user, String comment) {
        workflowHolder.setValue(prefixAttributeName + __DATE_SUFFIX, (Object)date);
        workflowHolder.setValue(prefixAttributeName + __AUTHOR_SUFFIX, (Object)user);
        workflowHolder.setValue(prefixAttributeName + __COMMENT_SUFFIX, (Object)comment);
    }

    protected void removeWorkflowStep(ModifiableDefaultContent content, ModifiableModelAwareDataHolder dataHolder, String prefixAttributeName) {
        dataHolder.removeValue(prefixAttributeName + __DATE_SUFFIX);
        dataHolder.removeValue(prefixAttributeName + __AUTHOR_SUFFIX);
        dataHolder.removeValue(prefixAttributeName + __COMMENT_SUFFIX);
    }

    protected Set<Program> _getParentPrograms(ProgramItem programItem) {
        if (programItem instanceof Program) {
            Program program = (Program)programItem;
            return Set.of(program);
        }
        Pair<PilotageHelper.StepHolderStatus, Container> stepHolder = this._pilotageHelper.getStepHolder(programItem);
        switch ((PilotageHelper.StepHolderStatus)((Object)stepHolder.getLeft())) {
            case SINGLE: {
                return this._odfHelper.getParentPrograms((ProgramItem)stepHolder.getRight());
            }
        }
        return this._odfHelper.getParentPrograms(programItem);
    }

    protected Set<Program> _getParentPrograms(CoursePart coursePart) {
        HashSet<Program> programs = new HashSet<Program>();
        for (Course course : coursePart.getCourses()) {
            programs.addAll(this._getParentPrograms((ProgramItem)course));
        }
        return programs;
    }

    protected Set<Container> _getParentYearContainers(ProgramItem programItem) {
        Pair<PilotageHelper.StepHolderStatus, Container> stepHolder = this._pilotageHelper.getStepHolder(programItem);
        switch ((PilotageHelper.StepHolderStatus)((Object)stepHolder.getLeft())) {
            case SINGLE: {
                return Set.of((Container)stepHolder.getRight());
            }
            case MULTIPLE: {
                return this._pilotageHelper.getParentYears(programItem);
            }
        }
        return Set.of();
    }

    protected Set<Container> _getParentYearContainers(CoursePart coursePart) {
        HashSet<Container> containers = new HashSet<Container>();
        for (Course course : coursePart.getCourses()) {
            containers.addAll(this._getParentYearContainers((ProgramItem)course));
        }
        return containers;
    }

    protected boolean saveContentAndNotify(ModifiableDefaultContent content) {
        boolean hasChanges = this.saveContent(content);
        if (hasChanges) {
            this._notifyWorkflowModification((Content)content);
        }
        return hasChanges;
    }

    protected boolean saveContent(ModifiableDefaultContent content) {
        if (content.needsSave()) {
            boolean currentVersionIsLive = ArrayUtils.contains((Object[])content.getLabels(), (Object)"Live");
            content.saveChanges();
            content.checkpoint();
            if (currentVersionIsLive) {
                content.addLabel("Live", true);
            }
            return true;
        }
        return false;
    }

    protected void _notifyWorkflowModification(Content content) {
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("content", content);
        eventParams.put("content.id", content.getId());
        this._observationManager.notify(new Event("content.modified", this._currentUserProvider.getUser(), eventParams));
    }

    public record ODFWorkflowStep(String id, LocalDate date, UserIdentity author, String comment) {
    }
}

