/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.helper;

import jakarta.mail.MessagingException;
import java.io.IOException;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.data.holder.group.ModifiableIndexableComposite;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableDefaultContent;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.core.cache.Cache;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.language.UserLanguagesManager;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.helper.AbstractWorkflowHelper;
import org.ametys.plugins.odfpilotage.helper.MCCWorkflowException;
import org.ametys.plugins.odfpilotage.rule.RulesManager;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MCCWorkflowHelper
extends AbstractWorkflowHelper
implements Initializable {
    public static final String ROLE = MCCWorkflowHelper.class.getName();
    public static final String RULES_VALIDATED_SUPER_RIGHT_ID = "ODF_Pilotage_Rules_Validated_Super_Rights";
    public static final String MCC_VALIDATED_SUPER_RIGHT_ID = "ODF_Pilotage_MCC_Validated_Super_Rights";
    public static final String MCC_ORGUNIT_CONTROLLED_SUPER_RIGHT_ID = "ODF_Pilotage_MCC_Orgunit_Controlled_Super_Rights";
    public static final String MCC_ORGUNIT_VALIDATED_SUPER_RIGHT_ID = "ODF_Pilotage_MCC_Orgunit_Validated_Super_Rights";
    public static final String MCC_CFVU_CONTROLLED_SUPER_RIGHT_ID = "ODF_Pilotage_MCC_CFVU_Controlled_Super_Rights";
    public static final String MCC_CFVU_VALIDATED_SUPER_RIGHT_ID = "ODF_Pilotage_MCC_CFVU_Validated_Super_Rights";
    public static final String MCC_VALIDATED_PDF_REPEATER = "mcc-validated-pdf";
    public static final Integer MCC_WORKFLOW_ACTION_ID = 222222;
    private static final String __MCC_WORKFLOW_COMPOSITE = "mcc_workflow";
    private static final String __STATUS_SUFFIX = "_status";
    private static final String __MCC_VALIDATION_PREFIX = "mcc_validation";
    private static final String __RULES_VALIDATION_PREFIX = "rules_validation";
    private static final String __MCC_ORGUNIT_CONTROL_PREFIX = "mcc_orgunit_control";
    private static final String __MCC_ORGUNIT_VALIDATION_PREFIX = "mcc_orgunit_validation";
    private static final String __MCC_CFVU_CONTROL_PREFIX = "cfvu_mcc_control";
    private static final String __MCC_CFVU_VALIDATION_PREFIX = "cfvu_mcc_validation";
    private static final String __PARENT_CONTAINERS_WITH_HIGHER_STATUS_CACHE_ID = MCCWorkflowHelper.class.getName() + "$parentContainers";
    private static final String __PARENT_CONTAINERS_WITH_HIGHER_RULES_STATUS_CACHE_ID = MCCWorkflowHelper.class.getName() + "$parentContainersForRules";
    private static final String __PARENT_CONTAINERS_WITH_HIGHER_MCC_STATUS_CACHE_ID = MCCWorkflowHelper.class.getName() + "$parentContainersForMCC";
    protected ContentWorkflowHelper _contentWorkflowHelper;
    protected UserManager _userManager;
    protected ContentHelper _contentHelper;
    protected I18nUtils _i18nUtils;
    protected UserLanguagesManager _userLanguagesManager;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._contentWorkflowHelper = (ContentWorkflowHelper)manager.lookup(ContentWorkflowHelper.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._contentHelper = (ContentHelper)manager.lookup(ContentHelper.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._userLanguagesManager = (UserLanguagesManager)manager.lookup(UserLanguagesManager.ROLE);
    }

    public void initialize() throws Exception {
        this._cacheManager.createRequestCache(__PARENT_CONTAINERS_WITH_HIGHER_STATUS_CACHE_ID, new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_CONTAINER_WITH_HIGHER_MCC_CFVU_STATUS_LABEL"), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_CONTAINER_WITH_HIGHER_MCC_CFVU_STATUS_DESCRIPTION"), true);
        this._cacheManager.createRequestCache(__PARENT_CONTAINERS_WITH_HIGHER_RULES_STATUS_CACHE_ID, new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_CONTAINER_WITH_HIGHER_MCC_RULES_STATUS_LABEL"), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_CONTAINER_WITH_HIGHER_MCC_RULES_STATUS_DESCRIPTION"), true);
        this._cacheManager.createRequestCache(__PARENT_CONTAINERS_WITH_HIGHER_MCC_STATUS_CACHE_ID, new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_CONTAINER_WITH_HIGHER_MCC_STATUS_LABEL"), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_CONTAINER_WITH_HIGHER_MCC_STATUS_DESCRIPTION"), true);
    }

    private Cache<String, String> _getContainerParentsCache() {
        return this._cacheManager.get(__PARENT_CONTAINERS_WITH_HIGHER_STATUS_CACHE_ID);
    }

    private Cache<String, String> _getContainerParentsCacheForRules() {
        return this._cacheManager.get(__PARENT_CONTAINERS_WITH_HIGHER_RULES_STATUS_CACHE_ID);
    }

    private Cache<String, String> _getContainerParentsCacheForMCC() {
        return this._cacheManager.get(__PARENT_CONTAINERS_WITH_HIGHER_MCC_STATUS_CACHE_ID);
    }

    public void invalidateAllCaches() {
        this._cacheManager.get(__PARENT_CONTAINERS_WITH_HIGHER_STATUS_CACHE_ID).invalidateAll();
        this._cacheManager.get(__PARENT_CONTAINERS_WITH_HIGHER_RULES_STATUS_CACHE_ID).invalidateAll();
        this._cacheManager.get(__PARENT_CONTAINERS_WITH_HIGHER_MCC_STATUS_CACHE_ID).invalidateAll();
    }

    public boolean isAvailableAction(Container container, MCCWorkflowAction workflowAction) {
        return this.isAvailableAction(container, workflowAction, true);
    }

    public boolean isAvailableAction(Container container, MCCWorkflowAction workflowAction, boolean checkStructure) {
        boolean available = false;
        boolean needDataCheck = !this._isRevertAction(workflowAction);
        HashMap<String, Boolean> inputs = new HashMap<String, Boolean>();
        if (!checkStructure || workflowAction == MCCWorkflowAction.VALIDATE_RULES) {
            inputs.put("checkTree", false);
        }
        List<MCCWorkflowStep> currentSteps = this.getCurrentSteps(container);
        switch (workflowAction.ordinal()) {
            case 11: {
                available = currentSteps.contains((Object)MCCWorkflowStep.MCC_CFVU_VALIDATED);
                break;
            }
            case 9: 
            case 10: {
                available = currentSteps.contains((Object)MCCWorkflowStep.MCC_CFVU_CONTROLLED);
                break;
            }
            case 7: 
            case 8: {
                available = currentSteps.contains((Object)MCCWorkflowStep.MCC_ORGUNIT_VALIDATED);
                break;
            }
            case 5: 
            case 6: {
                available = currentSteps.contains((Object)MCCWorkflowStep.MCC_ORGUNIT_CONTROLLED);
                break;
            }
            case 4: {
                available = currentSteps.contains((Object)MCCWorkflowStep.MCC_VALIDATED) && (!RulesManager.isRulesEnabled() || currentSteps.contains((Object)MCCWorkflowStep.RULES_VALIDATED));
                break;
            }
            case 2: {
                available = currentSteps.contains((Object)MCCWorkflowStep.DRAFT) && !currentSteps.contains((Object)MCCWorkflowStep.MCC_VALIDATED);
                break;
            }
            case 3: {
                available = currentSteps.contains((Object)MCCWorkflowStep.MCC_VALIDATED);
                break;
            }
            case 0: {
                available = currentSteps.contains((Object)MCCWorkflowStep.DRAFT) && !currentSteps.contains((Object)MCCWorkflowStep.RULES_VALIDATED);
                break;
            }
            case 1: {
                available = currentSteps.contains((Object)MCCWorkflowStep.RULES_VALIDATED);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value for MCC workflow action : " + String.valueOf((Object)workflowAction));
            }
        }
        if (needDataCheck && available) {
            return this._contentWorkflowHelper.isAvailableAction((WorkflowAwareContent)container, MCC_WORKFLOW_ACTION_ID.intValue(), inputs);
        }
        return available;
    }

    private boolean _isRevertAction(MCCWorkflowAction workflowAction) {
        switch (workflowAction.ordinal()) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public boolean isStepValid(Container container, MCCWorkflowStep mccWorkflowStep) {
        switch (mccWorkflowStep.ordinal()) {
            case 1: {
                return this.isRulesValidated(container);
            }
            case 2: {
                return this.isMCCValidated(container);
            }
            case 3: {
                return this.isMCCOrgUnitControlled(container);
            }
            case 4: {
                return this.isMCCOrgUnitValidated(container);
            }
            case 5: {
                return this.isMCCCFVUControlled(container);
            }
            case 6: {
                return this.isMCCCFVUValidated(container);
            }
            case 0: {
                return !this.isMCCOrgUnitControlled(container);
            }
        }
        throw new IllegalArgumentException("Unexpected value for MCC workflow step: " + String.valueOf((Object)mccWorkflowStep));
    }

    public List<MCCWorkflowStep> getCurrentSteps(Container container) {
        if (this.isMCCCFVUValidated(container)) {
            return List.of(MCCWorkflowStep.MCC_CFVU_VALIDATED);
        }
        if (this.isMCCCFVUControlled(container)) {
            return List.of(MCCWorkflowStep.MCC_CFVU_CONTROLLED);
        }
        if (this.isMCCOrgUnitValidated(container)) {
            return List.of(MCCWorkflowStep.MCC_ORGUNIT_VALIDATED);
        }
        if (this.isMCCOrgUnitControlled(container)) {
            return List.of(MCCWorkflowStep.MCC_ORGUNIT_CONTROLLED);
        }
        boolean mccValidated = this.isMCCValidated(container);
        boolean rulesValidated = this.isRulesValidated(container);
        boolean draft = !mccValidated || RulesManager.isRulesEnabled() && !rulesValidated;
        ArrayList<MCCWorkflowStep> currentSteps = new ArrayList<MCCWorkflowStep>();
        if (draft) {
            currentSteps.add(MCCWorkflowStep.DRAFT);
        }
        if (mccValidated) {
            currentSteps.add(MCCWorkflowStep.MCC_VALIDATED);
        }
        if (RulesManager.isRulesEnabled() && rulesValidated) {
            currentSteps.add(MCCWorkflowStep.RULES_VALIDATED);
        }
        return currentSteps;
    }

    public Container getParentContainerWithHigherMCCStatus(ProgramItem programItem) {
        Cache<String, String> cache = this._getContainerParentsCache();
        if (cache.hasKey((Object)programItem.getId())) {
            String parentId = (String)cache.get((Object)programItem.getId());
            return parentId != null ? (Container)this._resolver.resolveById(parentId) : null;
        }
        Container parentContainer = this._computeParentContainerWithHigherMCCStatus(programItem);
        cache.put((Object)programItem.getId(), (Object)(parentContainer != null ? parentContainer.getId() : null));
        return parentContainer;
    }

    private Container _computeParentContainerWithHigherMCCStatus(ProgramItem programItem) {
        Set<Container> parentContainers = this._getParentYearContainers(programItem);
        return parentContainers.stream().sorted(new MCCStatusComparator().reversed()).findFirst().orElse(null);
    }

    public Container getParentContainerWithHigherMCCStatus(CoursePart coursePart) {
        Cache<String, String> cache = this._getContainerParentsCache();
        if (cache.hasKey((Object)coursePart.getId())) {
            String parentId = (String)cache.get((Object)coursePart.getId());
            return parentId != null ? (Container)this._resolver.resolveById(parentId) : null;
        }
        Container parentContainer = this._computeParentContainerWithHigherMCCStatus(coursePart);
        cache.put((Object)coursePart.getId(), (Object)(parentContainer != null ? parentContainer.getId() : null));
        return parentContainer;
    }

    private Container _computeParentContainerWithHigherMCCStatus(CoursePart coursePart) {
        Set<Container> parentPrograms = this._getParentYearContainers(coursePart);
        return parentPrograms.stream().sorted(new MCCStatusComparator().reversed()).findFirst().orElse(null);
    }

    public Container getParentContainerWithHigherMCCStatusForRules(ProgramItem programItem) {
        Cache<String, String> cache = this._getContainerParentsCacheForRules();
        if (cache.hasKey((Object)programItem.getId())) {
            String parentId = (String)cache.get((Object)programItem.getId());
            return parentId != null ? (Container)this._resolver.resolveById(parentId) : null;
        }
        Container container = this._computeParentContainerWithHigherMCCStatusForRules(programItem);
        cache.put((Object)programItem.getId(), (Object)(container != null ? container.getId() : null));
        return container;
    }

    private Container _computeParentContainerWithHigherMCCStatusForRules(ProgramItem programItem) {
        Set<Container> yearContainers = this._getParentYearContainers(programItem);
        return yearContainers.stream().sorted(new ContainerMCCRulesStatusComparator().reversed()).findFirst().orElse(null);
    }

    public Container getParentContainerWithHigherMCCStatusForRules(CoursePart coursePart) {
        Cache<String, String> cache = this._getContainerParentsCacheForRules();
        if (cache.hasKey((Object)coursePart.getId())) {
            String parentId = (String)cache.get((Object)coursePart.getId());
            return parentId != null ? (Container)this._resolver.resolveById(parentId) : null;
        }
        Container container = this._computeParentContainerWithHigherMCCStatusForRules(coursePart);
        cache.put((Object)coursePart.getId(), (Object)(container != null ? container.getId() : null));
        return container;
    }

    private Container _computeParentContainerWithHigherMCCStatusForRules(CoursePart coursePart) {
        Set<Container> yearContainers = this._getParentYearContainers(coursePart);
        return yearContainers.stream().sorted(new ContainerMCCRulesStatusComparator().reversed()).findFirst().orElse(null);
    }

    public Container getParentContainerWithHigherMCCStatusForMCCFields(ProgramItem programItem) {
        Cache<String, String> cache = this._getContainerParentsCacheForMCC();
        if (cache.hasKey((Object)programItem.getId())) {
            String parentId = (String)cache.get((Object)programItem.getId());
            return parentId != null ? (Container)this._resolver.resolveById(parentId) : null;
        }
        Container container = this._computeParentContainerWithHigherMCCStatusForMCCFields(programItem);
        cache.put((Object)programItem.getId(), (Object)(container != null ? container.getId() : null));
        return container;
    }

    private Container _computeParentContainerWithHigherMCCStatusForMCCFields(ProgramItem programItem) {
        Set<Container> yearContainers = this._getParentYearContainers(programItem);
        return yearContainers.stream().sorted(new ContainerMCCFieldsStatusComparator().reversed()).findFirst().orElse(null);
    }

    public Container getParentContainerWithHigherMCCStatusForMCCFields(CoursePart coursePart) {
        Cache<String, String> cache = this._getContainerParentsCacheForMCC();
        if (cache.hasKey((Object)coursePart.getId())) {
            String parentId = (String)cache.get((Object)coursePart.getId());
            return parentId != null ? (Container)this._resolver.resolveById(parentId) : null;
        }
        Container container = this._computeParentContainerWithHigherMCCStatusForMCCFields(coursePart);
        cache.put((Object)coursePart.getId(), (Object)(container != null ? container.getId() : null));
        return container;
    }

    private Container _computeParentContainerWithHigherMCCStatusForMCCFields(CoursePart coursePart) {
        Set<Container> yearContainers = this._getParentYearContainers(coursePart);
        return yearContainers.stream().sorted(new ContainerMCCFieldsStatusComparator().reversed()).findFirst().orElse(null);
    }

    public boolean validateMCCForOrgunit(Container container, LocalDate date, UserIdentity user, String comment) {
        if (!this._odfHelper.isContainerOfTypeYear(container)) {
            throw new MCCWorkflowException("Can not update MCC status on a container that is not of type year: " + String.valueOf(container), MCCWorkflowException.ExceptionType.NOT_TYPE_YEAR);
        }
        if (!this.isAvailableAction(container, MCCWorkflowAction.VALIDATE_ORGUNIT)) {
            throw new MCCWorkflowException("MCC can not be validated to orgunit level as current MCC status does not allow to perform this action " + String.valueOf(container), MCCWorkflowException.ExceptionType.UNAVAILABLE_ACTION);
        }
        return this._setMCCStatus(container, __MCC_ORGUNIT_VALIDATION_PREFIX, date, user, comment);
    }

    public boolean refuseCFVUControl(Container container, UserIdentity user, boolean notify, String comment, boolean reset) throws MCCWorkflowException {
        if (!this._odfHelper.isContainerOfTypeYear(container)) {
            throw new MCCWorkflowException("Can not update MCC status on a container that is not of type year: " + String.valueOf(container), MCCWorkflowException.ExceptionType.NOT_TYPE_YEAR);
        }
        if (!this.isAvailableAction(container, MCCWorkflowAction.REFUSE_CONTROL_CFVU)) {
            throw new MCCWorkflowException("MCC can not be invalidate to orgunit level as current MCC statut does not allow to perform action for container " + String.valueOf(container), MCCWorkflowException.ExceptionType.UNAVAILABLE_ACTION);
        }
        if (notify) {
            ArrayList<UserIdentity> recipients = new ArrayList<UserIdentity>();
            Optional.of(this.getMCCOrgunitValidationStep(container)).ifPresent(s -> recipients.add(s.author()));
            if (reset) {
                Optional.of(this.getMCCOrgunitControlStep(container)).ifPresent(s -> recipients.add(s.author()));
                Optional.of(this.getMCCMentionValidationStep(container)).ifPresent(s -> recipients.add(s.author()));
                if (RulesManager.isRulesEnabled()) {
                    recipients.add(this.getRulesMentionValidationStep(container).author());
                }
            }
            this._notifyContributor(container, user, MCCWorkflowAction.REFUSE_CONTROL_CFVU, recipients, comment);
        }
        return reset ? this.removeMCCWorkflow(container) : this._removeMCCStatus(container, __MCC_ORGUNIT_VALIDATION_PREFIX);
    }

    public boolean isMCCOrgUnitValidated(Container container) {
        return this._getMCCStatus(container, __MCC_ORGUNIT_VALIDATION_PREFIX);
    }

    public boolean controlMCCForOrgunit(Container container, LocalDate date, UserIdentity user, String comment) {
        if (!this._odfHelper.isContainerOfTypeYear(container)) {
            throw new MCCWorkflowException("Can not update MCC status on a container that is not of type year: " + String.valueOf(container), MCCWorkflowException.ExceptionType.NOT_TYPE_YEAR);
        }
        if (!this.isAvailableAction(container, MCCWorkflowAction.CONTROL_ORGUNIT)) {
            throw new MCCWorkflowException("MCC can not be controlled to orgunit level as current MCC status does not allow to perform this action " + String.valueOf(container), MCCWorkflowException.ExceptionType.UNAVAILABLE_ACTION);
        }
        return this._setMCCStatus(container, __MCC_ORGUNIT_CONTROL_PREFIX, date, user, comment);
    }

    public boolean refuseOrgunitValidation(Container container, UserIdentity user, boolean notify, String comment, boolean reset) throws MCCWorkflowException {
        if (!this._odfHelper.isContainerOfTypeYear(container)) {
            throw new MCCWorkflowException("Can not update MCC status on a container that is not of type year: " + String.valueOf(container), MCCWorkflowException.ExceptionType.NOT_TYPE_YEAR);
        }
        if (!this.isAvailableAction(container, MCCWorkflowAction.REFUSE_VALIDATION_ORGUNIT)) {
            throw new MCCWorkflowException("Can not refuse orgunit validation as MCC status does not allow to perform this action " + String.valueOf(container), MCCWorkflowException.ExceptionType.UNAVAILABLE_ACTION);
        }
        if (notify) {
            ArrayList<UserIdentity> recipients = new ArrayList<UserIdentity>();
            Optional.of(this.getMCCOrgunitControlStep(container)).ifPresent(s -> recipients.add(s.author()));
            if (reset) {
                Optional.of(this.getMCCMentionValidationStep(container)).ifPresent(s -> recipients.add(s.author()));
                if (RulesManager.isRulesEnabled()) {
                    Optional.of(this.getRulesMentionValidationStep(container)).ifPresent(s -> recipients.add(s.author()));
                }
            }
            this._notifyContributor(container, user, MCCWorkflowAction.REFUSE_VALIDATION_ORGUNIT, recipients, comment);
        }
        return reset ? this.removeMCCWorkflow(container) : this._removeMCCStatus(container, __MCC_ORGUNIT_CONTROL_PREFIX);
    }

    public boolean isMCCOrgUnitControlled(Container container) {
        return this._getMCCStatus(container, __MCC_ORGUNIT_CONTROL_PREFIX);
    }

    public boolean validateMCC(Container container, LocalDate date, UserIdentity user, String comment) {
        if (!this._odfHelper.isContainerOfTypeYear(container)) {
            throw new MCCWorkflowException("Can not update MCC status on a container that is not of type year: " + String.valueOf(container), MCCWorkflowException.ExceptionType.NOT_TYPE_YEAR);
        }
        if (!this.isAvailableAction(container, MCCWorkflowAction.VALIDATE_MCC)) {
            throw new MCCWorkflowException("MCC can not be validate as current MCC status does not allow to perform the action or container data or structure are not valid for " + String.valueOf(container), MCCWorkflowException.ExceptionType.UNAVAILABLE_ACTION);
        }
        return this._setMCCStatus(container, __MCC_VALIDATION_PREFIX, date, user, comment);
    }

    public boolean refuseMCCOrgunitControl(Container container, UserIdentity user, boolean notify, String comment, boolean reset) throws MCCWorkflowException {
        if (!this._odfHelper.isContainerOfTypeYear(container)) {
            throw new MCCWorkflowException("Can not update MCC status on a container that is not of type year: " + String.valueOf(container), MCCWorkflowException.ExceptionType.NOT_TYPE_YEAR);
        }
        if (!this.isAvailableAction(container, MCCWorkflowAction.REFUSE_MCC_ORGUNIT_CONTROL)) {
            throw new MCCWorkflowException("MCC can not be invalidate as current MCC status does not allow to perform the action " + String.valueOf(container), MCCWorkflowException.ExceptionType.UNAVAILABLE_ACTION);
        }
        if (notify) {
            ArrayList<UserIdentity> recipients = new ArrayList<UserIdentity>();
            Optional.of(this.getMCCMentionValidationStep(container)).ifPresent(s -> recipients.add(s.author()));
            if (reset && RulesManager.isRulesEnabled()) {
                Optional.of(this.getRulesMentionValidationStep(container)).ifPresent(s -> recipients.add(s.author()));
            }
            this._notifyContributor(container, user, MCCWorkflowAction.REFUSE_MCC_ORGUNIT_CONTROL, recipients, comment);
        }
        return reset ? this.removeMCCWorkflow(container) : this._removeMCCStatus(container, __MCC_VALIDATION_PREFIX);
    }

    public boolean isMCCValidated(Container container) {
        return this._getMCCStatus(container, __MCC_VALIDATION_PREFIX);
    }

    public boolean validateRules(Container container, LocalDate date, UserIdentity user, String comment) {
        if (!this._odfHelper.isContainerOfTypeYear(container)) {
            throw new MCCWorkflowException("Can not update MCC status on a container that is not of type year: " + String.valueOf(container), MCCWorkflowException.ExceptionType.NOT_TYPE_YEAR);
        }
        if (!this.isAvailableAction(container, MCCWorkflowAction.VALIDATE_RULES)) {
            throw new MCCWorkflowException("Rule can not be validated as current MCC status does not allow to perform this action " + String.valueOf(container), MCCWorkflowException.ExceptionType.UNAVAILABLE_ACTION);
        }
        return this._setMCCStatus(container, __RULES_VALIDATION_PREFIX, date, user, comment);
    }

    public boolean refuseRulesOrgUnitControl(Container container, UserIdentity user, boolean notify, String comment, boolean reset) throws MCCWorkflowException {
        if (!this._odfHelper.isContainerOfTypeYear(container)) {
            throw new MCCWorkflowException("Can not update MCC status on a container that is not of type year: " + String.valueOf(container), MCCWorkflowException.ExceptionType.NOT_TYPE_YEAR);
        }
        if (!this.isAvailableAction(container, MCCWorkflowAction.REFUSE_RULES_ORGUNIT_CONTROL)) {
            throw new MCCWorkflowException("Rule can not be invalidated as current MCC status does not allow to perform this action " + String.valueOf(container), MCCWorkflowException.ExceptionType.UNAVAILABLE_ACTION);
        }
        if (notify) {
            ArrayList<UserIdentity> recipients = new ArrayList<UserIdentity>();
            Optional.of(this.getRulesMentionValidationStep(container)).ifPresent(s -> recipients.add(s.author()));
            if (reset) {
                Optional.of(this.getMCCMentionValidationStep(container)).ifPresent(s -> recipients.add(s.author()));
            }
            this._notifyContributor(container, user, MCCWorkflowAction.REFUSE_RULES_ORGUNIT_CONTROL, recipients, comment);
        }
        return reset ? this.removeMCCWorkflow(container) : this._removeMCCStatus(container, __RULES_VALIDATION_PREFIX);
    }

    public boolean isRulesValidated(Container container) {
        return this._getMCCStatus(container, __RULES_VALIDATION_PREFIX);
    }

    public boolean isMCCCFVUControlled(Container container) {
        return this._getMCCStatus(container, __MCC_CFVU_CONTROL_PREFIX);
    }

    public boolean isMCCCFVUValidated(Container container) {
        return this._getMCCStatus(container, __MCC_CFVU_VALIDATION_PREFIX);
    }

    public boolean controlMCCForCVFU(Container container, LocalDate validationDate, UserIdentity user, String comment) {
        if (!this._odfHelper.isContainerOfTypeYear(container)) {
            throw new MCCWorkflowException("Can not update MCC status on a container that is not of type year: " + String.valueOf(container), MCCWorkflowException.ExceptionType.NOT_TYPE_YEAR);
        }
        if (!this.isAvailableAction(container, MCCWorkflowAction.CONTROL_CFVU)) {
            throw new MCCWorkflowException("MCC can not be CFVU controlled as current MCC status does not allow to perform this action " + String.valueOf(container), MCCWorkflowException.ExceptionType.UNAVAILABLE_ACTION);
        }
        return this._setMCCStatus(container, __MCC_CFVU_CONTROL_PREFIX, validationDate, user, comment);
    }

    public boolean refuseCFVUValidation(Container container, UserIdentity user, boolean notify, String comment, boolean reset) throws MCCWorkflowException {
        if (!this._odfHelper.isContainerOfTypeYear(container)) {
            throw new MCCWorkflowException("Can not update MCC status on a container that is not of type year: " + String.valueOf(container), MCCWorkflowException.ExceptionType.NOT_TYPE_YEAR);
        }
        if (!this.isAvailableAction(container, MCCWorkflowAction.REFUSE_VALIDATION_CFVU)) {
            throw new MCCWorkflowException("Control of MCC can not be invalidate as current MCC status does not allow to perform this action for " + String.valueOf(container), MCCWorkflowException.ExceptionType.UNAVAILABLE_ACTION);
        }
        if (notify) {
            ArrayList<UserIdentity> recipients = new ArrayList<UserIdentity>();
            Optional.of(this.getMCCCFVUControlStep(container)).ifPresent(s -> recipients.add(s.author()));
            if (reset) {
                Optional.of(this.getMCCOrgunitValidationStep(container)).ifPresent(s -> recipients.add(s.author()));
                Optional.of(this.getMCCOrgunitControlStep(container)).ifPresent(s -> recipients.add(s.author()));
                Optional.of(this.getMCCMentionValidationStep(container)).ifPresent(s -> recipients.add(s.author()));
                if (RulesManager.isRulesEnabled()) {
                    Optional.of(this.getRulesMentionValidationStep(container)).ifPresent(s -> recipients.add(s.author()));
                }
            }
            this._notifyContributor(container, user, MCCWorkflowAction.REFUSE_VALIDATION_CFVU, recipients, comment);
        }
        return reset ? this.removeMCCWorkflow(container) : this._removeMCCStatus(container, __MCC_CFVU_CONTROL_PREFIX);
    }

    public LocalDate getMinDateForMCCOrgUnitControl(Container container) {
        LocalDate rulesMentionDate;
        if (!this.isMCCValidated(container) || RulesManager.isRulesEnabled() && !this.isRulesValidated(container)) {
            throw new MCCWorkflowException("MCC current status does not allow to control MCC to orgunit level");
        }
        ModifiableIndexableComposite composite = container.getComposite(__MCC_WORKFLOW_COMPOSITE);
        LocalDate mccMentionDate = (LocalDate)composite.getValue("mcc_validation_date");
        LocalDate localDate = rulesMentionDate = RulesManager.isRulesEnabled() ? (LocalDate)composite.getValue("rules_validation_date") : null;
        return rulesMentionDate == null ? mccMentionDate : (mccMentionDate.compareTo(rulesMentionDate) > 0 ? mccMentionDate : rulesMentionDate);
    }

    public LocalDate getMinDateForMCCOrgUnitValidation(Container container) {
        if (!this.isMCCOrgUnitControlled(container)) {
            throw new MCCWorkflowException("MCC current status does not allow to validate MCC to orgunit level");
        }
        ModifiableIndexableComposite composite = container.getComposite(__MCC_WORKFLOW_COMPOSITE);
        return (LocalDate)composite.getValue("mcc_orgunit_control_date");
    }

    public LocalDate getMinDateForMCCCFVUControl(Container container) {
        if (!this.isMCCOrgUnitValidated(container)) {
            throw new MCCWorkflowException("MCC current status does not allow to control MCC to CFVU level");
        }
        ModifiableIndexableComposite composite = container.getComposite(__MCC_WORKFLOW_COMPOSITE);
        return (LocalDate)composite.getValue("mcc_orgunit_validation_date");
    }

    public LocalDate getMinDateForMCCCFVUValidation(Container container) {
        if (!this.isMCCCFVUControlled(container)) {
            throw new MCCWorkflowException("MCC current status does not allow to validate MCC to CFVU level");
        }
        ModifiableIndexableComposite composite = container.getComposite(__MCC_WORKFLOW_COMPOSITE);
        return (LocalDate)composite.getValue("cfvu_mcc_control_date");
    }

    public LocalDate getMCCCFVUValidationDate(Container container) {
        ModifiableIndexableComposite composite = container.getComposite(__MCC_WORKFLOW_COMPOSITE);
        return (LocalDate)composite.getValue("cfvu_mcc_validation_date");
    }

    public boolean validateMCCForCVFU(Container container, LocalDate validationDate, UserIdentity user, String comment) {
        if (!this._odfHelper.isContainerOfTypeYear(container)) {
            throw new MCCWorkflowException("Can not update MCC status on a container that is not of type year: " + String.valueOf(container), MCCWorkflowException.ExceptionType.NOT_TYPE_YEAR);
        }
        if (!this.isAvailableAction(container, MCCWorkflowAction.VALIDATE_CFVU)) {
            throw new MCCWorkflowException("MCC can not be validated to CFVU level as current MCC status does not allow to perform this action " + String.valueOf(container), MCCWorkflowException.ExceptionType.UNAVAILABLE_ACTION);
        }
        return this._setMCCStatus(container, __MCC_CFVU_VALIDATION_PREFIX, validationDate, user, comment);
    }

    public boolean invalidateMCCForCVFU(Container container, UserIdentity user, boolean notify, String comment, boolean reset) {
        if (!this._odfHelper.isContainerOfTypeYear(container)) {
            throw new MCCWorkflowException("Can not update MCC status on a container that is not of type year: " + String.valueOf(container), MCCWorkflowException.ExceptionType.NOT_TYPE_YEAR);
        }
        if (!this.isAvailableAction(container, MCCWorkflowAction.INVALIDATE_CFVU)) {
            throw new MCCWorkflowException("MCC can not be invalidated to CFVU level as current MCC status does not allow to perform this action " + String.valueOf(container), MCCWorkflowException.ExceptionType.UNAVAILABLE_ACTION);
        }
        if (notify) {
            ArrayList<UserIdentity> recipients = new ArrayList<UserIdentity>();
            Optional.of(this.getMCCCFVUControlStep(container)).ifPresent(s -> recipients.add(s.author()));
            if (reset) {
                Optional.of(this.getMCCOrgunitValidationStep(container)).ifPresent(s -> recipients.add(s.author()));
                Optional.of(this.getMCCOrgunitControlStep(container)).ifPresent(s -> recipients.add(s.author()));
                Optional.of(this.getMCCCFVUControlStep(container)).ifPresent(s -> recipients.add(s.author()));
                Optional.of(this.getMCCMentionValidationStep(container)).ifPresent(s -> recipients.add(s.author()));
                if (RulesManager.isRulesEnabled()) {
                    Optional.of(this.getRulesMentionValidationStep(container)).ifPresent(s -> recipients.add(s.author()));
                }
            }
            this._notifyContributor(container, user, MCCWorkflowAction.INVALIDATE_CFVU, recipients, comment);
        }
        return reset ? this.removeMCCWorkflow(container) : this._removeMCCStatus(container, __MCC_CFVU_VALIDATION_PREFIX);
    }

    private void _notifyContributor(Container container, UserIdentity issuer, MCCWorkflowAction revertAction, List<UserIdentity> recipients, String comment) {
        try {
            String defaultLanguage = this._userLanguagesManager.getDefaultLanguage();
            Map emailsByLanguage = recipients.stream().map(arg_0 -> ((UserManager)this._userManager).getUser(arg_0)).filter(Objects::nonNull).map(user -> Pair.of((Object)user.getLanguage(), (Object)user.getEmail())).filter(p -> StringUtils.isNotBlank((CharSequence)((CharSequence)p.getRight()))).collect(Collectors.groupingBy(p -> (String)StringUtils.defaultIfBlank((CharSequence)((String)p.getLeft()), (CharSequence)defaultLanguage), Collectors.mapping(Pair::getRight, Collectors.toSet())));
            if (emailsByLanguage.isEmpty()) {
                return;
            }
            User user2 = this._userManager.getUser(issuer);
            HashMap<String, I18nizableText> i18nParams = new HashMap<String, I18nizableText>();
            i18nParams.put("title", new I18nizableText(container.getTitle()));
            i18nParams.put("code", new I18nizableText(container.getDisplayCode()));
            i18nParams.put("user", new I18nizableText(this._userManager.getUser(issuer).getFullName()));
            I18nizableText i18nSubject = new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_MAIL_SUBJECT_" + revertAction.name(), i18nParams);
            I18nizableText i18nMessage = new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_MAIL_BODY_" + revertAction.name(), i18nParams);
            StandardMailBodyHelper.MailBodyBuilder mailBody = StandardMailBodyHelper.newHTMLBody().withTitle(i18nSubject).withMessage(i18nMessage).withLink(this._contentHelper.getContentBOUrl((Content)container, Map.of()), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_MAIL_BODY_GO_TO_CONTENT"));
            if (StringUtils.isNotEmpty((CharSequence)comment)) {
                StandardMailBodyHelper.MailBodyBuilder.UserInput userInput = new StandardMailBodyHelper.MailBodyBuilder.UserInput(user2, ZonedDateTime.now(), (Object)comment.replaceAll("\r?\n", "<br/>"));
                mailBody.withUserInputs(List.of(userInput));
            }
            for (String userLanguage : emailsByLanguage.keySet()) {
                String subject = this._i18nUtils.translate((I18nizable)i18nSubject, userLanguage);
                String htmlBody = mailBody.withLanguage(userLanguage).build();
                ArrayList emails = new ArrayList(emailsByLanguage.get(userLanguage));
                try {
                    SendMailHelper.newMail().withSubject(subject).withHTMLBody(htmlBody).withSender(user2.getEmail()).withRecipients(emails).withAsync(true).sendMail();
                }
                catch (MessagingException | IOException e) {
                    this.getLogger().warn("Could not send MCC workflow notification mails to " + String.valueOf(emails), e);
                }
            }
        }
        catch (IOException e) {
            this.getLogger().warn("Could not build MCC workflow notification mail", (Throwable)e);
        }
    }

    public boolean removeMCCWorkflow(Container container) {
        container.removeValue(__MCC_WORKFLOW_COMPOSITE);
        return this.saveContent((ModifiableDefaultContent)container);
    }

    public boolean removeMCCValidatedPDF(Container container) {
        container.removeValue(MCC_VALIDATED_PDF_REPEATER);
        return this.saveContent((ModifiableDefaultContent)container);
    }

    private boolean _setMCCStatus(Container container, String prefixAttributeName, LocalDate validationDate, UserIdentity user, String comment) {
        ModifiableIndexableComposite composite = container.getComposite(__MCC_WORKFLOW_COMPOSITE, true);
        composite.setValue(prefixAttributeName + __STATUS_SUFFIX, (Object)true);
        this.setWorkflowStep((ModifiableDefaultContent)container, (ModifiableModelAwareDataHolder)composite, prefixAttributeName, validationDate, user, comment);
        return this.saveContentAndNotify((ModifiableDefaultContent)container);
    }

    private boolean _removeMCCStatus(Container container, String prefixAttributeName) {
        ModifiableIndexableComposite composite = container.getComposite(__MCC_WORKFLOW_COMPOSITE, true);
        composite.setValue(prefixAttributeName + __STATUS_SUFFIX, (Object)false);
        this.removeWorkflowStep((ModifiableDefaultContent)container, (ModifiableModelAwareDataHolder)composite, prefixAttributeName);
        return this.saveContentAndNotify((ModifiableDefaultContent)container);
    }

    private boolean _getMCCStatus(Container container, String attributeName) {
        return (Boolean)container.getValue("mcc_workflow/" + attributeName + __STATUS_SUFFIX, false, (Object)false);
    }

    public AbstractWorkflowHelper.ODFWorkflowStep getRulesMentionValidationStep(Container container) {
        return this._getMCCWorkflowStep(container, MCCWorkflowStep.RULES_VALIDATED, __RULES_VALIDATION_PREFIX);
    }

    public AbstractWorkflowHelper.ODFWorkflowStep getMCCMentionValidationStep(Container container) {
        return this._getMCCWorkflowStep(container, MCCWorkflowStep.MCC_VALIDATED, __MCC_VALIDATION_PREFIX);
    }

    public AbstractWorkflowHelper.ODFWorkflowStep getMCCOrgunitControlStep(Container container) {
        return this._getMCCWorkflowStep(container, MCCWorkflowStep.MCC_ORGUNIT_CONTROLLED, __MCC_ORGUNIT_CONTROL_PREFIX);
    }

    public AbstractWorkflowHelper.ODFWorkflowStep getMCCOrgunitValidationStep(Container container) {
        return this._getMCCWorkflowStep(container, MCCWorkflowStep.MCC_ORGUNIT_VALIDATED, __MCC_ORGUNIT_VALIDATION_PREFIX);
    }

    public AbstractWorkflowHelper.ODFWorkflowStep getMCCCFVUControlStep(Container container) {
        return this._getMCCWorkflowStep(container, MCCWorkflowStep.MCC_CFVU_CONTROLLED, __MCC_CFVU_CONTROL_PREFIX);
    }

    public AbstractWorkflowHelper.ODFWorkflowStep getMCCCFVUValidationStep(Container container) {
        return this._getMCCWorkflowStep(container, MCCWorkflowStep.MCC_CFVU_VALIDATED, __MCC_CFVU_VALIDATION_PREFIX);
    }

    private AbstractWorkflowHelper.ODFWorkflowStep _getMCCWorkflowStep(Container container, MCCWorkflowStep step, String attributeNamePrefix) {
        boolean status;
        if (container.hasValue(__MCC_WORKFLOW_COMPOSITE) && (status = this._getMCCStatus(container, attributeNamePrefix))) {
            ModifiableIndexableComposite composite = container.getComposite(__MCC_WORKFLOW_COMPOSITE);
            return this.getWorkflowStep((ModelAwareDataHolder)composite, attributeNamePrefix, step.name());
        }
        return null;
    }

    public ModelAwareRepeaterEntry getLastMCCValidatedEntry(Container container) {
        return Optional.ofNullable(container.getRepeater(MCC_VALIDATED_PDF_REPEATER)).map(ModelAwareRepeater::getEntries).map(Collection::stream).orElseGet(() -> Stream.of(new ModelAwareRepeaterEntry[0])).filter(e -> e.hasValue("pdf")).max((entry1, entry2) -> ((LocalDate)entry1.getValue("date")).compareTo((ChronoLocalDate)entry2.getValue("date"))).orElse(null);
    }

    public static enum MCCWorkflowAction {
        VALIDATE_RULES,
        REFUSE_RULES_ORGUNIT_CONTROL,
        VALIDATE_MCC,
        REFUSE_MCC_ORGUNIT_CONTROL,
        CONTROL_ORGUNIT,
        REFUSE_VALIDATION_ORGUNIT,
        VALIDATE_ORGUNIT,
        REFUSE_CONTROL_CFVU,
        CONTROL_CFVU,
        REFUSE_VALIDATION_CFVU,
        VALIDATE_CFVU,
        INVALIDATE_CFVU,
        RESET;

    }

    public static enum MCCWorkflowStep {
        DRAFT{

            @Override
            public I18nizableText label() {
                return new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_DRAFT_STEP_LABEL");
            }
        }
        ,
        RULES_VALIDATED{

            @Override
            public I18nizableText label() {
                return new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_RULES_VALIDATE_STEP_LABEL");
            }
        }
        ,
        MCC_VALIDATED{

            @Override
            public I18nizableText label() {
                return new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_MCC_VALIDATE_STEP_LABEL");
            }
        }
        ,
        MCC_ORGUNIT_CONTROLLED{

            @Override
            public I18nizableText label() {
                return new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_ORGUNIT_CONTROL_STEP_LABEL");
            }
        }
        ,
        MCC_ORGUNIT_VALIDATED{

            @Override
            public I18nizableText label() {
                return new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_ORGUNIT_VALIDATION_STEP_LABEL");
            }
        }
        ,
        MCC_CFVU_CONTROLLED{

            @Override
            public I18nizableText label() {
                return new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_CFVU_CONTROL_STEP_LABEL");
            }
        }
        ,
        MCC_CFVU_VALIDATED{

            @Override
            public I18nizableText label() {
                return new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_CFVU_VALIDATE_STEP_LABEL");
            }
        };


        public abstract I18nizableText label();
    }

    private final class MCCStatusComparator
    implements Comparator<Container> {
        private MCCStatusComparator() {
        }

        @Override
        public int compare(Container c1, Container c2) {
            boolean mccValidated1 = MCCWorkflowHelper.this.isMCCCFVUValidated(c1);
            boolean mccValidated2 = MCCWorkflowHelper.this.isMCCCFVUValidated(c2);
            if (mccValidated1) {
                return mccValidated2 ? 0 : 1;
            }
            if (mccValidated2) {
                return -1;
            }
            boolean mccCFVUControlled1 = MCCWorkflowHelper.this.isMCCCFVUControlled(c1);
            boolean mccCFVUControlled2 = MCCWorkflowHelper.this.isMCCCFVUControlled(c2);
            if (mccCFVUControlled1) {
                return mccCFVUControlled2 ? 0 : 1;
            }
            if (mccCFVUControlled2) {
                return -1;
            }
            boolean mccOrgunitValidated1 = MCCWorkflowHelper.this.isMCCOrgUnitValidated(c1);
            boolean mccOrgunitValidated2 = MCCWorkflowHelper.this.isMCCOrgUnitValidated(c2);
            if (mccOrgunitValidated1) {
                return mccOrgunitValidated2 ? 0 : 1;
            }
            if (mccOrgunitValidated2) {
                return -1;
            }
            boolean mccOrgunitControlled1 = MCCWorkflowHelper.this.isMCCOrgUnitControlled(c1);
            boolean mccOrgunitControlled2 = MCCWorkflowHelper.this.isMCCOrgUnitControlled(c2);
            if (mccOrgunitControlled1) {
                return mccOrgunitControlled2 ? 0 : 1;
            }
            if (mccOrgunitControlled2) {
                return -1;
            }
            boolean rulesMentionValidated1 = RulesManager.isRulesEnabled() && MCCWorkflowHelper.this.isRulesValidated(c1);
            boolean mccMentionValidated1 = MCCWorkflowHelper.this.isMCCValidated(c1);
            boolean rulesValidated2 = RulesManager.isRulesEnabled() && MCCWorkflowHelper.this.isRulesValidated(c2);
            boolean mccMentionValidated2 = MCCWorkflowHelper.this.isMCCValidated(c2);
            if (rulesMentionValidated1 && mccMentionValidated1) {
                if (!mccMentionValidated2 || !rulesValidated2) {
                    return 1;
                }
                return 0;
            }
            if (rulesMentionValidated1 || mccMentionValidated1) {
                if (rulesValidated2 && !mccMentionValidated2 || !rulesValidated2 && mccMentionValidated2) {
                    return 0;
                }
                if (rulesValidated2 && mccMentionValidated2) {
                    return -1;
                }
                return 1;
            }
            return !rulesValidated2 && !mccMentionValidated2 ? 0 : -1;
        }
    }

    private final class ContainerMCCRulesStatusComparator
    implements Comparator<Container> {
        private ContainerMCCRulesStatusComparator() {
        }

        @Override
        public int compare(Container c1, Container c2) {
            boolean rulesValidated2;
            boolean mccValidated1 = MCCWorkflowHelper.this.isMCCCFVUValidated(c1);
            boolean mccValidated2 = MCCWorkflowHelper.this.isMCCCFVUValidated(c2);
            if (mccValidated1) {
                return mccValidated2 ? 0 : 1;
            }
            if (mccValidated2) {
                return -1;
            }
            boolean mccCFVUControlled1 = MCCWorkflowHelper.this.isMCCCFVUControlled(c1);
            boolean mccCFVUControlled2 = MCCWorkflowHelper.this.isMCCCFVUControlled(c2);
            if (mccCFVUControlled1) {
                return mccCFVUControlled2 ? 0 : 1;
            }
            if (mccCFVUControlled2) {
                return -1;
            }
            boolean mccOrgunitValidated1 = MCCWorkflowHelper.this.isMCCOrgUnitValidated(c1);
            boolean mccOrgunitValidated2 = MCCWorkflowHelper.this.isMCCOrgUnitValidated(c2);
            if (mccOrgunitValidated1) {
                return mccOrgunitValidated2 ? 0 : 1;
            }
            if (mccOrgunitValidated2) {
                return -1;
            }
            boolean mccOrgunitControlled1 = MCCWorkflowHelper.this.isMCCOrgUnitControlled(c1);
            boolean mccOrgunitControlled2 = MCCWorkflowHelper.this.isMCCOrgUnitControlled(c2);
            if (mccOrgunitControlled1) {
                return mccOrgunitControlled2 ? 0 : 1;
            }
            if (mccOrgunitControlled2) {
                return -1;
            }
            boolean rulesValidated1 = RulesManager.isRulesEnabled() && MCCWorkflowHelper.this.isRulesValidated(c1);
            boolean bl = rulesValidated2 = RulesManager.isRulesEnabled() && MCCWorkflowHelper.this.isRulesValidated(c2);
            if (rulesValidated1) {
                return rulesValidated2 ? 0 : 1;
            }
            return rulesValidated2 ? -1 : 0;
        }
    }

    private final class ContainerMCCFieldsStatusComparator
    implements Comparator<Container> {
        private ContainerMCCFieldsStatusComparator() {
        }

        @Override
        public int compare(Container c1, Container c2) {
            boolean mccValidated1 = MCCWorkflowHelper.this.isMCCCFVUValidated(c1);
            boolean mccValidated2 = MCCWorkflowHelper.this.isMCCCFVUValidated(c2);
            if (mccValidated1) {
                return mccValidated2 ? 0 : 1;
            }
            if (mccValidated2) {
                return -1;
            }
            boolean mccCFVUControlled1 = MCCWorkflowHelper.this.isMCCCFVUControlled(c1);
            boolean mccCFVUControlled2 = MCCWorkflowHelper.this.isMCCCFVUControlled(c2);
            if (mccCFVUControlled1) {
                return mccCFVUControlled2 ? 0 : 1;
            }
            if (mccCFVUControlled2) {
                return -1;
            }
            boolean mccOrgunitValidated1 = MCCWorkflowHelper.this.isMCCOrgUnitValidated(c1);
            boolean mccOrgunitValidated2 = MCCWorkflowHelper.this.isMCCOrgUnitValidated(c2);
            if (mccOrgunitValidated1) {
                return mccOrgunitValidated2 ? 0 : 1;
            }
            if (mccOrgunitValidated2) {
                return -1;
            }
            boolean mccOrgunitControlled1 = MCCWorkflowHelper.this.isMCCOrgUnitControlled(c1);
            boolean mccOrgunitControlled2 = MCCWorkflowHelper.this.isMCCOrgUnitControlled(c2);
            if (mccOrgunitControlled1) {
                return mccOrgunitControlled2 ? 0 : 1;
            }
            if (mccOrgunitControlled2) {
                return -1;
            }
            boolean mccMentionValidated1 = MCCWorkflowHelper.this.isMCCValidated(c1);
            boolean mccMentionValidated2 = MCCWorkflowHelper.this.isMCCValidated(c2);
            if (mccMentionValidated1) {
                return mccMentionValidated2 ? 0 : 1;
            }
            return mccMentionValidated2 ? -1 : 0;
        }
    }
}

