/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.rule.observations;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.TraversableProgramPart;
import org.ametys.plugins.odfpilotage.rule.RulesManager;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public abstract class AbstractRulesStepObserver
extends AbstractLogEnabled
implements Observer,
Contextualizable,
Serviceable {
    private static final String __MODIFIED_RULE_CODES_KEY = "modified-rule-codes-key";
    private static final String __DEGREES_KEY = "degrees-key";
    private static final String __REGIMES_KEY = "regimes-key";
    private static final String __NB_SESSIONS_KEY = "nb-sessions-key";
    private static final String __CHILD_CONTAINERS = "child-containers";
    protected ODFHelper _odfHelper;
    protected Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._odfHelper = (ODFHelper)manager.lookup(ODFHelper.ROLE);
    }

    public boolean supports(Event event) {
        if (!RulesManager.isRulesEnabled()) {
            return false;
        }
        if (event.getId().equals(this.getSupportedEventId())) {
            Content content = (Content)event.getArguments().get("content");
            return this.supportsContent(content);
        }
        return false;
    }

    public int getPriority() {
        return 100;
    }

    protected abstract String getSupportedEventId();

    protected abstract boolean supportsContent(Content var1);

    protected void _addOldModifiedRuleCodes(Content content, List<String> modifiedRuleCodes) {
        this._setRequestAttribute(__MODIFIED_RULE_CODES_KEY, content, modifiedRuleCodes);
    }

    protected List<String> _getOldModifiedRuleCodes(Content content) {
        return this._getRequestAttribute(__CHILD_CONTAINERS, content, __ -> List.of());
    }

    protected void _addOldDegreeIds(Content content, List<String> degreeIds) {
        this._setRequestAttribute(__DEGREES_KEY, content, degreeIds);
    }

    protected List<String> _getOldDegreeIds(Content content) {
        return this._getRequestAttribute(__DEGREES_KEY, content, __ -> List.of());
    }

    protected void _addOldRegimeIds(Content content, List<String> regimeIds) {
        this._setRequestAttribute(__REGIMES_KEY, content, regimeIds);
    }

    protected List<String> _getOldRegimeIds(Content content) {
        return this._getRequestAttribute(__REGIMES_KEY, content, __ -> List.of());
    }

    protected void _addOldNbSessions(Content content, String nbSessions) {
        this._setRequestAttribute(__NB_SESSIONS_KEY, content, nbSessions);
    }

    protected String _getOldNumberOfSessions(Content content) {
        return this._getRequestAttribute(__NB_SESSIONS_KEY, content, __ -> null);
    }

    protected void _addOldChildContainers(Content content, Set<Container> containers) {
        this._setRequestAttribute(__CHILD_CONTAINERS, content, containers);
    }

    protected Set<Container> _getOldChildContainers(Content content) {
        return this._getRequestAttribute(__CHILD_CONTAINERS, content, __ -> Set.of());
    }

    protected Set<Container> _getChildContainerOfTypeYear(TraversableProgramPart programPart) {
        HashSet<Container> containers = new HashSet<Container>();
        for (ProgramItem child : programPart.getProgramPartChildren()) {
            if (this._odfHelper.isContainerOfTypeYear((Content)child)) {
                containers.add((Container)child);
            }
            if (!(child instanceof TraversableProgramPart)) continue;
            TraversableProgramPart childProgramPart = (TraversableProgramPart)child;
            containers.addAll(this._getChildContainerOfTypeYear(childProgramPart));
        }
        return containers;
    }

    private <T> T _getRequestAttribute(String attributeName, Content content, Function<Content, T> defaultValue) {
        return this._getRequestAttribute(ContextHelper.getRequest((Context)this._context), attributeName).computeIfAbsent(content, defaultValue);
    }

    private <T> Map<Content, T> _getRequestAttribute(Request request, String attributeName) {
        return Optional.of(request).map(r -> (Map)r.getAttribute(attributeName)).orElseGet(HashMap::new);
    }

    private <T> void _setRequestAttribute(String attributeName, Content content, T value) {
        Request request = ContextHelper.getRequest((Context)this._context);
        Map<Content, T> attribute = this._getRequestAttribute(request, attributeName);
        attribute.put(content, value);
        request.setAttribute(attributeName, attribute);
    }
}

