/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.tool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.languages.Language;
import org.ametys.cms.languages.LanguagesManager;
import org.ametys.cms.repository.Content;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.JSONUtils;
import org.ametys.core.util.ServerCommHelper;
import org.ametys.odf.catalog.Catalog;
import org.ametys.odf.catalog.CatalogsManager;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfpilotage.helper.ReportHelper;
import org.ametys.plugins.odfpilotage.manager.PilotageLogFileManager;
import org.ametys.plugins.odfpilotage.report.PilotageReport;
import org.ametys.plugins.odfpilotage.report.ReportExtensionPoint;
import org.ametys.plugins.odfpilotage.tool.PilotageFileFilter;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.commons.io.comparator.SizeFileComparator;
import org.apache.commons.lang.StringUtils;

public class ListReportsAction
extends ServiceableAction {
    private static final String _CRITERIA_FILENAME = "filename";
    private static final String _CRITERIA_FILE_TYPE = "reportType";
    private static final String _CRITERIA_TARGET = "target";
    private static final String _CRITERIA_CATALOG = "catalog";
    private static final String _CRITERIA_LAST_MODIFIED_AFTER = "lastModifiedAfter";
    private static final String _CRITERIA_LAST_MODIFIED_BEFORE = "lastModifiedBefore";
    private static final String _COLUMN_FILENAME = "reportfile";
    private static final String _COLUMN_LAST_MODIFIED = "lastModified";
    private static final String _COLUMN_LENGTH = "length";
    private static final String _COLUMN_TYPE = "type";
    private static final String _COLUMN_GENERATION_DATE = "generationDate";
    private static final String _COLUMN_OUTPUT_FORMAT = "outputFormat";
    private static final String _COLUMN_CATALOG = "catalog";
    private static final String _COLUMN_LANG = "lang";
    private static final String _COLUMN_TARGET = "target";
    private static final String _COLUMN_CONTEXT = "context";
    private static final String _COLUMN_MANIFEST = "manifest";
    private static final String _COLUMN_LOG_FILE = "logfile";
    private static final Map<String, Comparator<File>> _NAME_TO_COMPARATOR = new HashMap<String, Comparator<File>>();
    protected ServerCommHelper _serverCommHelper;
    protected JSONUtils _jsonUtils;
    protected PilotageLogFileManager _pilotageLogFileManager;
    protected ReportHelper _reportHelper;
    protected AmetysObjectResolver _resolver;
    protected ReportExtensionPoint _reportEP;
    protected LanguagesManager _languageManager;
    protected CatalogsManager _catalogManager;
    protected ContentHelper _contentHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._serverCommHelper = (ServerCommHelper)smanager.lookup(ServerCommHelper.ROLE);
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
        this._pilotageLogFileManager = (PilotageLogFileManager)((Object)smanager.lookup(PilotageLogFileManager.ROLE));
        this._reportHelper = (ReportHelper)smanager.lookup(ReportHelper.ROLE);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._reportEP = (ReportExtensionPoint)((Object)smanager.lookup(ReportExtensionPoint.ROLE));
        this._languageManager = (LanguagesManager)smanager.lookup(LanguagesManager.ROLE);
        this._catalogManager = (CatalogsManager)smanager.lookup(CatalogsManager.ROLE);
        this._contentHelper = (ContentHelper)smanager.lookup(ContentHelper.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Map jsParameters = this._serverCommHelper.getJsParameters();
        Map searchParams = (Map)jsParameters.get("values");
        File[] reportFiles = this._getReportFiles(searchParams);
        Integer offset = this._getIntValue(jsParameters, "start", 0);
        Integer limit = this._getIntValue(jsParameters, "limit", Integer.MAX_VALUE);
        List<Map<String, Object>> results = this._getReportResults(reportFiles, offset, limit, this._getSortList(jsParameters.get("sort")), searchParams);
        HashMap<String, Object> objectToRead = new HashMap<String, Object>();
        objectToRead.put("items", results);
        objectToRead.put("total", reportFiles.length);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, objectToRead);
        return EMPTY_MAP;
    }

    private int _getIntValue(Map<String, Object> values, String key, int defaultValue) {
        if (values.containsKey(key)) {
            return Integer.valueOf(values.get(key).toString());
        }
        return defaultValue;
    }

    private File[] _getReportFiles(Map<String, Object> parameters) {
        PilotageFileFilter filter = new PilotageFileFilter(this._getZonedDateTimeFromParameters(parameters, _CRITERIA_LAST_MODIFIED_AFTER), this._getZonedDateTimeFromParameters(parameters, _CRITERIA_LAST_MODIFIED_BEFORE));
        return this._reportHelper.getPilotageFolder().listFiles(filter);
    }

    private ZonedDateTime _getZonedDateTimeFromParameters(Map<String, Object> parameters, String parameterName) {
        return Optional.ofNullable(parameters).map(p -> p.get(parameterName)).map(Object::toString).map(DateUtils::parseLocalDate).map(ld -> DateUtils.asZonedDateTime((LocalDate)ld, null)).orElse(null);
    }

    private List<Map<String, Object>> _getReportResults(File[] reportFiles, Integer offset, Integer limit, List<Object> sort, Map<String, Object> parameters) {
        LinkedList<Map<String, Object>> reports = new LinkedList<Map<String, Object>>();
        Predicate<ZipContent> dataFilter = this._createFilterOnZipContent(parameters);
        int count = 0;
        for (File reportFile : this._sortFiles(reportFiles, sort)) {
            if (count < offset + limit) {
                ZipContent zipContent = this._getZipContent(reportFile);
                if (!dataFilter.test(zipContent)) continue;
                if (count >= offset) {
                    this._addFileToReport(reports, reportFile, zipContent.manifestData());
                }
                ++count;
                continue;
            }
            if (count > offset + limit) break;
        }
        return reports;
    }

    private Predicate<ZipContent> _createFilterOnZipContent(Map<String, Object> parameters) {
        String reportType = MapUtils.getString(parameters, (Object)_CRITERIA_FILE_TYPE);
        String target = MapUtils.getString(parameters, (Object)"target");
        String catalog = MapUtils.getString(parameters, (Object)"catalog");
        String filename = MapUtils.getString(parameters, (Object)_CRITERIA_FILENAME);
        if (StringUtils.isBlank((String)reportType) && StringUtils.isBlank((String)target) && StringUtils.isBlank((String)catalog) && StringUtils.isBlank((String)filename)) {
            return __ -> true;
        }
        Predicate<ZipContent> dataFilter = z -> z.manifestData() != null;
        if (StringUtils.isNotBlank((String)reportType)) {
            dataFilter = dataFilter.and(z -> reportType.equalsIgnoreCase((String)z.manifestData().get(_COLUMN_TYPE)));
        }
        if (StringUtils.isNotBlank((String)target)) {
            dataFilter = dataFilter.and(z -> target.equalsIgnoreCase((String)z.manifestData().get("target")));
        }
        if (StringUtils.isNotBlank((String)catalog)) {
            dataFilter = dataFilter.and(z -> this._checkCatalog((ZipContent)z, catalog));
        }
        if (StringUtils.isNotBlank((String)filename)) {
            dataFilter = dataFilter.and(z -> this._zipContainsFile((ZipContent)z, filename));
        }
        return dataFilter;
    }

    private boolean _checkCatalog(ZipContent zipContent, String catalog) {
        String programId;
        String zipContentCatalog = (String)zipContent.manifestData().get("catalog");
        if (StringUtils.isNotBlank((String)zipContentCatalog)) {
            return catalog.equalsIgnoreCase(zipContentCatalog);
        }
        if (PilotageReport.PilotageReportTarget.PROGRAM.name().equalsIgnoreCase((String)zipContent.manifestData().get("target")) && (programId = (String)zipContent.manifestData().get("program")) != null) {
            try {
                Program program = (Program)this._resolver.resolveById(programId);
                return catalog.equals(program.getCatalog());
            }
            catch (UnknownAmetysObjectException e) {
                this.getLogger().warn("The content '" + programId + "' has probably been deleted. The catalog filter could not be applied");
            }
        }
        return false;
    }

    private boolean _zipContainsFile(ZipContent zipContent, String fileNameToFind) {
        return zipContent.filenames().stream().anyMatch(filename -> StringUtils.containsIgnoreCase((String)filename, (String)fileNameToFind));
    }

    private ZipContent _getZipContent(File reportFile) {
        ZipContent zipContent;
        ZipFile zipFile = new ZipFile(reportFile);
        try {
            Map manifestData = null;
            ZipEntry zipEntry = zipFile.getEntry("manifest.json");
            if (zipEntry != null) {
                try (InputStream is = zipFile.getInputStream(zipEntry);){
                    String manifestContent = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    manifestData = this._jsonUtils.convertJsonToMap(manifestContent);
                }
            }
            ArrayList<String> filenames = new ArrayList<String>();
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry fileEntry = entries.nextElement();
                if (fileEntry == null || "manifest.json".equals(fileEntry.getName())) continue;
                filenames.add(fileEntry.getName());
            }
            zipContent = new ZipContent(manifestData, filenames);
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.getLogger().error("An error occured while reading the manifest.json file of " + reportFile.getName(), (Throwable)e);
                return null;
            }
        }
        zipFile.close();
        return zipContent;
    }

    private void _addFileToReport(List<Map<String, Object>> reports, File reportFile, Map<String, Object> manifestData) {
        String filename = reportFile.getName();
        HashMap<String, Object> report = new HashMap<String, Object>();
        report.put(_COLUMN_FILENAME, filename);
        report.put(_COLUMN_LENGTH, String.valueOf(reportFile.length()));
        report.put(_COLUMN_LAST_MODIFIED, DateUtils.epochMilliToString((long)reportFile.lastModified()));
        if (manifestData != null) {
            report.put(_COLUMN_MANIFEST, manifestData);
            report.putAll(this._convertManifestToColumns(manifestData));
            File logFile = this._getLogFile(manifestData);
            if (logFile != null) {
                report.put(_COLUMN_LOG_FILE, logFile.getName());
            }
        }
        reports.add(report);
    }

    private Map<String, Object> _convertManifestToColumns(Map<String, Object> manifestData) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put(_COLUMN_TYPE, this._getReportTypeInfos((String)manifestData.get(_COLUMN_TYPE)));
        infos.put(_COLUMN_GENERATION_DATE, manifestData.get("date"));
        infos.put(_COLUMN_OUTPUT_FORMAT, manifestData.get(_COLUMN_OUTPUT_FORMAT));
        String target = manifestData.get("target").toString().toUpperCase();
        infos.put("target", target);
        if (target.equals(PilotageReport.PilotageReportTarget.ORGUNIT.name())) {
            String contextId = (String)manifestData.get("orgunit");
            if (StringUtils.isNotEmpty((String)contextId)) {
                infos.put(_COLUMN_CONTEXT, this._getContentInfos((String)manifestData.get("orgunit")));
            }
            infos.put("catalog", this._getCatalogInfos((String)manifestData.get("catalog")));
            infos.put(_COLUMN_LANG, this._getLanguageInfos((String)manifestData.get(_COLUMN_LANG)));
        } else if (target.equals(PilotageReport.PilotageReportTarget.PROGRAM.name())) {
            String programId = manifestData.get("program").toString();
            infos.put(_COLUMN_CONTEXT, this._getContentInfos(programId));
            try {
                Program program = (Program)this._resolver.resolveById(programId);
                infos.put("catalog", this._getCatalogInfos(program.getCatalog()));
                infos.put(_COLUMN_LANG, this._getLanguageInfos(program.getLanguage()));
            }
            catch (UnknownAmetysObjectException e) {
                this.getLogger().warn("The content '" + programId + "' has probably been deleted.");
            }
        }
        return infos;
    }

    private Map<String, Object> _getReportTypeInfos(String typeId) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("value", typeId);
        PilotageReport report = (PilotageReport)this._reportEP.getExtension(typeId);
        if (report != null) {
            infos.put("label", report.getLabel());
        }
        return infos;
    }

    private Map<String, Object> _getContentInfos(String contentId) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("id", contentId);
        try {
            Content content = (Content)this._resolver.resolveById(contentId);
            infos.put("title", content.getTitle());
            infos.put("isSimple", this._contentHelper.isSimple(content));
        }
        catch (UnknownAmetysObjectException unknownAmetysObjectException) {
            // empty catch block
        }
        return infos;
    }

    private Map<String, Object> _getCatalogInfos(String name) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("value", name);
        Catalog catalog = this._catalogManager.getCatalog(name);
        if (catalog != null) {
            infos.put("label", catalog.getTitle());
        }
        return infos;
    }

    private Map<String, Object> _getLanguageInfos(String lang) {
        Language language;
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("code", lang);
        if (lang != null && (language = this._languageManager.getLanguage(lang)) != null) {
            infos.put("icon", language.getSmallIcon());
            infos.put("label", language.getLabel());
        }
        return infos;
    }

    private File _getLogFile(Map<String, Object> manifestData) {
        return Optional.ofNullable(manifestData.get(_COLUMN_TYPE)).map(String.class::cast).map(arg_0 -> ((ReportExtensionPoint)this._reportEP).getExtension(arg_0)).map(PilotageReport::getType).map(type -> type + "-" + String.valueOf(manifestData.get("date")) + ".log").map(filename -> new File(this._pilotageLogFileManager.getLogsDirectory(), (String)filename)).filter(File::exists).orElse(null);
    }

    private List<Object> _getSortList(Object sortValues) {
        if (sortValues != null) {
            return this._jsonUtils.convertJsonToList(sortValues.toString());
        }
        return null;
    }

    private File[] _sortFiles(File[] files, List<Object> sortList) {
        if (sortList != null) {
            for (Object sortValueObj : sortList.reversed()) {
                Map sortValue = (Map)sortValueObj;
                Comparator<File> comparator = _NAME_TO_COMPARATOR.get(sortValue.get("property"));
                Object direction = sortValue.get("direction");
                if (direction != null && direction.toString().equalsIgnoreCase("DESC")) {
                    comparator = Collections.reverseOrder(comparator);
                }
                Arrays.sort(files, comparator);
            }
        }
        return files;
    }

    static {
        _NAME_TO_COMPARATOR.put(_COLUMN_FILENAME, NameFileComparator.NAME_INSENSITIVE_COMPARATOR);
        _NAME_TO_COMPARATOR.put(_COLUMN_LAST_MODIFIED, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        _NAME_TO_COMPARATOR.put(_COLUMN_LENGTH, SizeFileComparator.SIZE_COMPARATOR);
    }

    private record ZipContent(Map<String, Object> manifestData, List<String> filenames) {
    }
}

