/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.data.EducationalPath;
import org.ametys.odf.program.Container;
import org.ametys.odf.tree.AbstractStaticODFTreeIndicator;
import org.ametys.odf.tree.ODFTreeIndicator;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class CourseStepHolderIndicator
extends AbstractStaticODFTreeIndicator {
    private AmetysObjectResolver _resolver;
    private ODFHelper _odfHelper;
    private PilotageHelper _pilotageHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._odfHelper = (ODFHelper)smanager.lookup(ODFHelper.ROLE);
        this._pilotageHelper = (PilotageHelper)((Object)smanager.lookup(PilotageHelper.ROLE));
    }

    public ODFTreeIndicator.IndicatorData getIndicatorData(Content content) {
        if (content instanceof Course) {
            Course course = (Course)content;
            String stepHolderId = Optional.of(course).map(c -> (ContentValue)c.getValue("etapePorteuse")).map(ContentValue::getContentId).orElse(null);
            if (stepHolderId != null) {
                try {
                    Container container = (Container)this._resolver.resolveById(stepHolderId);
                    boolean isPartOfStructure = this._isPartOfStructure(course, container);
                    Map<String, I18nizableText> i18nParams = Map.of("title", new I18nizableText(container.getTitle()), "code", new I18nizableText(container.getDisplayCode()));
                    if (isPartOfStructure) {
                        return new ODFTreeIndicator.IndicatorData(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_CONTENTS_TREE_INDICATORS_STEP_HOLDING_COURSE", i18nParams), null, "ametysicon-arrow-right-out", Map.of("stepHolderId", stepHolderId));
                    }
                    return new ODFTreeIndicator.IndicatorData(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_CONTENTS_TREE_INDICATORS_STEP_HOLDING_COURSE_INVALID", i18nParams), null, "ametysicon-arrow-right-out red-color", Map.of("error", true));
                }
                catch (UnknownAmetysObjectException e) {
                    return new ODFTreeIndicator.IndicatorData(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_CONTENTS_TREE_INDICATORS_STEP_HOLDING_COURSE_UNKNOWN"), null, "ametysicon-arrow-right-out red-color", Map.of("error", true));
                }
            }
            PilotageHelper.StepHolderStatus stepHolderStatus = (PilotageHelper.StepHolderStatus)((Object)this._pilotageHelper.getStepHolder((ProgramItem)course).getLeft());
            if (stepHolderStatus.equals((Object)PilotageHelper.StepHolderStatus.MULTIPLE)) {
                Set<Container> courseSteps = this._pilotageHelper.getSteps((ProgramItem)course);
                ArrayList<Map<String, String>> availableStepHolders = new ArrayList<Map<String, String>>();
                for (Container container : courseSteps) {
                    Map<String, I18nizableText> i18nParamsForStep = Map.of("title", new I18nizableText(container.getTitle()), "code", new I18nizableText(container.getCode()));
                    availableStepHolders.add(Map.of("label", new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_CONTENTS_TREE_INDICATORS_MULTIPLE_STEP_HOLDERS_HOLDER_LABEL", i18nParamsForStep), "id", container.getId()));
                }
                return new ODFTreeIndicator.IndicatorData(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_CONTENTS_TREE_INDICATORS_MULTIPLE_STEP_HOLDERS"), null, "ametysicon-arrow-right-out orange-color", Map.of("error", true, "availableStepHolders", availableStepHolders));
            }
        }
        return null;
    }

    private boolean _isPartOfStructure(Course course, Container container) {
        List ancestorPaths = this._odfHelper.getEducationalPaths((ProgramItem)course);
        for (EducationalPath ancestorPath : ancestorPaths) {
            if (!ancestorPath.resolveProgramItems(this._resolver).anyMatch(p -> p.equals((Object)container))) continue;
            return true;
        }
        return false;
    }
}

